﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<div class="spb-space-url">
    <% 
        string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
        User currentDomainUser = Users.GetUser(userDomainName, false);
        int applicationID = ApplicationIDs.Instance().User();
        string friendlyUrl = string.Empty;
        if (UserDomainConfiguration.Instance().UseFriendlyUrl)
            friendlyUrl = string.Format(UserDomainConfiguration.Instance().FriendlyUrlPattern, Html.GetParameterFromRouteDateOrQueryString("userDomainName"));
        else
            friendlyUrl =Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("Home", "UserDomain", new RouteValueDictionary { { "userDomainName", userDomainName } })); %>
    <p>
        <a href="<%=friendlyUrl %>">
            <%=friendlyUrl%></a></p>
    <%=SPBHtmlHelper.Instance().LinkButton("Copy", GetResourceString("Action_Copy", applicationID),ButtonSizes.Default,HighlightStyles.Default,new RouteValueDictionary {{"onclick","javascript:setCopy('"+friendlyUrl+"');return false;"}},null)%>
    <%=SPBHtmlHelper.Instance().LinkButton("Collection", GetResourceString("Action_Collection", applicationID), ButtonSizes.Default, HighlightStyles.Default, new RouteValueDictionary { { "onclick", "Collection()" } }, null)%>
</div>

<script type="text/javascript">
    function Collection() {
        addBookmark('<%=string.Format("{1}{0}{2}", Globals.BrowserTitleSeparator, currentDomainUser.DisplayName, Globals.SiteName)%>', '<%=friendlyUrl %>')

    }
</script>

