﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<UserCategory>" %>
<%  int? categoryID = (int?)ViewData["categoryID"];
    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().Photo();
    int userApplicationID = ApplicationIDs.Instance().User();
    if (TempData["statusMessageData"] != null)
    {
        StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("statusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData));
        if (statusMessageData.MessageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">$.nyroModalRemove();refresh();</script>"));
        }
        TempData["statusMessageData"] = null;
    }
%>

<spb:Script runat="server" ID="jquery_form" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
    ForceLoad="true" SetExpireDays="30"> </spb:Script>
<form id="EditUserCategory" class="tn-helper-reset nyroModal" action="<%=SPBUrlHelper.Action("CreateUpdateUserCategory","Photo",new RouteValueDictionary{{"userDomainName",userDomainName},{"categoryID",categoryID}}) %>"
method="post">
  <div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom">
      <% if (Model.CategoryID <= 0) Response.Write(GetResourceString("Title_NewAlbum", applicationID)); else Response.Write(GetResourceString("Title_EditAlbum", applicationID)); %>
    </h4>
    <div class="tn-form-row">
      <label class="tn-form-label"> <%=GetResourceString("Label_GalleryName",applicationID)%><%=GetResourceString("Common_Colon") %></label>
      <input type="text" name="categoryName" id="categoryName" value="<%=Model.CategoryName %>"
            class="tn-textbox tn-input-medium tn-border-gray" maxlength="100" />
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> <%=GetResourceString("Label_OrderNO")%><%=GetResourceString("Common_Colon") %> </label>
      <input type="text" name="displayOrder" id="displayOrder" value="<%=Model.DisplayOrder%>"
            class="tn-textbox tn-input-medium tn-border-gray" maxlength="100" />
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> <%=GetResourceString("Label_PrivacySetting")%><%=GetResourceString("Common_Colon") %> </label>
      <%=SPBHtmlHelper.Instance().PrivacyStatusesDropDownList("setPhotoPirvacyStatus", "tn-dropdownlist", Model.PrivacyStatus, Model.Password, UserTypes.PersonUser)%> </div>
    <div class="tn-form-row tn-form-row-button">
      <label class="tn-form-label"> </label>
     <%=SPBHtmlHelper.Instance().SubmitButton("newUserTagSubmitButton", GetResourceString("Button_OK"),ButtonSizes.Default,null,null)%> <%=SPBHtmlHelper.Instance().Button("cancelButton", GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Default, new RouteValueDictionary { { "class", "nyroModalClose" } },null)%> </div>
  </div>
</form>
<script type="text/javascript">
    $(document).ready(function() {
        $("#EditUserCategory").validate({
            rules: {
                categoryName: { required: true, rangelength: [1, 20] },
                displayOrder: { required: true,digits: true }
            },
            messages: {
                categoryName: { required: "<%=GetResourceString("Validate_AlbumName_Required",applicationID)%>", rangelength: "<%=string.Format(GetResourceString("Validate_Pattern_AlbumName_Rangelength", applicationID),20)%>" },
                displayOrder: { required: "<%=GetResourceString("Validate_InputDisplayOrder",applicationID)%>",digits: "<%=GetResourceString("Validate_DisplayOrder_Digits",userApplicationID)%>" }
            }
        });
        $("#newUserTagSubmitButton").click(function() {
            if (!$("#EditUserCategory").valid()) {
                return false;
            }
        });
    }); 
</script>
