﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<PhotoThread>>" %>
<%
    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().Photo();
%>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-user-photos-block spb-user-photos-new">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <span class="tn-helper-right"><a href="<%=SPBUrlHelper.Action("ListPhotos", "Photo", new RouteValueDictionary { { "userDomainName", userDomainName } })%>">
            <%=GetResourceString("Action_More") %></a></span>
        <h3 class="tn-helper-reset">
            <%=GetResourceString("Navigation_LatestPhoto", applicationID)%></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <%if (Model != null && Model.Count > 0)
          { %>
        <ul class="tn-photo-list tn-widget tn-helper-reset tn-helper-clearfix">
            <%int i = 0;
              foreach (PhotoThread thread in Model)
              {
                  if (thread.PrivacyStatus != PrivacyStatuses.Public )
                      continue;
                  i++;
                  if (i > 2)
                      break;
            %>
            <li class="tn-photo-item">
                <p class="tn-photo-wrap tn-widget-content tn-border-gray">
                    <%=SPBHtmlHelper.Instance().ShowPicture(thread, PhotoImageType.Thumbnail, SiteUrls.Instance().ShowPicture(userDomainName, thread.ThreadID),"_self")%></p>
                <p class="tn-text-heading">
                    <a title="<%=thread.Subject %>" href="<%=SiteUrls.Instance().ShowPicture(userDomainName,thread.ThreadID) %>">
                        <%=StringUtils.Trim(thread.Subject,9,string.Empty) %></a>
                </p>
                <p class="tn-text-note tn-date">
                    <%=Formatter.FormatFriendlyDate(thread.PostDate,false) %></p>
            </li>
            <%
                }
            %>
        </ul>
        <%
            }
          else { Response.Write(GetResourceString("Message_NoPhotos", applicationID)); } 
        %>
    </div>
</div>
<div class="tn-blank10">
</div>
