﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<UserCategory>>" %>
<ul id="photoCategoryListUl" class="albumList">
    <% bool isManager = ViewData.GetBool("isManager",false);
     string userDomainName = Html.GetParameterFromRouteDateOrQueryString("UserDomainName");
     if (ViewData.Model != null && ViewData.Model.Count > 0)
     {
         foreach (UserCategory photoCategory in ViewData.Model)
         {
             if (photoCategory != null)
             {%>
    <li><span class="albumImg uiChromeComponent">
    <% if (isManager) 
                         {%>
    <span class="albumAct icon iconModify"> <span class="albumEdit uiLightHue uiChromeLine"> <span><a href="<%=SPBUrlHelper.Action("EditPhotoCategory", "Photo", new RouteValueDictionary { {"userDomainName",userDomainName} ,{"categoryID",photoCategory.CategoryID} })%>"><%=GetResourceString("Action_Edit")%></a><br/>
    <a href="javascript:;" onclick="if (confirm('<%=GetResourceString("Message_SayDeleteGallery", ApplicationIDs.Instance().Photo())%>')) { $('#photoCategoryListUl').parent().load('<%=SPBUrlHelper.Action("DeletePhotoCategory","Photo",new RouteValueDictionary {  {"userDomainName",userDomainName},{"categoryID",photoCategory.CategoryID}}) %>' )}"><%=GetResourceString("Action_Delete")%></a> </span> </span> </span>
    <%} %>
    <a href="<%=SPBUrlHelper.Action("ListWallPhotos", "Photo", new RouteValueDictionary {{"userDomainName",userDomainName},{"categoryID",photoCategory.CategoryID}})%>"> <img height="75" width="75" src="<%=SiteUrls.Instance().CategoryFeaturedPhotoUrl(photoCategory) %>"/> </a> </span>
        <a class="albumName" href="<%=SPBUrlHelper.Action("ListWallPhotos", "Photo", new RouteValueDictionary { {"userDomainName",userDomainName},{"categoryID",photoCategory.CategoryID} })%>">
            <%=photoCategory.CategoryName %></a> <span class="albumStat"><%=string.Format(GetResourceString("Action_Pattern_PhotoCount",ApplicationIDs.Instance().Photo()),photoCategory.ItemCount) %>
            </span><span class="albumTime"><%=Formatter.FormatDate( photoCategory.DateCreated.Date) %> </span>
    </li>
    <%}
         } 
     } %>
</ul>
