﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<PhotoSection>>" %>
<div id="listFriendsPhotosControlDiv" class="tn-box tn-widget tn-widget-content tn-corner-all spb-user-photos">
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <ul class="tn-photo-list tn-widget tn-helper-reset tn-helper-clearfix">
            <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
              if (ViewData.Model != null && ViewData.Model.Records.Count > 0)
              {
                  foreach (PhotoSection photoSection in ViewData.Model.Records)
                  {
                      if (photoSection != null && photoSection.Owner != null)
                      {%>
            <li class="tn-photo-item">
                <p class="tn-photo-wrap tn-helper-reset tn-widget-content tn-border-gray">
                    <%=SPBHtmlHelper.Instance().ShowPicture(photoSection.MostRecentThreadID, PhotoImageType.Thumbnail, photoSection.MostRecentThreadSubject, SiteUrls.Instance().ShowPicture(photoSection.Owner.UserName, photoSection.MostRecentThreadID), "_blank")%>
                </p>
                <p class="tn-helper-reset tn-text-heading">
                    <a href="<%=SiteUrls.Instance().ShowPicture(photoSection.Owner.UserName, photoSection.MostRecentThreadID) %>"
                        title="<%=photoSection.MostRecentThreadSubject%>">
                        <%=StringUtils.Trim(photoSection.MostRecentThreadSubject,9,string.Empty)%></a></p>
                <p class="tn-helper-reset tn-text-note">
                    <a href="<%=SiteUrls.Instance().UserChannelHome(photoSection.OwnerUserID,ApplicationIDs.Instance().Photo()) %>"
                        title="<%=photoSection.Owner.DisplayName%>">
                        <%=StringUtils.Trim(SPBHtmlHelper.Instance().UserDisplayName(photoSection.Owner.UserID),9,string.Empty)%></a>
                </p>
                <p class="tn-helper-reset tn-text-note tn-date">
                    <%=Formatter.FormatDate(photoSection.MostRecentPostDate,false)%></p>
            </li>
            <%}
                  }
              }%>
        </ul>
        <div class="tn-pagination tn-helper-align-center">
            <%  %>
            <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 10, SPBUrlHelper.Action("Control_ListFriendsPhotos", "Photo", new RouteValueDictionary { { "userDomainName", userDomainName }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
        </div>

        <script type="text/javascript">
            function pageIndexChange(url) {
                $('#listFriendsPhotosControlDiv').load(url);
            }
        </script>

    </div>
</div>
