﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% string userDomainName = (string)ViewData["userDomainName"];
   UserCategory currentCategory = (UserCategory)ViewData["currentCategory"];
   int listPhotoCategoryCount = ViewData.GetInt("listPhotoCategoryCount", 10);
   string title = (string)ViewData["title"];
   List<UserCategory> userCategories = (List<UserCategory>)ViewData.Model; %>
<% if (userCategories != null && userCategories.Count>0)
               {%>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-user-albums-block">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <span class="tn-helper-right"><a href="<%=SPBUrlHelper.Action("Home","Photo",new RouteValueDictionary {{"userDomainName",userDomainName}}) %>">
            <%=GetResourceString("Action_More")%></a></span>
        <h3 class="tn-helper-reset">
            <%=title %></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <ul class="tn-album-list tn-widget tn-helper-reset tn-helper-clearfix">
            <% int i = 0;
                   foreach (UserCategory userCategory in userCategories)
                   {
                       if (i < listPhotoCategoryCount)
                       {
                           if (currentCategory == null || (currentCategory != null && currentCategory.CategoryID != userCategory.CategoryID))
                           {
                               i++;
            %>
            <li class="tn-album-item tn-helper-clearfix">
                <div class="tn-album-cover tn-widget-content tn-border-gray">
                    <div class="tn-photo-wrap tn-widget-content tn-border-gray">
                        <a href="<%=SiteUrls.Instance().ShowPhotoCategory(userDomainName,userCategory.CategoryID) %>">
                            <img src="<%=SiteUrls.Instance().CategoryFeaturedPhotoUrl(userCategory) %>" alt="<%=userCategory.CategoryName %>"></a></div>
                </div>
                <p class="tn-text-heading">
                    <a title="<%=userCategory.CategoryName %>" href="<%=SiteUrls.Instance().ShowPhotoCategory(userDomainName,userCategory.CategoryID) %>">
                        <%=StringUtils.Trim(userCategory.CategoryName,5,string.Empty)%>(<%=userCategory.ItemCount%>)
                    </a>
                </p>
                <p class="tn-text-note tn-date">
                    <%=Formatter.FormatDate(userCategory.DateCreated,false) %></p>
            </li>
            <%}
                           }
                       }%>
        </ul>
    </div>
</div>
<div class="tn-blank10">
</div>
<%}%>