﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<ICollection<UserTag>>" %>
<div class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <span class="tn-helper-right">
           <% if (CurrentUser!=null && (Globals.GetCurrentUser().UserName == Html.GetParameterFromRouteDateOrQueryString("userDomainName") || Globals.GetCurrentUser().IsContentAdministrator))
              {%>
            <a href="<%=SPBUrlHelper.Action("ManagePhotoUserTags", "Photo", new RouteValueDictionary { { "userDomainName", Html.GetParameterFromRouteDateOrQueryString("userDomainName") } }) %>">
   <%=GetResourceString("Action_Manage")%></a>
            <%} %></span>
        <h3 class="tn-helper-reset">
            <%=GetResourceString("Common_UserTag")%></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <% if (Model != null && Model.Count > 0)
           {%>
        <% foreach (UserTag tag in Model)
           { %>
        <a href="<%=SiteUrls.Instance().ListPhotosByUserTag(Html.GetParameterFromRouteDateOrQueryString("userDomainName"),tag.TagName) %>"
            title="<%=tag.TagName %>">
            <%=StringUtils.Trim(tag.TagName, 10)%></a> <em class="tn-text-note">(<%=tag.ItemCount.ToString()%>)</em>&nbsp;&nbsp;&nbsp;
        <% } %>
        <% }
           else { Response.Write(GetResourceString("Message_NoTags", ApplicationIDs.Instance().Photo())); } %>
    </div>
</div>
<div class="tn-blank10">
</div>
