﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<PhotoThread>>" %>
<% PagingDataSet<PhotoThread> photos = (PagingDataSet<PhotoThread>)ViewData.Model;
   bool isManager = (bool)ViewData["IsManager"];
   int categoryID = Html.GetParameterFromRouteDateOrQueryString("categoryID", 0);
   string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
   string tagName = Html.GetParameterFromRouteDateOrQueryString("tagName");

   if (photos != null && photos.Records.Count > 0)
   {
       int returnPageIndex = photos.PageIndex;
       if (photos.TotalRecords == photos.PageSize * (returnPageIndex - 1) + 1)
       {
           returnPageIndex = photos.PageIndex - 1;
       }%>
<div id="ListThumbnailPhotoDiv">
    <ul class="tn-photo-list tn-widget tn-helper-reset tn-helper-clearfix">
        <%foreach (PhotoThread photo in photos.Records)
          {%>
        <li class="tn-photo-item">
            <p class="tn-photo-wrap tn-helper-reset tn-widget-content tn-border-gray">
                <%=SPBHtmlHelper.Instance().ShowPicture(photo, PhotoImageType.Thumbnail, SPBUrlHelper.Action("ShowPhoto", "Photo", new RouteValueDictionary { { "userDomainName", userDomainName }, { "threadID", photo.ThreadID } }), "_self")%>
            </p>
            <p class="tn-helper-reset tn-text-heading">
                <a title="<%=photo.Subject%>" href="<%=SPBUrlHelper.Action("ShowPhoto","Photo",new RouteValueDictionary {{"userDomainName",userDomainName},{"threadID",photo.ThreadID}}) %>">
                    <%=StringUtils.Trim(photo.Subject,9,string.Empty)%></a></p>
            <p class="tn-helper-reset tn-text-note">
                <%if (photo.UserCategory != null)
                  { %>
                <a title="<%=photo.UserCategory.CategoryName %>" href="<%=SiteUrls.Instance().ShowPhotoCategory(userDomainName,photo.UserCategory.CategoryID) %>">
                    <%=StringUtils.Trim(photo.UserCategory.CategoryName,9,string.Empty) %>
                </a>
                <%} %>
            </p>
            <p class="tn-helper-reset tn-text-note tn-date">
                <%=Formatter.FormatDate(photo.PostDate,false)%></p>
        </li>
        <%} %>
    </ul>
    <div class="tn-pagination tn-helper-align-center">
        <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, photos.TotalRecords, photos.PageSize, photos.PageIndex, 11, SPBUrlHelper.Action("Control_ListPhotos", "Photo", new RouteValueDictionary { { "userDomainName", userDomainName }, { "categoryID", categoryID }, { "tagName", tagName }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
    </div>
    <script type="text/javascript">
        function pageIndexChange(url) {
            $('#ListThumbnailPhotoDiv').parent.load(url);
        }
    </script>
</div>
<%} %>
