﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<PhotoThread>>" %>
<%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName"); %>
  <div id="ListTaggedPhotosControlDiv" class="tn-box tn-widget tn-widget-content tn-corner-all spb-user-photos">
              <div class="tn-box-content tn-widget-content tn-corner-bottom">
 <ul class="tn-photo-list tn-widget tn-helper-reset tn-helper-clearfix">
                    <%  foreach (PhotoThread photo in Model.Records)
                        {
                            string userName = UserID2UserNameDictionary.GetUserName(photo.OwnerUserID);
                    %>
                    <li class="tn-photo-item">
                    <p class="tn-photo-wrap tn-helper-reset tn-widget-content tn-border-gray"> <%=SPBHtmlHelper.Instance().ShowPicture(photo.ThreadID, PhotoImageType.Thumbnail, photo.Subject, SiteUrls.Instance().ShowPicture(userName, photo.ThreadID), "_blank")%></p>
                    <p class="tn-helper-reset tn-text-heading"> <a title="<%=photo.Subject%>" href="<%=SiteUrls.Instance().ShowPicture(userName,photo.ThreadID) %>">
                            <%=StringUtils.Trim(photo.Subject,9,string.Empty)%></a> </p>
                    <p class="tn-helper-reset tn-text-note">
 <a href="<%=SiteUrls.Instance().UserChannelHome(photo.OwnerUserID,ApplicationIDs.Instance().Photo()) %>" title="<%=photo.Author%>">
                        <%=StringUtils.Trim(photo.Author,9,string.Empty)%></a>
            </p>
            <%--<p class="tn-helper-reset tn-text-note tn-date">
                
                                            <%=Formatter.FormatDate(photo.PostDate,false)%></p>--%>
                  </li>

                          <%
                        }%>
                  
                       </ul>     
      
            <div class="tn-pagination tn-helper-align-center">
                <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 10, SPBUrlHelper.Action("Control_ListTaggedPhotos", "Photo", new RouteValueDictionary { { "userDomainName", userDomainName }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
            </div>
      </div>
            </div>

    <script type="text/javascript">
        function pageIndexChange(url) {
            $('#ListTaggedPhotosControlDiv').load(url);
        }
    </script>

