﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl" %>
<% PagingDataSet<PhotoThread> photos = (PagingDataSet<PhotoThread>)ViewData.Model;
   int categoryID = Html.GetParameterFromRouteDateOrQueryString("categoryID", 0);
   string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
   string tagName = Html.GetParameterFromRouteDateOrQueryString("tagName");

   if (photos != null && photos.Records.Count > 0)
   {
       int returnPageIndex = photos.PageIndex;
       if (photos.TotalRecords == photos.PageSize * (returnPageIndex - 1) + 1)
       {
           returnPageIndex = photos.PageIndex - 1;
       }%>
<div id="ListThumbnailPhotoDiv">
    <div class="spb-photos-wall-list">
        <%foreach (PhotoThread photo in photos.Records)
          {%>
        <div class="spb-photo-wall-item">
            <div class="spb-photo-container">
                <%=SPBHtmlHelper.Instance().ShowPicture(photo, PhotoImageType.Details, SPBUrlHelper.Action("ShowPhoto", "Photo", new RouteValueDictionary { { "userDomainName", userDomainName }, { "threadID", photo.ThreadID } }), "_self")%></div>
            <p>
                <span class="tn-text-note tn-date tn-helper-right"><%=Formatter.FormatFriendlyDate(photo.PostDate) %></span>
                <strong><a title="<%=photo.Subject%>" href="<%=SPBUrlHelper.Action("ShowPhoto","Photo",new RouteValueDictionary {{"userDomainName",userDomainName},{"threadID",photo.ThreadID}}) %>">
                    <%=StringUtils.Trim(photo.Subject,45)%></a></strong></p>
                <p><%=HtmlUtils.TrimHtml(photo.GetBody(),90) %></p>
                        <% Html.RenderAction<PhotoController>(n => n.Control_PhotoComments(userDomainName, photo.ThreadID, true, returnPageIndex)); %>
        </div>
        <%} %>
    </div>
    <div class="tn-pagination tn-helper-align-center">
        <%=SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, photos.TotalRecords, photos.PageSize, photos.PageIndex)%>
    </div>
</div>
<%} %>
