﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% PagingDataSet<PhotoComment> photoComments = (PagingDataSet<PhotoComment>)ViewData.Model;
   int applicationID = ApplicationIDs.Instance().Photo();
   ApprovalStatuses? nowApprovalStatus = null;
   string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
   if (ViewData["ApprovalStatus"] != null)
       nowApprovalStatus = (ApprovalStatuses)ViewData["ApprovalStatus"];
   if (photoComments != null)
   {%>
<div id="ManagePhotoCommentsDiv">
    <div class="tn-box tn-widget tn-widget-content tn-corner-all">
        <div class="tn-box-content tn-widget-content tn-corner-bottom">
            <form id="ManagePhotoCommentsForm" method="post">
            <div class="tn-filter-controls tn-helper-clearfix tn-border-gray tn-border-bottom">
                <input class="tn-checkbox" type="checkbox" id="checkbox" onclick="checkAll(this,'PhotoCommentsCheckBoxGroup')" /><label
                    class="tn-check-all" for="checkbox"><%=GetResourceString("Label_SelectAllOrNo")%></label>
                <%=SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Button_Approve"), ButtonSizes.Default, HighlightStyles.Default, new RouteValueDictionary { { "onclick", "setPhotoStatue('approve')" } }, null)%>
                <%=SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Button_NoApprove"), ButtonSizes.Default, HighlightStyles.Default, new RouteValueDictionary { { "onclick", "setPhotoStatue('noApprove')" } }, null)%>
                <%=SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Action_Delete"), ButtonSizes.Default, HighlightStyles.Default, new RouteValueDictionary { { "onclick", "setPhotoStatue('delete')" } }, null)%>
                <div class="tn-helper-right">
                    <% if (ViewData["approvalStatus"] == null)
                       {%>
                    <%=SPBHtmlHelper.Instance().ApproveStatusDropDownList("approveDropDownList", null, "tn-dropdownlist", "GetCommentsByApproveStatus()")%>
                    <%}
                       else
                       {%>
                    <%=SPBHtmlHelper.Instance().ApproveStatusDropDownList("approveDropDownList", (ApprovalStatuses)ViewData["approvalStatus"], "tn-dropdownlist", "GetCommentsByApproveStatus()")%>
                    <%} %>
                </div>
                <div class="tn-blank10">
                </div>
            </div>
            <div class="tn-grid">
                <table class="tn-table-grid">
                    <tr class="tn-table-grid-header">
                        <th class="tn-border-gray tn-border-bottom tn-width-check">
                        </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note">
                            <%=GetResourceString("Label_Body")%>
                        </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note">
                            <%=GetResourceString("Action_Thumbnail",ApplicationIDs.Instance().Photo())%>
                        </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note">
                            <%=GetResourceString("Label_IfApproval")%>
                        </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note">
                            <%=GetResourceString("Label_CommentUser")%>
                        </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note">
                            <%=GetResourceString("Label_CommentDate") %>
                        </th>
                    </tr>
                    <% if (photoComments != null && photoComments.Records.Count > 0)
                       {
                           foreach (PhotoComment photoComment in photoComments.Records)
                           {
                               if (photoComment != null)
                               {%>
                    <tr class="tn-table-grid-row">
                        <td class="tn-border-gray tn-border-bottom tn-width-check">
                            <input type="checkbox" class="tn-checkbox" name="PhotoCommentsCheckBoxGroup" value="<%=photoComment.PostID %>" />
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-width-auto">
                            <a href="<%=SiteUrls.Instance().ShowPicture(userDomainName,photoComment.ThreadID)+"#"+photoComment.PostID.ToString() %>"
                                title="<%=HtmlUtils.StripForPreview(photoComment.Body) %>">
                                <%=HtmlUtils.TrimHtml(photoComment.Body, 23)%></a>
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-width-pic">
                            <%=SPBHtmlHelper.Instance().ShowPicture(photoComment.ThreadID, PhotoImageType.Icon,"",SPBUrlHelper.Action("ShowPhoto", "Photo", new RouteValueDictionary { { "userDomainName", userDomainName }, { "threadID", photoComment.ThreadID } }), "_self")%>
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-width-icon1">
                            <% if (photoComment.IsApproved)
                               { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Accept, GetResourceString("Description_CommentAuditinged"))); }
                               else
                               { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Cross, GetResourceString("Description_CommentNotAuditing"))); }%>
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-width-action1 tn-nowrap">
                            <% if (string.IsNullOrEmpty(photoComment.TitleUrl)) Response.Write(photoComment.TitleUrl);
                               else
                               { %>
                            <a href="<%=photoComment.TitleUrl %>">
                                <%=photoComment.Author%>
                            </a>
                            <%} %>
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
                            <%=Formatter.FormatDate(photoComment.PostDate,true) %>
                        </td>
                    </tr>
                    <%
                        }
                           }
                       }%>
                </table>
                <div class="tn-pagination tn-helper-align-center">
                    <%=SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, photoComments.TotalRecords, photoComments.PageSize, photoComments.PageIndex, 7, SPBUrlHelper.Action("ManagePhotoComments", "Photo", new RouteValueDictionary { { "userDomainName", userDomainName },{"approvalStatus",nowApprovalStatus},{"pageIndex","{0}"} }))%>
                </div>
            </div>
            </form>
        </div>
    </div>
    <script type="text/javascript">
        function GetCommentsByApproveStatus() {
            $('#ManagePhotoCommentsForm').ajaxSubmit({ target: '#ManagePhotoCommentsDiv', url: '<%=SPBUrlHelper.Action("ManagePhotoCommentsByApprovalStatus","Photo",new RouteValueDictionary {{"userDomainName",userDomainName},{"pageIndex",photoComments.PageIndex}}) %>' });
        }

        function setPhotoStatue(action) {
            if ($("input[name='PhotoCommentsCheckBoxGroup']:checked").length <= 0) {
                alert('至少选择一条评论');
                return false;
            }

            if (action == 'approve')
                $('#ManagePhotoCommentsForm').ajaxSubmit({ target: '#ManagePhotoCommentsDiv', url: '<%=SPBUrlHelper.Action("SetPhotoCommentsApproveStatus","Photo",new RouteValueDictionary {{"userDomainName",userDomainName},{"isApproved",true}}) %>' });
            else if (action == 'noApprove')
                $('#ManagePhotoCommentsForm').ajaxSubmit({ target: '#ManagePhotoCommentsDiv', url: '<%=SPBUrlHelper.Action("SetPhotoCommentsApproveStatus","Photo",new RouteValueDictionary {{"userDomainName",userDomainName},{"isApproved",false}}) %>' });
            else if (action == 'delete') {
                if (!confirm('确定要删除这些评论吗？')) { return false; }
                $('#ManagePhotoCommentsForm').ajaxSubmit({ target: '#ManagePhotoCommentsDiv', url: '<%=SPBUrlHelper.Action("DeletePhotoComments","Photo",new RouteValueDictionary {{"userDomainName",userDomainName}})  %>', type: 'post' });
            }
        }      
    </script>
</div>
<%} %>
