﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<PhotoThread>>" %>
<% PagingDataSet<PhotoThread> photos = (PagingDataSet<PhotoThread>)ViewData.Model;
   string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
   int? categoryID = Html.GetParameterFromRouteDateOrQueryString<int>("categoryID");
   int applicationID = ApplicationIDs.Instance().Photo();
%>
<div id="listPhotosDiv">
    <spb:Script runat="server" ID="jquery_form" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="menuButton" Src="~/Utility/jquery/plugin/jquery.spb.menuButton.js"
        SetExpireDays="30" />
    <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-photos-manage">
        <div class="tn-box-content tn-widget-content tn-corner-all">
            <%
                if (TempData["StatusMessageData"] != null)
                {
                    StatusMessageData messageData = TempData.Get<StatusMessageData>("StatusMessageData", null);
                    Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageData,3000,false));
                    TempData["StatusMessageData"] = null;
                }
            %>
            <form id="ManagePhotosForm" method="post">
            <div class="tn-list-header">
                <% 
                    List<UserCategory> userCategoryList = ViewData.Get<List<UserCategory>>("userCategoriesList", new List<UserCategory>());
                    List<SiteCategory> allSiteCategoryList = ViewData.Get<List<SiteCategory>>("allSiteCategoryList", new List<SiteCategory>());
                %>
                <div class="tn-toolbar-area tn-helper-clearfix">
                    <div class="tn-helper-right">
                        <select id="PhotoUserCategories" class="tn-dropdownlist">
                            <option selected="selected" value="">
                                <%=GetResourceString("Label_AllCallery",ApplicationIDs.Instance().Photo()) %></option>
                            <%if (userCategoryList != null && userCategoryList.Count > 0)
                              {
                                  foreach (UserCategory userCategory in userCategoryList)
                                  {%>
                            <option <%if (userCategory.CategoryID == categoryID.Value) Response.Write("selected=\"selected\""); %>
                                value="<%=userCategory.CategoryID %>">
                                <%=userCategory.CategoryName%></option>
                            <%}
                              }%>
                        </select>
                    </div>
                    <input class="tn-checkbox" type="checkbox" id="checkAllOrNo" onclick="checkAll(this,'PhotoCheckBoxGroup')" />
                    <label class="tn-check-all" for="checkAllOrNo">
                        <%=GetResourceString("Label_SelectAllOrNo") %></label>
                    <%=SPBHtmlHelper.Instance().LinkButton("deleteButton", GetResourceString("Button_BatchDelete"), "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText, new RouteValueDictionary { { "onclick", "if(ischecked()){if(!confirm('"+GetResourceString("Message_ConfirmDeleteSelectedPhoto",applicationID) +"')){return false;}ajaxSubmitTheForm('delete','"+SPBUrlHelper.Action("DeletePhotos","Photo",new RouteValueDictionary {{"userDomainName",userDomainName},{"categoryID",categoryID}})+"')};"
                        } }, null)%>
                    <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Action_MoveToAlbum",ApplicationIDs.Instance().Photo()), "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.MenuButton, null, new RouteValueDictionary { { "menu", "#setPhotosUserCategoryDiv" } })%>
                    <div id="setPhotosUserCategoryDiv" class="tn-menu-button-position tn-menu tn-helper-reset tn-widget-content">
                        <%--<% Html.RenderAction<PhotoController>(n => n.Control_PhotoUserCategoryDropdownList(userDomainName, null, "photoUserCategoryDDL", "dropDownList")); %>--%>
                        <ul class="tn-menu-list">
                            <%foreach (UserCategory category in userCategoryList)
                              {%>
                            <li class="tn-menu-item" onclick="if(ischecked()){ajaxSubmitTheForm('setUserCategory','<%=SPBUrlHelper.Action("SetPhotosUserCategory", "Photo", new RouteValueDictionary { { "userDomainName", userDomainName }, { "userCategoryID",category.CategoryID },{"showUserCategoryID",categoryID} })%>')}">
                                <label for="setUserTags<%=category.CategoryName%>">
                                    <%=category.CategoryName %></label>
                            </li>
                            <%} %>
                        </ul>
                    </div>
                    <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Action_SiteCategoryBatchSet"), "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.MenuButton, null, new RouteValueDictionary { { "menu", "#setPhotosSiteCategoryDiv" } })%>
                    <div id="setPhotosSiteCategoryDiv" class="tn-menu-button-position tn-menu tn-helper-reset tn-widget-content">
                        <%--<%Html.RenderAction<ChannelController>(n => n.Control_SiteCategoryDropDownList(ApplicationIDs.Instance().Photo(), PhotoConfiguration.Instance().SiteCategoryLevel - 1, "PhotoSiteCategoryDDL", null, "dropDownList")); %>--%>
                        <ul class="tn-menu-list">
                            <%
                                foreach (SiteCategory siteCategory in allSiteCategoryList)
                                {%>
                            <li class="tn-menu-item" onclick="if(ischecked()){ajaxSubmitTheForm('setSiteCategory','<%=SPBUrlHelper.Action("SetPhotosSiteCategory", "Photo", new RouteValueDictionary { { "userDomainName", userDomainName } ,{"siteCategoryID",siteCategory.CategoryID},{"userCategoryID",categoryID}})%>')}">
                                <a class="tn-menu-text" href="javascript:;">
                                    <%string blankSpace = string.Empty; %>
                                    <% 
                                        for (int i = 0; i < siteCategory.Depth; i++)
                                        {
                                            blankSpace = blankSpace + "  ";
                                        }
                                        Response.Write(blankSpace);
                                    %><%=siteCategory.GetMultilingualCategoryName(CurrentUserLanguage)%>
                                </a></li>
                            <%} %>
                        </ul>
                    </div>
                </div>
            </div>
            <ul class="tn-photo-list tn-widget tn-helper-reset tn-helper-clearfix">
                <% if (photos != null && photos.Records.Count > 0)
                   {%>
                <% int returnToPageIndex = ViewData.Model.PageIndex;
                   if (ViewData.Model.TotalRecords == ViewData.Model.PageSize * (returnToPageIndex - 1) + 1)
                   {
                       returnToPageIndex = ViewData.Model.PageIndex - 1;
                   } %>
                <%foreach (PhotoThread photo in photos.Records)
                  { %>
                <li class="tn-photo-item" id="photoli_<%=photo.ThreadID %>"><span name="photospan"
                    value="<%=photo.ThreadID %>" class="tn-check-widget tn-widget-content tn-border-gray"
                    id="photospan_<%=photo.ThreadID %>">
                    <input type="checkbox" name="PhotoCheckBoxGroup" value="<%=photo.ThreadID%>" id="Pid_<%=photo.ThreadID%>"
                        style="display: none" /><span class="tn-icon tn-icon-accept" style="display: none"></span></span>
                    <p id="photo_<%=photo.ThreadID %>" class="tn-photo-wrap tn-widget-content tn-border-gray"
                        name="photop" value="<%=photo.ThreadID %>">
                        <%=SPBHtmlHelper.Instance().ShowPicture(photo, PhotoImageType.Thumbnail) %></p>
                    <p class="tn-text-heading">
                        <a href="<%=SPBUrlHelper.Action("ShowPhoto","Photo",new RouteValueDictionary {{"userDomainName",userDomainName},{"threadID",photo.ThreadID}}) %>">
                            <%=HtmlUtils.TrimHtml(photo.Subject,15) %></a>
                    </p>
                    <p class="tn-text-note">
                        <%=GetResourceString("Title_Callery",ApplicationIDs.Instance().Photo()) %>：
                        <% if (photo.UserCategory != null)
                           { %>
                        <a href="<%=SPBUrlHelper.Action("ListWallPhotos", "Photo", new RouteValueDictionary { {"userDomainName",userDomainName},{"categoryID",photo.UserCategoryID} })%>">
                            <%=HtmlUtils.TrimHtml(photo.UserCategory.CategoryName,12) %></a>
                        <% } %>
                    </p>
                    <p>
                        <span class="tn-action"><a href="<%=SPBUrlHelper.Action("EditPhoto","Photo",new RouteValueDictionary {{"userDomainName",userDomainName},{"threadID",photo.ThreadID}}) %>">
                            <%=GetResourceString("Action_Edit")%>
                        </a></span><span class="tn-action"><a class="tn-action-text" onclick="if (confirm('<%=GetResourceString("Message_ConfirmDelete",ApplicationIDs.Instance().Photo()) %>')) { $('#listPhotosDiv').parent().load('<%=SPBUrlHelper.Action("DeletePhotoThread","Photo",new RouteValueDictionary { {"threadID",photo.ThreadID},{"userDomainName",userDomainName},{"isManage",true},{"pageIndex",returnToPageIndex},{"categoryID",categoryID}}) %>')}"
                            href="javascript:;;">
                            <%=GetResourceString("Action_Delete")%></a> </span>
                    </p>
                </li>
                <%}
                   } %>
            </ul>
            <div class="tn-pagination tn-helper-align-center">
                <% if (Model != null)
                   {%>
                <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, photos.TotalRecords, photos.PageSize, photos.PageIndex, 7, SPBUrlHelper.Action("Control_ManagePhotos", "Photo", new RouteValueDictionary { {"userDomainName",userDomainName},{"categoryID",-1},{"pageIndex","{0}"}}), "pageIndexChange")%>
                <%} %>
            </div>
            </form>
        </div>
    </div>

    <script type="text/javascript">

        $(document).ready(function() {

            $("p[name='photop'],span[name='photospan']").click(function() {
                var id = $(this).attr("value");
                if (!$('#photospan_' + id).find(":checkbox").is(":checked")) {
                    $('#photo_' + id).removeClass('tn-border-gray').addClass('tn-border-deep tn-bg-light').parent().addClass('tn-selected').find('span.tn-check-widget').removeClass('tn-border-gray')
                    .addClass('tn-border-deep tn-bg-light').find(":checkbox").attr('checked', true).end().find("span.tn-icon").removeAttr("style");
                } else {
                    $('#photo_' + id).removeClass('tn-border-deep tn-bg-light').addClass('tn-border-gray').parent().removeClass('tn-selected').find('span.tn-check-widget').removeClass('tn-border-deep tn-bg-light')
                    .addClass('tn-border-gray').find(":checkbox").removeAttr('checked').find("span.tn-icon").hide();
                }
            });

            $('#checkAllOrNo').click(function() {
                if ($('#checkAllOrNo').is(":checked")) {
                    $("p.tn-photo-wrap").removeClass('tn-border-gray').addClass('tn-border-deep tn-bg-light').parent().addClass('tn-selected').find('span.tn-check-widget').removeClass('tn-border-gray')
                    .addClass('tn-border-deep tn-bg-light').find(":checkbox").attr('checked', true).end().find("span.tn-icon").removeAttr("style");
                }
                else {
                    $('p.tn-photo-wrap').removeClass('tn-border-deep tn-bg-light').addClass('tn-border-gray').parent().removeClass('tn-selected').find('span.tn-check-widget').removeClass('tn-border-deep tn-bg-light')
                    .addClass('tn-border-gray').find(":checkbox").removeAttr('checked').end().find("span.tn-icon").hide();

                }
            });

            $("#PhotoUserCategories").change(function() {
                window.location.href = '<%=SPBUrlHelper.Action("ManagePhotos", "Photo", new RouteValueDictionary { { "userDomainName",userDomainName } })%>?categoryID=' + $(this).attr("value");
            });
        });

        function ajaxSubmitTheForm(action, postUrl) {
            if (action == 'delete') {
                $('#ManagePhotosForm').ajaxSubmit({ target: '#listPhotosDiv', url: postUrl });
            }
            else if (action == "setUserCategory") {
                $('#ManagePhotosForm').ajaxSubmit({ target: '#listPhotosDiv', url: postUrl });
            }
            else if (action == "setSiteCategory") {
                $('#ManagePhotosForm').ajaxSubmit({ target: '#listPhotosDiv', url: postUrl });
            }
        }

        function ischecked() {
            if ($("input[name=PhotoCheckBoxGroup]:checked").length <= 0) {
                alert("<%=GetResourceString("Message_PleaseSelectPhoto", applicationID)%>");
                return false;
            }
            return true;
        }
        function pageIndexChange(url) {
            $('#listPhotosDiv').load(url);
        }
        $(document).ready(function() {
            $("div.tn-list-header span[menu]").menuButton({ clickTrigger: true, notTriggerClose: ".tn-menu-button-position,.tn-menu input" });
        });
       
    </script>

</div>
