﻿<%@ Control Language="C#"  Inherits="SpaceBuilder.Web.SPBViewUserControl" %>    
<%   
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        if (messageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">$.nyroModalRemove();</script>"));
            TempData["currentCategoryIDInDropDownlist"] = TempData.Get<int>("currentCategoryIDInDropDownlist", 0);
        }
        else
        {
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
        }
        TempData["StatusMessageType"] = null;
    }   
%>
<spb:Script runat="server" ID="jquery_form" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js" ForceLoad="true"  SetExpireDays="30"></spb:Script>

<form id="NewUserCategory"  class="nyroModal" action="<%=SPBUrlHelper.Action("CreatePhotoUserCategory","Photo",new RouteValueDictionary{{"userDomainName",Html.GetParameterFromRouteDateOrQueryString("userDomainName")}}) %>" method="post">
<div class="commonTitle">
  <%= GetResourceString("Label_CreateGallerys",ApplicationIDs.Instance().Photo())%>
</div>
<table class="editor">
<tr>
    <th></th>
    <td >
     <div class="commonFormArea commonFormFieldDescription">
    <%=string.Format(GetResourceString("Message_PleaseGalleryName",ApplicationIDs.Instance().Photo()), 20)%></div></td>
    </tr>
    <tr>
        <th>
           <%=GetResourceString("Label_GalleryName",ApplicationIDs.Instance().Photo())%><%=GetResourceString("Common_Colon") %>
        </th>
        <td>
            <input type="text" name="userCategoryName" id="userCategoryName"  class="textBox" style="width: 200px"  maxlength="100" />
        </td>
    </tr>
    <tr>
        <th>
           <%=GetResourceString("Label_Description")%><%=GetResourceString("Common_Colon") %>
        </th>
        <td>
            <input type="text" name="userCategoryDescription" id="userCategoryDescription"  class="textBox" style="width: 200px"  maxlength="100" />
        </td>
    </tr>
    <tr>
        <th>
           <%=GetResourceString("Label_OrderNO")%><%=GetResourceString("Common_Colon") %>
        </th>
        <td>
            <input type="text" name="userCategoryOrder" id="userCategoryOrder"  class="textBox" style="width: 200px"  maxlength="100" />
        </td>
    </tr>
</table>
<div class="textCenter">
    <input type="submit"  id="newUserCategorySubmitButton" value="<%=GetResourceString("Button_OK")%>" />
    <input type="button" class="inputCancel nyroModalClose" value="<%=GetResourceString("Button_Cancel")%>" />
</div>
</form>

 <script type="text/javascript">
 $(document).ready(function() {
    $("#NewUserCategory").validate({
       rules:{ 
        userCategoryName:{required:true,rangelength:[1,20]},
        userCategoryOrder:{digits:true,min: 1},
        userCategoryDescription:{maxBlength:"2000"}
        },
        messages:{
        userCategoryName:{required:"<%=GetResourceString("Validate_InputGalleryName",ApplicationIDs.Instance().Photo())%>",rangelength:"<%=string.Format(GetResourceString("Validate_GalleryNameLimit", ApplicationIDs.Instance().Photo()), 20)%>"},
        userCategoryOrder:"<%=GetResourceString("Validate_InputGalleryName",ApplicationIDs.Instance().Photo())%>",
        userCategoryDescription:"<%=string.Format(GetResourceString("Validate_DescriptionGalleryWordLimit", ApplicationIDs.Instance().Photo()), 2000)%>"
        }
       }); 
    $("#newUserCategorySubmitButton").click(function() {
        if (!$("#NewUserCategory").valid()) {
            return false;
        }
      });
 }); 
</script>