﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<PhotoComment>>" %>
<% 
    PagingDataSet<PhotoComment> photoCmments = (PagingDataSet<PhotoComment>)ViewData.Model;
    User currentDomainUser = (User)ViewData["currentDomainUser"];
    string userDomainName = currentDomainUser.UserName;
    PhotoSection currentPhotoSection = ViewData.Get<PhotoSection>("currentPhotoSection");
    User CurrentUser = (User)ViewData["CurrentUser"];
    int threadID = (int)ViewData["threadID"];
    bool isManager = false;
    if (CurrentUser != null && (currentDomainUser.UserID == CurrentUser.UserID || CurrentUser.IsContentAdministrator))
        isManager = true;
  
    int returnToPageIndex = ViewData.Model.PageIndex;
    int pageIndex = ViewData.Model.PageIndex;
    if (ViewData.Model.TotalRecords == ViewData.Model.PageSize * (returnToPageIndex - 1) + 1)
    {
        returnToPageIndex = ViewData.Model.PageIndex - 1;
    }
    int addCommentPageIndex = ViewData.Model.PageIndex;
    if (ViewData.Model.TotalRecords == ViewData.Model.PageSize * addCommentPageIndex)
        addCommentPageIndex = addCommentPageIndex + 1;
%>
<a name="Comments"></a>
<div class="tn-comment-wrap">
    <div class="tn-list-header">
        <div class="tn-text-heading tn-border-bottom tn-border-gray">
            <h4>
                <%=GetResourceString("Common_Comment") %>
                <span class="tn-text-note">(<%=photoCmments.TotalRecords%>)</span>
            </h4>
        </div>
        <%if (photoCmments != null && photoCmments.Records.Count > 0)
          {%>
        <ul class="tn-comments tn-helper-reset">
            <% foreach (PhotoComment photoComment in photoCmments.Records)
               {
                   if (photoComment.IsApproved || (isManager || (CurrentUser != null && CurrentUser.UserID == photoComment.UserID)))
                   {%>
            <li class="tn-comment-item tn-border-gray tn-border-bottom"><a name="<%=photoComment.PostID %>"
                id="<%=photoComment.PostID %>"></a>
                <div class="tn-comment tn-helper-clearfix">
                    <div class="tn-comment-avatar">
                        <div class="tn-avatar">
                            <%=SPBHtmlHelper.Instance().ShowUserAvatar(photoComment.UserID, AvatarSizeTypes.Small)%></div>
                    </div>
                    <% if (isManager || (CurrentUser != null && photoComment.UserID == CurrentUser.UserID))
                       {%>
                    <a class="tn-icon tn-icon-cross tn-helper-right" onclick="if (confirm('<%=GetResourceString("Message_AskDeletePhotosComment",ApplicationIDs.Instance().Photo())%>')) { $('#PhotoCommentsAndComment').load('<%=SPBUrlHelper.Action("DeletePhotoComment","Photo",new RouteValueDictionary { {"threadID",photoComment.ThreadID},{"postID",photoComment.PostID},{"userDomainName",userDomainName},{"isMiniStyle",false},{"pageIndex",returnToPageIndex}}) %>' )}">
                    </a>
                    <%} %>
                    <div class="tn-comment-info">
                        <div class="tn-commentator">
                            <h5>
                                <%if (photoComment.UserID > 0)
                                  { %>
                                <a href="<%=SiteUrls.Instance().UserChannelHome(photoComment.UserID,UserDomainSpecialAppIDs.Instance().Home()) %>"
                                    class="tn-author" target="_blank">
                                    <%=photoComment.Author%></a>
                                <%}
                                  else
                                  {
                                      Response.Write(photoComment.Author);
                                  } %></h5>
                            <em class="tn-text-note tn-date">
                                <%=Formatter.FormatDate(photoComment.PostDate,true) %></em>
                            <% 
                                if (CurrentUser != null && photoComment.UserID != CurrentUser.UserID)
                                { %><span class="tn-text-note"><a href="javascript:;" onclick="$('#commentBody').focus().attr('value','<%=string.Format("{0}{1}：",GetResourceString("Common_Reply"),photoComment.Author) %>');$('#parentID').attr('value','<%=photoComment.PostID %>');"><%=GetResourceString("Common_Reply")%></a></span>
                            <%} %>
                        </div>
                        <%if (photoComment.ParentID > 0)
                          { %>
                        <blockquote class="tn-cue-tips tn-bg-gray tn-border-gray">
                            <p>
                                <%=GetResourceString("Common_Reply")%>
                                <%if (photoComment.ParentUserID > 0)
                                  { %>
                                <a href="<%=SiteUrls.Instance().UserDomainHome(photoComment.ParentUserID) %>" class="tn-author">
                                    <%=photoComment.ParentAuthor%></a>
                                <%} %><em class="tn-text-note tn-date"><%=Formatter.FormatDate(photoComment.ParentPostDate, true)%></em></p>
                            <p>
                                <%=photoComment.ParentBody%></p>
                        </blockquote>
                        <%} %>
                        <p>
                            <%=photoComment.Body%></p>
                    </div>
                </div>
            </li>
            <%
                }
               } %>
        </ul>
        <div class="tn-pagination tn-helper-align-center">
            <%=SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, photoCmments.TotalRecords, photoCmments.PageSize, pageIndex, 11, SPBUrlHelper.Action("ShowPhoto", "Photo", new RouteValueDictionary { {"userDomainName",currentDomainUser.UserName},{"threadID",threadID},{"pageIndex","{0}" } }))%>
        </div>
        <%} %>
    </div>
    <% 
        if ((currentPhotoSection.EnableComments && !(CurrentUser == null && (!SiteSettingsManager.GetSiteSettings().EnableAnonymousPosting || !currentPhotoSection.EnableAnonymousPosting))))
        {%>
    <%
        if (TempData["StatusMessageType"] != null)
        {
            StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            if (messageType == StatusMessageType.Success)
            {
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.Get<string>("StatusMessageContent"), 5000));
            }
            else
            {
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.Get<string>("StatusMessageContent"), 5000));
            }
            TempData["StatusMessageType"] = null;
        } %>
    <div class="tn-blank10">
    </div>
    <form id="photoCommentsForm" class="tn-helper-reset" action="<%=SPBUrlHelper.Action("CreatePhotoComment","Photo",new RouteValueDictionary {{"userDomainName",userDomainName},{"threadID",threadID},{"isMiniStyle",false},{"pageIndex",addCommentPageIndex}}) %>"
    method="post">
    <div class="tn-form tn-label-top">
        <div class="tn-comment-form-wrap tn-bg-gray">
            <div class="tn-comment-form">
                <div class="tn-comment-form tn-emotion-box">
                    <a name="comments" id="comments"></a>
                    <%  Html.RenderAction<ChannelController>(n => n.Control_SmileySelector("SmileySelector", "commentBody"));%>
                    <div class="tn-comment-text-wrap tn-border-gray tn-form-row-near">
                        <textarea id="commentBody" class="tn-comment-text-area" name="commentBody"><%=TempData.GetString("commentBody",string.Empty) %></textarea><br />
                        <input type="hidden" id="parentID" name="parentID" value="<%=TempData.GetInt("parentID", 0)%>" />
                    </div>
                    <div class="tn-form-row tn-text-note">
                        <%=string.Format(GetResourceString("Description_Pattern_WordCountLimit"), UserDomainConfiguration.Instance().MaxLengthPerReply)%>
                    </div>
                </div>
            </div>
            <%SiteSettings settings = SiteSettingsManager.GetSiteSettings();
              if (settings.VerifyCodeOption == VerifyCodeOption.Enabled || CurrentUser == null && settings.VerifyCodeOption == VerifyCodeOption.Anonymous)
              {%>
            <div class="tn-form-row">
                <label class="tn-form-label">
                    <%=GetResourceString("Label_VerifyCode")%><%=GetResourceString("Common_Colon")%></label>
                <%=SPBHtmlHelper.Instance().ShowVerificationCode("verifyCode", VerificationCodeDifficultyLevel.Low)%>
            </div>
            <%} %>
            <div class="tn-form-row tn-form-row-button">
                <%=SPBHtmlHelper.Instance().SubmitButton("createBlogComment", GetResourceString("Button_Submit"))%>
            </div>
        </div>
    </div>
    </form>
    <%} %>
</div>

<script type="text/javascript">

            function setCommentApproveStatus(url)
            {  
             //if (confirm('确定要批准该评论吗？')) { $('#PhotoCommentsAndComment').load(url); }
              $('#PhotoCommentsAndComment').load(url);
            }
        $(document).ready(function() {
            $("#photoCommentsForm").validate({
                rules: {
                    commentBody: { required: true, rangelength: [1, <%=UserDomainConfiguration.Instance().MaxLengthPerReply %>] },
                    verifyCode:{required: true}
                },
                messages: {
                    commentBody: { required: "<%=GetResourceString("Validate_FillInCommentBody")%>", rangelength: "<%=string.Format(GetResourceString("Validate_Pattern_CommentBodyMaxLength"),UserDomainConfiguration.Instance().MaxLengthPerReply)%>" },
                    verifyCode:{required: "<%=GetResourceString("Validate_FillInValidate")%>"}
                }
            });
            $('.nyroModal').nyroModal({
                resizeable: true
            });

        $('#photoCommentsForm').ajaxForm({
            beforeSubmit: function() {
                if (!$("#photoCommentsForm").valid())
                { return false; }
                $('#photoCommentsForm').block({
                    message: '<%=GetResourceString("Message_Loading")%>'
                });
            },
            target: '#PhotoCommentsAndComment',
            success: function() {
                $('#photoCommentsForm').unblock();
            }
        });
    });
</script>

