﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<PhotoComment>>" %>
<% 
    PagingDataSet<PhotoComment> photoCmments = (PagingDataSet<PhotoComment>)ViewData.Model;
    int applicationID = ApplicationIDs.Instance().Photo();
    User currentDomainUser = (User)ViewData["currentDomainUser"];
    string userDomainName = currentDomainUser.UserName;
    PhotoSection currentPhotoSection = ViewData.Get<PhotoSection>("currentPhotoSection");
    User CurrentUser = (User)ViewData["CurrentUser"];
    int threadID = (int)ViewData["threadID"];
    bool isManager = false;
    if (CurrentUser != null && (currentDomainUser.UserID == CurrentUser.UserID || CurrentUser.IsContentAdministrator))
        isManager = true;
%>
<%if ((photoCmments != null && photoCmments.Records.Count > 0) || ((currentPhotoSection.EnableComments && !(CurrentUser == null && (!SiteSettingsManager.GetSiteSettings().EnableAnonymousPosting || !currentPhotoSection.EnableAnonymousPosting)))))
                  {%>
<div id="PhotoCommentsAndComment_<%=threadID %>" class="tn-simple-comments">
    <div class="tn-widget tn-bubble-box tn-bubble-box-arrow-top">
        <div class="tn-bubble-box-arrow">
            <b class="tn-arrow-b1 tn-widget-content tn-bg-light"></b><b class="tn-arrow-b2 tn-widget-content tn-bg-light">
            </b><b class="tn-arrow-b3 tn-widget-content tn-bg-light"></b><b class="tn-arrow-b4 tn-widget-content tn-bg-light">
            </b><b class="tn-arrow-b5 tn-widget-content tn-bg-light"></b>
        </div>
        <div class="tn-bubble-box-content tn-widget-content tn-bg-light tn-corner-all">
                <%if (photoCmments != null && photoCmments.Records.Count > 0)
                  {%>
                <div class="tn-comment-wrap">
                    <ul class="tn-comments tn-helper-reset">
                        <% int i = 0;
                           foreach (PhotoComment photoComment in photoCmments.Records)
                           {
                               i++;
                               if (i > 3)
                                   break;
                               if (photoComment.IsApproved || (isManager || (CurrentUser != null && CurrentUser.UserID == photoComment.UserID)))
                               {%>
                        <li class="tn-comment-item tn-border-gray tn-border-bottom">
                            <div class="tn-comment tn-helper-clearfix">
                                <div class="tn-comment-avatar">
                                    <div class="tn-avatar">
                                        <%=SPBHtmlHelper.Instance().ShowUserAvatar(photoComment.UserID,true, HyperLinkTarget._blank, AvatarSizeTypes.Small)%>
                                    </div>
                                </div>
                                <% if (isManager || (CurrentUser != null && photoComment.UserID == CurrentUser.UserID))
                                   {%>
                                <a class="tn-icon tn-icon-cross tn-helper-right" onclick="if (confirm('<%=GetResourceString("Message_AskDeletePhotosComment",applicationID)%>')) { $('#PhotoCommentsAndComment_<%=threadID %>').load('<%=SPBUrlHelper.Action("DeletePhotoComment","Photo",new RouteValueDictionary { {"threadID",photoComment.ThreadID},{"postID",photoComment.PostID},{"userDomainName",userDomainName},{"isMiniStyle",true}}) %>' )}">
                                </a>
                                <%} %>
                                <div class="tn-comment-info">
                                    <div class="tn-commentator">
                                        <h5>
                                            <% if (!string.IsNullOrEmpty(photoComment.TitleUrl))
                                               {%>
                                            <a class="tn-author" href="<%=photoComment.TitleUrl %>">
                                                <%=photoComment.Author%></a>
                                            <%}
                                               else
                                               {%>
                                            <label>
                                                <%=photoComment.Author%>
                                            </label>
                                            <%} %>
                                        </h5>
                                        <em class="tn-text-note tn-date">
                                            <%=Formatter.FormatFriendlyDate(photoComment.PostDate)%></em>
                                        <p>
                                            <%=photoComment.Body%></p>
                                    </div>
                                </div>
                        </li>
                        <%
                            }
               } %>
                        <li class="tn-comment-item"><a href="<%=SiteUrls.Instance().ShowPicture(userDomainName,threadID) %>">
                            <%=string.Format(GetResourceString("Title_Pattern_Point_ShowAllPhotoComment", applicationID), photoCmments.TotalRecords)%></a>
                        </li>
                    </ul>
                </div>
                <%
                      if (TempData["StatusMessageType"] != null)
                  {
                      int messagetype = TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                      Response.Write(SPBHtmlHelper.Instance().StatusMessage((StatusMessageType)messagetype, TempData.GetString("StatusMessageContent", string.Empty), 2000));
                      TempData["StatusMessageType"] = null;
                  } %>
                <%} %>
                <% 
                    if ((currentPhotoSection.EnableComments && !(CurrentUser == null && (!SiteSettingsManager.GetSiteSettings().EnableAnonymousPosting || !currentPhotoSection.EnableAnonymousPosting))))
                    {%>
                <div class="tn-form tn-label-top tn-simple-form" id="simpleCommentDiv_<%=threadID %>">
                    <div class="tn-comment-form-wrap">
                        <div class="tn-comment-form">
                            <div class="tn-comment-text-wrap tn-border-light tn-form-row-near tn-textarea-wrap">
                                <textarea class="tn-comment-text-area tn-text-note" rows="" cols="" name="simpleCommentBody_<%=threadID %>"
                                    id="simpleCommentBody_<%=threadID %>"><%=GetResourceString("Label_AddComment",ApplicationIDs.Instance().Photo())%></textarea>
                                    <span style="display:none"></span>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="commentFormDiv_<%=threadID %>" style="display: none;">
                    <form class="tn-helper-reset" id="photoCommentsForm_<%=threadID %>" action="<%=SPBUrlHelper.Action("CreatePhotoComment","Photo",new RouteValueDictionary {{"userDomainName",userDomainName},{"threadID",threadID},{"isMiniStyle",true}}) %>"
                    method="post">
                    <div class="tn-form tn-label-top">
                        <div class="tn-comment-form-wrap">
                            <div class="tn-comment-form">
                                <div class="tn-comment-text-wrap tn-border-light tn-form-row-near tn-textarea-wrap">
                                    <%--<%  ViewData["textAreaID"] = "commentBody_" + threadID;
                            Html.RenderPartial("Controls/AddSmileyDiv.ascx", ViewData); %>--%>
                                    <textarea id="commentBody_<%=threadID %>" class="tn-comment-text-area" name="commentBody_<%=threadID %>"><%=TempData.GetString("commentBody" + threadID,string.Empty) %></textarea>
                                    <span style="display:none"></span>
                                </div>
                                <% SiteSettings settings = SiteSettingsManager.GetSiteSettings();
                                   if (settings.VerifyCodeOption == VerifyCodeOption.Enabled || CurrentUser == null && settings.VerifyCodeOption == VerifyCodeOption.Anonymous)
                                   {%>
                                <div class="tn-form-row tn-form-row-verifycode">
                                    <label>
                                        <%=GetResourceString("Label_VerifyCode")%><%=GetResourceString("Common_Colon") %></label>
                                    <%=SPBHtmlHelper.Instance().ShowVerificationCode("verifyCode_" + threadID, VerificationCodeDifficultyLevel.Low)%>
                                </div>
                                <%} %>
                                <div class="tn-form-row tn-form-row-button">
                                    <%=SPBHtmlHelper.Instance().SubmitButton("",GetResourceString("Button_Submit"), ButtonSizes.Default,null,null) %>
                                    <%=SPBHtmlHelper.Instance().CancelButton(ButtonSizes.Default, new RouteValueDictionary { { "id", "cancleCommentButton_" + threadID } })%>
                                </div>
                            </div>
                        </div>
                    </div>
                    </form>
                </div>

                <script type="text/javascript">

            function setCommentApproveStatus(url)
            {  
              $('#PhotoCommentsAndComment_<%=threadID %>').load(url);
            }
        $(document).ready(function() {
            $("#photoCommentsForm_<%=threadID %>").validate({
                rules: {
                    commentBody_<%=threadID %>: { required: true, rangelength: [1, <%=UserDomainConfiguration.Instance().MaxLengthPerReply %>] },
                    verifyCode_<%=threadID %>:{required: true}
                },
                messages: {
                    commentBody_<%=threadID %>: { required: "<%=GetResourceString("Validate_FillInCommentBody")%>", rangelength: "<%=string.Format(GetResourceString("Validate_Pattern_CommentBodyMaxLength"),UserDomainConfiguration.Instance().MaxLengthPerReply)%>" },
                    verifyCode_<%=threadID %>:{required: "<%=GetResourceString("Validate_FillInValidate")%>"}
                }
            });

        $('#photoCommentsForm_<%=threadID %>').ajaxForm({
            beforeSubmit: function() {
                if (!$("#photoCommentsForm_<%=threadID %>").valid())
                { return false; }
                $('#photoCommentsForm_<%=threadID %>').block({
                    message: '<%=GetResourceString("Message_Loading")%>'
                });
            },
            target: '#PhotoCommentsAndComment_<%=threadID %>',
            success: function() {
                $('#photoCommentsForm_<%=threadID %>').unblock();
            }
        });
        
        $("#simpleCommentBody_<%=threadID %>").click(function(){
        $("#commentFormDiv_<%=threadID %>").show();
        $("#commentBody_<%=threadID %>").focus();
        $("#simpleCommentDiv_<%=threadID %>").hide();
        });
        
        $("#cancleCommentButton_<%=threadID %>").click(function(){
        $("#commentFormDiv_<%=threadID %>").hide();
        $("#simpleCommentDiv_<%=threadID %>").show();
        });
    });
                </script>
                <%} %>
            
        </div>
    </div>
</div>
<%} %>