﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<UserCategory>" %>
<%
    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    bool isManager = ViewData.GetBool("isManager", false);
    int applicationID = ApplicationIDs.Instance().Photo();
%>
<%if (Model != null)
  { %>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-album-cover-block">
    <div class="tn-box-content tn-widget-content tn-corner-all">
        <div class="tn-album-item">
            <div class="tn-album-cover tn-widget-content tn-border-gray">
                <div class="tn-photo-wrap tn-widget-content tn-border-gray">
                    <img src="<%=SiteUrls.Instance().CategoryFeaturedPhotoUrl(Model) %>" alt="<%=Model.CategoryName %>" /></div>
            </div>
            <p class="tn-text-heading">
                <strong>
                    <%=Model.CategoryName %></strong></p>
            <p>
                <span class="tn-text-note tn-count">
                    <%=GetResourceString("Label_PictureCount", ApplicationIDs.Instance().Photo()) + GetResourceString("Common_Colon") + Model.ItemCount.ToString()%>
                </span>
                <%if (isManager)
                  { %>
                <span class="tn-action"><a href="<%=SPBUrlHelper.Action("Control_EditUserCategory", "Photo", new RouteValueDictionary { { "userDomainName", userDomainName }, { "categoryID", Model.CategoryID } })%>"
                    class="tn-action-text editCategoryModal">
                    <%=GetResourceString("Action_Edit")%></a></span><span class="tn-action"><a href="<%=SPBUrlHelper.Action("UploadPhotos","Photo",new RouteValueDictionary {{"userDomainName",userDomainName},{"categoryID",Model.CategoryID}})%>"
                        class="tn-action-text"><%=GetResourceString("Label_Pattern_Upload", applicationID)%></a></span>
                <%} %>
            </p>
            <p class="tn-text-note tn-date">
                <%=Formatter.FormatDate(Model.DateCreated,false) %></p>
            <p>
                <span class="tn-action tn-action-text-icon"><span class="tn-icon tn-icon-feed"></span>
                    <a target="_blank" href="<%=SiteUrls.Instance().GalleryRss(userDomainName) %>" class="tn-action-text">
                        <%=GetResourceString("Action_SubscribePhoto",applicationID) %></a>
                        <%if(CurrentUser!=null && CurrentUser.IsContentAdministrator){ %>
                         <a href="<%=SiteUrls.Instance().RecommendItem(ApplicationIDs.Instance().Photo(),Users.GetUser(userDomainName,false).UserID , Model.CategoryID,Model.CategoryName, 112002)%>" id="recommendPhotoModal">
                            <%=GetResourceString("Common_ManagerRecommend")%></a>
                            <%} %>
                </span>
            </p>
        </div>
    </div>
</div>
<div class="tn-blank10">
</div>

<script type="text/javascript">
<!--
    $(document).ready(function() {
        $('.editCategoryModal').nyroModal({
            resizeable: true
        });

        $('#recommendPhotoModal').nyroModal({
            resizeable: true,
            extImg: '[\.]{3}', //阻止识别为image
            height: 450,
            width: 400
        });
        
    }); 
//-->
</script>

<%} %>