﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
   int categoryID = Html.GetParameterFromRouteDateOrQueryString("categoryID", 0);
   int applicationID = ApplicationIDs.Instance().Photo();
   PhotoUserDomainSubMenus? subMenu = null;
   if (ViewData["PhotoUserDomainSubMenu"] != null)
       subMenu = (PhotoUserDomainSubMenus)ViewData["PhotoUserDomainSubMenu"];
   User currentDomainUser = Users.GetUser(userDomainName, false);

   bool isOwner = false;
   if (CurrentUser != null && (CurrentUser.UserID == currentDomainUser.UserID || CurrentUser.IsContentAdministrator))
       isOwner = true;
   Genders gender = Genders.Male;
   if (currentDomainUser.UserType == UserTypes.PersonUser && ((PersonUser)currentDomainUser).Gender == Genders.Female)
       gender = Genders.Female;
%>
<div class="spb-nav2-area">
    <div class="tn-wrapper-inner tn-helper-clearfix">
        <ul class="spb-nav2 tn-helper-reset tn-helper-left">
            <li <% if(subMenu!=null && subMenu== PhotoUserDomainSubMenus.myPhotoCategory) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\"");  %>>
                <a href="<%=SPBUrlHelper.Action("Home", "Photo", new RouteValueDictionary { {"userDomainName",userDomainName} })%>">
                    <span>
                        <%// string.Format(GetResourceString("Action_ICallery",applicationID),theMale) 
                            if (isOwner)
                                Response.Write(GetResourceString("Navigation_MyPhoto", applicationID));
                            else if (gender == Genders.Male)
                                Response.Write(GetResourceString("Navigation_HisPhoto", applicationID));
                            else
                                Response.Write(GetResourceString("Navigation_HerPhoto", applicationID));
                        %></span></a></li>
            <li <% if(subMenu!=null && subMenu== PhotoUserDomainSubMenus.latestPhoto) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\"");  %>>
                <a href="<%=SPBUrlHelper.Action("ListPhotos", "Photo", new RouteValueDictionary { { "userDomainName", userDomainName } })%>">
                    <span>
                        <%=GetResourceString("Navigation_LatestPhoto", applicationID)%></span></a>
            </li>
            <%
                if (currentDomainUser.UserType == UserTypes.PersonUser && isOwner)
                {%>
            <li <% if(subMenu!=null && subMenu== PhotoUserDomainSubMenus.friendPhotoCategory) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\"");  %>>
                <a href="<%=SPBUrlHelper.Action("ListFriendsPhotos", "Photo", new RouteValueDictionary { {"userDomainName",userDomainName} })%>">
                    <span>
                        <%//string.Format(GetResourceString("Action_FriendGallery",applicationID),theMale)
                    if (isOwner)
                        Response.Write(GetResourceString("Navigation_MyFriendPhoto", applicationID));
                    else if (gender == Genders.Male)
                        Response.Write(GetResourceString("Navigation_HisFriendPhoto", applicationID));
                    else
                        Response.Write(GetResourceString("Navigation_HerFriendPhoto", applicationID));
                        %></span></a></li>
            <li <% if(subMenu!=null && subMenu== PhotoUserDomainSubMenus.taggedPhotoCategory) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\"");  %>>
                <a href="<%=SPBUrlHelper.Action("ListTaggedPhotos", "Photo", new RouteValueDictionary { {"userDomainName",userDomainName} })%>">
                    <span>
                        <% 
                    if (isOwner)
                        Response.Write(GetResourceString("Navigation_MyTaggedPhoto", applicationID));
                    else if (gender == Genders.Male)
                        Response.Write(GetResourceString("Navigation_HisTaggedPhoto", applicationID));
                    else
                        Response.Write(GetResourceString("Navigation_HerTaggedPhoto", applicationID));
                        %></span></a></li>
            <%} %>
            <li <% if(subMenu!=null && subMenu== PhotoUserDomainSubMenus.sitePhotoCategory) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\"");  %>>
                <a href="<%=SiteUrls.Instance().ChannelPhotoHome()  %>" target="_blank"><span>
                    <%=GetResourceString("Action_OtherPeopleGallery",applicationID)%></span></a>
            </li>
        </ul>
        <% if (isOwner)
           {%>
        <div class="tn-helper-right">
            <%=SPBHtmlHelper.Instance().LinkButton("photoManage",GetResourceString("Action_ManagerPhotos",ApplicationIDs.Instance().Photo()),SPBUrlHelper.Action("ManagePhotos","Photo",new RouteValueDictionary{{"userDomainName",userDomainName}}), ButtonSizes.Default, HighlightStyles.Default, IconTypes.TriangleDown, TextIconLayout.MenuButton,null, new RouteValueDictionary { { "menu", "#manage" }, { "class", "tn-menu-button-active" } })%>
            <ul id="manage" class="tn-menu-button-position tn-menu tn-helper-reset tn-widget-content">
                <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManagePhotos","Photo",new RouteValueDictionary{{"userDomainName",userDomainName}})%>">
                    <%=GetResourceString("Action_ManagerPhotos",ApplicationIDs.Instance().Photo())%></a></li>
                <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManagePhotoComments","Photo",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <%=GetResourceString("Action_CommentManage")%></a></li>
                <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManagePhotoUserTags","Photo",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <%=GetResourceString("Action_TagManage")%></a></li>
                <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManagePhotoSectionSettings","Photo",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <%=GetResourceString("Action_SetGallery",applicationID)%></a></li>
            </ul>
            <%=SPBHtmlHelper.Instance().LinkButton("UploadPhotos", GetResourceString("Label_UpLoadImage", applicationID), SPBUrlHelper.Action("UploadPhotos", "Photo", new RouteValueDictionary { { "userDomainName", userDomainName }, { "categoryID", categoryID } }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText)%>
        </div>
        <%} %>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function () {
        $("[menu]", $(".spb-nav2-area")).menuButton();
    });
</script>
