﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
        if (messageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();',refresh(),2000)</script>"));
        }
        TempData["StatusMessageType"] = null;
    }
    int applicationID = ApplicationIDs.Instance().User();
    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    Link userLink = null;
    if (ViewData["UserLink"] != null)
        userLink = ViewData["UserLink"] as Link;

    List<LinkCategory> listlinkCate = null;
    if (ViewData["LinkCategories"] != null)
        listlinkCate = ViewData["LinkCategories"] as List<LinkCategory>;
    string url = string.Empty;
    if (userLink != null)
        url = Globals.GetFullUrlInFileHandlerSite(LinkManager.StorageProviderName, SPBUrlHelper.Action("Control_EditLinkAction", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName }, { "linkID", userLink.LinkID } }));
    else
        url = Globals.GetFullUrlInFileHandlerSite(LinkManager.StorageProviderName, SPBUrlHelper.Action("Control_AddLinkAction", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName } }));
%>
<form class="tn-helper-reset nyroModal" action="<%=url %>" method="post" id="editorForm"
enctype="multipart/form-data">
<div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom">
        <%=GetResourceString("Title_EditUserLink",applicationID)%>
        <span class="tn-text-note">带<span class="tn-form-required">*</span>号为必填项！</span>
    </h4>
    <div class="tn-form-row">
        <label class="tn-form-label">
            <span class="tn-form-required">*</span><%=GetResourceString("Label_Subject")%><%=GetResourceString("Common_Colon") %></label>
        <input type="text" class="tn-textbox tn-input-long tn-border-gray" name="Title" value="<% if(userLink!=null) Response.Write(userLink.Title); %>" />
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            <span class="tn-form-required">*</span>
            <%=GetResourceString("Label_UserLinkUrl", applicationID)%><%=GetResourceString("Common_Colon") %>
        </label>
        <input type="text" class="tn-textbox tn-input-long tn-border-gray" maxlength="100"
            name="linkUrl" value="<% if (userLink != null) Response.Write(userLink.LinkHref); else Response.Write("Http://");%>" />
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            <span class="tn-form-required">*</span>
            <%=GetResourceString("Label_OrderNO")%><%=GetResourceString("Common_Colon") %>
        </label>
        <input type="text" class="tn-textbox tn-input-medium tn-border-gray" value="<% if (userLink != null) Response.Write(userLink.DisplayOrder); else Response.Write("0");%>"
            name="displayorder" />
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            <%=GetResourceString("Label_UserLinkTip", applicationID)%><%=GetResourceString("Common_Colon") %></label>
        <input type="text" class="tn-textbox tn-input-medium tn-border-gray" value="<% if (userLink != null) Response.Write(userLink.LinkTitle);%>"
            name="linkTitle" />
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            <%=GetResourceString("Label_UserLinkCategory", applicationID)%><%=GetResourceString("Common_Colon") %></label>
        <select class="tn-dropdownlist" name="linkcate">
            <%if (listlinkCate != null)
              {
                  foreach (var item in listlinkCate)
                  {%>
            <option value="<%=item.CategoryID %>" <% if (userLink != null && item.CategoryID==userLink.CategoryID) Response.Write("selected");%>>
                <%=item.CategoryName %></option>
            <%}
              } %>
        </select>
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            <%=GetResourceString("Label_UserLinkType", applicationID)%><%=GetResourceString("Common_Colon") %></label>
        <div class="tn-input-multiple">
            <input type="radio" class="tn-radiobutton" value="<%=(int)LinkTypes.Text %>" name="UserLinkTypes"
                checked="checked" id="LinkText" <%if (userLink == null || userLink.LinkType == LinkTypes.Text) Response.Write("checked=\"checked\"");%>
                onclick="$('#linkPicTr').css('display','none');" />
            <label for="LinkText">
                <%=GetResourceString("Label_TextUserLink",applicationID)%></label>
            <input type="radio" class="tn-radiobutton" value="<%=(int)LinkTypes.Image %>" name="UserLinkTypes"
                id="LinkImg" <%if (userLink != null && userLink.LinkType == LinkTypes.Image) Response.Write("checked=\"checked\"");%>
                onclick="$('#linkPicTr').css('display','none');" />
            <label for="LinkImg">
                <%=GetResourceString("Label_PictureUserLink", applicationID)%></label>
        </div>
    </div>
    <div class="tn-form-row" id="imgDiv" style="display: none">
        <label class="tn-form-label">
            <%if (userLink != null && userLink.LinkType == LinkTypes.Image)
              {
                  if (!string.IsNullOrEmpty(userLink.ImageUrl))
                      Response.Write(string.Format("<img src=\"{0}\" width=\"110\" height=\"50\" /><br/>", SiteUrls.Instance().LinkPhoto(userLink, LinkPosition.User)));
              }
            %>
        </label>
        <input type="file" class="fileUpload" name="picfile" />
        <div class="tn-text-note">
            <%=GetResourceString("Description_LinkPicSupportType",applicationID)%></div>
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            <%=GetResourceString("Label_Status") %><%=GetResourceString("Common_Colon") %></label>
        <div class="tn-input-multiple">
            <input type="checkbox" class="tn-checkbox" name="isenable" id="isenable" value="true"
                <% if (userLink != null && userLink.IsEnabled) Response.Write(" checked=\"checked\"");%>
                <% if (userLink == null) Response.Write(" checked=\"checked\"");%> /><label for="isenable"><%=GetResourceString("Button_Enabled")%></label>
        </div>
    </div>
    <div class="tn-form-row tn-form-row-button">
        <label class="tn-form-label">
        </label>
        <%=SPBHtmlHelper.Instance().SubmitButton("", GetResourceString("Button_Submit"),ButtonSizes.Default,null,null)%>
        <%=SPBHtmlHelper.Instance().Button("", GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Secondary, new RouteValueDictionary { { "onclick", "$.nyroModalRemove();" } }, null)%>
    </div>
</div>
</form>

<script type="text/javascript" rel="forceLoad">
    $(document).ready(function() {

        $("#editorForm").validate({
            rules: {
                Title: { required: true, maxBlength: 50 },
                linkUrl: { url:true, required: true, maxlength: 100 },
                   displayorder: { required: true,digits:true }
            },
            messages: {
                Title: { required: "<%=GetResourceString("Validate_InputTitle")%>", maxBlength: "<%=string.Format(GetResourceString("Validate_Pattern_Title_Maxlength", applicationID), 50)%>" },
                linkUrl: {url:"<%=GetResourceString("Validate_LinkUrl_Url", applicationID)%>", required: "<%=GetResourceString("Validate_LinkUrl_Required", applicationID)%>", maxlength: "<%=string.Format(GetResourceString("Validate_Pattern_LinkUrl_Maxlength", applicationID), 100)%>" },
                displayorder: { required: "<%=GetResourceString("Validate_Displayorder_Required", applicationID)%>",digits: "<%=GetResourceString("Validate_Displayorder_Digits", applicationID)%>" }
            }
        });
          
        $("#editorFormsaveButton").click(function() {
            if (!$("#editorForm").valid()) {
                return false;
            }
        });
        toggleImgDiv();
        $("input[name=UserLinkTypes]").click(function() {
            toggleImgDiv();
        });
    });

    function toggleImgDiv() {
        if ($("input[name=UserLinkTypes]:checked").val() == '<%=(int)LinkTypes.Image %>')
            $("#imgDiv").show();
        else
            $("#imgDiv").hide();
    }
</script>

