﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<div class="container">
    <% int applicationID = ApplicationIDs.Instance().User(); %>    
    <%
        if (TempData["StatusMessageType"] != null)
        {
            StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
            //StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            if (messageType == StatusMessageType.Success)
            {
                //关闭模式窗口
                Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));
            }
            TempData["StatusMessageType"] = null;
        }
        LinkCategory LinkCate = null;
        if (ViewData["LinkCate"] != null)
            LinkCate = ViewData["LinkCate"] as LinkCategory;
        
    %>  
    <div class="form">
        <%
            if (LinkCate == null)
            {
        %>
        <form id="editorForm" action="<%=SPBUrlHelper.Action("Control_AddLinkCategoryAction", "UserDomainSettings",new RouteValueDictionary { {"userDomainName",Html.GetParameterFromRouteDateOrQueryString("userDomainName")}})%>"
        method="post" class="tn-helper-reset nyroModal">
        <%
            }
            else
            {
        %>
        <form id="editorForm" action="<%=SPBUrlHelper.Action("Control_EditLinkCategoryAction", "UserDomainSettings",new RouteValueDictionary {{"userDomainName",Html.GetParameterFromRouteDateOrQueryString("userDomainName")}, {"CateID",LinkCate.CategoryID} })%>"
        method="post" class="tn-helper-reset nyroModal">
        <%} %>
            <div class="tn-form tn-label-right">
               <h4 class="tn-text-heading tn-border-gray tn-border-bottom">
                  <%=GetResourceString("Title_EditUserLinkCategory",applicationID)%>               
               </h4>
               <div class="tn-form-row">
                    <label class="tn-form-label">
                     <%=GetResourceString("Label_UserLinkTitle",applicationID)%><%=GetResourceString("Common_Colon") %></label>
                    <input type="text" class="tn-textbox tn-input-long tn-border-gray" style="width: 200px;" name="category" value="<% if (LinkCate != null) { Response.Write(LinkCate.CategoryName); } %>" />
               </div>
               <div class="tn-form-row">
                    <label class="tn-form-label">
                     <%=GetResourceString("Label_OrderNO")%><%=GetResourceString("Common_Colon") %></label>
                    <input type="text" class="tn-textbox tn-input-long tn-border-gray" style="width: 200px;" name="displayorder" value="<% if (LinkCate != null) { Response.Write(LinkCate.DisplayOrder); } else{ Response.Write("0"); }%>" /><span
                        class="tn-form-required"><%=GetResourceString("Description_Required")%></span>
               </div>
               <div class="tn-form-row tn-textarea-wrap">
                    <label class="tn-form-label">
                      <%=GetResourceString("Label_Description")%><%=GetResourceString("Common_Colon") %></label>
                    <textarea  class="tn-textbox tn-input-long tn-border-gray" style="width: 250px" name="decript"><% if (LinkCate != null) { Response.Write(LinkCate.Description); } %></textarea>
                    <span style="display:none"></span>
               </div>
               <div class="tn-form-row tn-form-row-button">
                  <label class="tn-form-label"> </label>
                  <%= SPBHtmlHelper.Instance().SubmitButton("", GetResourceString("Button_Submit"),ButtonSizes.Default,null,null)%>
                  <%=SPBHtmlHelper.Instance().Button("", GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Secondary, new RouteValueDictionary {{"onclick","$.nyroModalRemove();"}},null)%>
               </div>
            </div>
        </form>
    </div>
</div>

<script type="text/javascript" rel="forceLoad">
        $(document).ready(function() {
            $("#editorForm").validate({
                rules: {
                    category: { required: true, maxBlength: 50 },
                    displayorder: { required: true,digits:true },
                    decript:{ maxBlength: 50 }
                },
                messages: {
                    category: { required: "<%=GetResourceString("Validate_Category_Required",applicationID)%>", maxBlength: "<%=string.Format(GetResourceString("Validate_Pattern_Category_Maxlength", applicationID), 50)%>" },
                    displayorder: { required: "<%=GetResourceString("Validate_Displayorder_Required",applicationID)%>",digits: "<%=GetResourceString("Validate_Displayorder_Digits",applicationID)%>" },
                    decript:{ maxBlength: "<%=string.Format(GetResourceString("Validate_Pattern_Decript_Maxlength", applicationID), 50)%>" }
                }
            });

            $("#editorFormsaveButton").click(function() {
                if (!$("#editorForm").valid()) {
                    return false;
                }
            });
        }); 
</script>

