﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<AdvertisingPosition>>" %>
<% int currentWidth = ViewData.GetInt("currentWidth", 0);
   int applicationID = ApplicationIDs.Instance().User();
   List<AdvertisingPosition> selectedPosition = ViewData["selectedPosition"] as List<AdvertisingPosition>;
   string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");%>
<div class="tn-collapsible tn-collapsible-opened">
    <div class="tn-border-bottom tn-border-gray tn-collapsible-header">
        <h4 class="tn-helper-reset">
            <a href="javascript:;;"><%=GetResourceString("Title_SelectedADPosition")%></a>
        </h4>
    </div>
    <div class="tn-blank10">
    </div>
    <div class="tn-collapsible-content" style="display: block;">
    
            <ul>
                <li class="toolbarItem attribute">
                    <%=GetResourceString("Description_SetAdvertisingRegionWidth",applicationID)%><%=GetResourceString("Common_Colon") %>
                    <select class="tn-dropdownlist" onchange="$('#apforjueryload').load('<%=SPBUrlHelper.Action("Control_ListAdvertisingPositions","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName},{"advertisingID",Html.GetParameterFromRouteDateOrQueryString("advertisingID",0) }}) %>',{width:$(this).val()});">
                        <option value="0">
                            <%=GetResourceString("Label_All",applicationID)%></option>
                        <%foreach (var width in ViewData.Get<List<int>>("widthList", null))
                          {%>
                        <option <%if(width==currentWidth)Response.Write("selected=\"selected\""); %> value="<%=width %>">
                            <%=width%></option>
                        <%}%>
                    </select>
                  </li>
             </ul>
 
        <table class="tn-table-grid">
            <tr class="tn-table-grid-header">
                <td class="tn-border-gray tn-border-bottom tn-text-note">
                    <span class="tn-checkbox">
                        <input type="checkbox" onclick="checkAll(this,'positionCheckBoxGroup')" />
                    </span>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-text-note">
                    <%=GetResourceString("Label_AdvertisingAreaCode",applicationID)%>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-text-note">
                    <%=GetResourceString("Label_Description")%>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-text-note">
                    <%=GetResourceString("Label_AdvertisingPreView",applicationID)%>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-text-note">
                    <%=GetResourceString("Label_AdvertisingSize",applicationID)%>
                </td>            
            </tr>
            <%foreach (var position in ViewData.Model)
              {
                  if (position.Width != currentWidth && currentWidth > 0)
                      continue;%>
            <tr class="tn-table-grid-row">
                <td class="tn-border-gray tn-border-bottom tn-width-check">
                    <input type="checkbox" name="positionCheckBoxGroup" value="<%=position.PositionCode %>"
                        class="tn-checkbox" <%if (selectedPosition != null)
                                          {
                                             if(selectedPosition.Contains(position)){Response.Write(" checked=\"checked\" ");}
                                          } %> />
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
                    <%=position.PositionCode %>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-auto">
                    <%=StringUtils.Trim(position.Description,20) %>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap">
                    <%if (!string.IsNullOrEmpty(position.ImageUrl))
                      {%>
                    <a target="_blank" type="formData" href="<%=SiteUrls.Instance().AdvertisingPositionImage(position.PositionCode) %>" class="imageForModal" title="<%=StringUtils.Trim(position.Description,300) %>">
                        <%=GetResourceString("Action_ViewAdvertisingPreview",applicationID)%></a>
                    <%}%>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap">
                    <%Response.Write(string.Format("{0}*{1}", position.Width, position.Height)); %>
                </td>              
            </tr>
            <%}%>
        </table>
    </div>
</div>
<script type="text/javascript">

    $(document).ready(function() {
        $('.imageForModal').nyroModal({
            resizeable: true
        });

        $(".tn-collapsible").collapsibleBox();
    });

</script>

