﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<User>>" %>
<% int applicationID = ApplicationIDs.Instance().User(); %>
<div class="tn-widget">
    <div class="tn-cue-tips tn-corner-all tn-message-box tn-widget-content tn-border-gray tn-bg-gray">
        <span class="tn-helper-left"><span class="tn-icon tn-icon-exclamation"></span></span>
        <div class="tn-helper-flowfix">
            <strong>提示：</strong>
            <%=GetResourceString("Description_WhatWeDoToStopUsers", applicationID)%>
            <% if (ViewData.Model.Count == 0)
               { %>
            <strong>
                <%=GetResourceString("Description_NoStopUsers", applicationID)%></strong>
            <%} %>
        </div>
    </div>
</div>
<ul class="tn-list tn-helper-reset">
    <%  if (TempData["StatusMessageType"] != null)
        {
            StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
            TempData["StatusMessageType"] = null;
        }
        List<User> stopedUsers = ViewData.Model;
        foreach (User stopedUser in stopedUsers)
        {%>
    <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
        <div class="tn-list-item-area-left">
            <div class="tn-avatar">
                <%=SPBHtmlHelper.Instance().ShowUserAvatar(stopedUser.UserID, true, HyperLinkTarget._self, AvatarSizeTypes.Small, new RouteValueDictionary { {"Class" , "friendItemImgSmall"}})%>
            </div>
        </div>
        <div class="tn-list-item-area-right">                                                                                   
            <ul class="tn-list-actions tn-helper-reset">
                <li class="tn-list-action tn-border-gray tn-border-bottom"><a href="<%= SiteUrls.Instance().UserChannelHome(stopedUser.UserID, UserDomainSpecialAppIDs.Instance().Home()) %>">
                    <%=GetResourceString("Action_GoToUserHome",applicationID)%></a></li>
                <li class="tn-list-action tn-border-gray tn-border-bottom"><a href="javascript:;" onclick="if (confirm('<%=GetResourceString("Message_StopUserDeleteConfirm",applicationID)%>'))
                             $('#ManageStopedUsers').load('<%=SPBUrlHelper.Action("DeleteStopedUser","UserDomainSettings",new RouteValueDictionary{{"userDomainName",Html.GetParameterFromRouteDateOrQueryString("userDomainName")},{"toUserID",stopedUser.UserID}}) %>');">
                    <%=GetResourceString("Action_SetNoStopToUser",applicationID)%></a></li>
            </ul>
        </div>
        <div class="tn-list-item-area-main">
            <div class="tn-list-item-row tn-list-item-heading">
                <h5 class="tn-helper-reset">
                    <a href="<%= SiteUrls.Instance().UserChannelHome(stopedUser.UserID, UserDomainSpecialAppIDs.Instance().Home()) %>">
                        <%=stopedUser.DisplayName%></a></h5>
            </div>
            <div class="tn-list-item-row tn-list-item-summary">
                <p class="tn-helper-reset">
                    <div class="spb-i-said">
                         &nbsp;<span class="tn-icon tn-icon-quotes-before tn-icon-inline"></span>
                        <%=stopedUser.UserDomainTitle%><span class="tn-icon tn-icon-quotes-after tn-icon-inline">
                        </span>
                    </div>
                </p>
            </div>
        </div>
    </li>
    <%} %>
</ul>
