﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%
    PersonProfileMenu menuType = PersonProfileMenu.AccountInfo;
    try
    {
        menuType = (PersonProfileMenu)ViewData["PersonProfileMenu"];
    }
    catch
    {
    }
    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("UserDomainName");
    User currentDomainUser = Users.GetUser(userDomainName, false);

    int applicationID = ApplicationIDs.Instance().User();
    bool enableSina = !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["Sina_AppKey"]) && !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["Sina_AppSecret"]);
    bool enableQQ = !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["QQ_AppKey"]) && !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["QQ_AppSecret"]);%>
<div class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-content tn-widget-content tn-corner-all">
        <ul class="tn-side-menu">
            <li <%if (menuType == PersonProfileMenu.AccountInfo) Response.Write(" class=\"tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("EditProfile","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName},{"type",PersonProfileType.AccountInfo}}) %>">
                    <%=GetResourceString("Title_AccountInfo", applicationID)%></a></li>
            <li <%if (menuType == PersonProfileMenu.BasicInfo) Response.Write(" class=\"tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("EditProfile","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName},{"type",PersonProfileType.BasicInfo}}) %>">
                    <%=GetResourceString("Title_BasicInfo", applicationID)%></a></li>
            <li <%if (menuType == PersonProfileMenu.PersonContact) Response.Write(" class=\"tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("EditProfile","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName},{"type",PersonProfileType.PersonContact}}) %>">
                    <%=GetResourceString("Title_PersonContact", applicationID)%></a></li>
            <li <%if (menuType == PersonProfileMenu.BusinessContact) Response.Write(" class=\"tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("EditProfile","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName},{"type",PersonProfileType.BusinessContact}}) %>">
                    <%=GetResourceString("Title_BusinessContact", applicationID)%></a></li>
            <li <%if (menuType == PersonProfileMenu.PersonUserTags)Response.Write("class=\"tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all\""); %>>
                <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageUserTags", "UserDomainSettings", new RouteValueDictionary { {"userDomainName",userDomainName} })%>">
                    <%=GetResourceString("Title_PersonUserTags", applicationID)%>
                </a>
            </li>
            <li <%if (menuType == PersonProfileMenu.PrivacyInfo) Response.Write(" class=\"tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("EditProfile","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName},{"type",PersonProfileType.PrivacyInfo}}) %>">
                    <%=GetResourceString("Title_PrivacyInfo", applicationID)%></a></li>
            <li <%if (menuType == PersonProfileMenu.UploadAvatar) Response.Write(" class=\"tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("UploadAvatar","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <span>
                        <%=GetResourceString("Title_UploadAvatar",applicationID)%></span></a></li>
            <li <%if (menuType == PersonProfileMenu.ChangePassword) Response.Write(" class=\"tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ChangePassword","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <span>
                        <%=GetResourceString("Title_ChangePassword",applicationID)%></span></a></li>
            <li <%if (menuType == PersonProfileMenu.ForumSignature) Response.Write(" class=\"tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ForumSignature","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <span>
                        <%=GetResourceString("Title_ForumInfor",applicationID) %></span></a></li>
            <%if (enableSina || enableQQ)
              {%>
            <li <%if (menuType == PersonProfileMenu.AccountBinding) Response.Write(" class=\"tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("AccountBinding","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <span>账号绑定</span></a></li>
            <%} %>
        </ul>
    </div>
</div>
