﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%
    UserDomainSettingsMenuType menuType = UserDomainSettingsMenuType.Account;
    try
    {
        menuType = (UserDomainSettingsMenuType)ViewData["UserDomainSettingsMenuType"];
    }
    catch
    {
    }
    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("UserDomainName");
    User currentDomainUser = Users.GetUser(userDomainName, false);

    int applicationID = ApplicationIDs.Instance().User();
    bool IsUserDomainOwner = false;
    if (CurrentUser != null && CurrentUser.UserID == currentDomainUser.UserID)
        IsUserDomainOwner = true;
    UserDomainConfiguration userDomainConfiguration = UserDomainConfiguration.Instance();
%>
<div class="spb-nav2-area">
    <div class="tn-wrapper-inner tn-helper-clearfix">
        <ul class="spb-nav2 tn-helper-reset tn-helper-left">
            <% if (CurrentUser != null && (Globals.GetCurrentUser().IsContentAdministrator || IsUserDomainOwner))
               {%>
            <li id="AccountLi" <%if (menuType == UserDomainSettingsMenuType.Account)Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\"");%>>
                <a id="Account" href="<%=SPBUrlHelper.Action("EditProfile", "UserDomainSettings", new RouteValueDictionary { {"userDomainName",userDomainName} })%>">
                    <span>
                        <%=GetResourceString("Title_UserProfileInfo",applicationID)%></span></a></li>
            <% PresentArea presentArea = PresentAreas.GetPresentArea(PresentAreaIDs.Instance().UserDomain(), false);
               if (presentArea != null && presentArea.EnableThemes && currentDomainUser != null && currentDomainUser.UserType == UserTypes.PersonUser)
               {%>
            <li id="ThemeSettingLi" <%if (menuType == UserDomainSettingsMenuType.ThemeSetting)Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\"");%>>
                <a id="editThemeSetting" href="<%=SPBUrlHelper.Action("ModifyHome", "UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}})%>">
                    <span>
                        <%=GetResourceString("Title_ModifyHome",applicationID)%></span></a>
            </li>
            <%} %>
            <li id="MenuSettingLi" <%if (menuType == UserDomainSettingsMenuType.ManageUserNavigations)Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\"");%>>
                <a href="<%=SPBUrlHelper.Action("ManageUserNavigations", "UserDomainSettings", new RouteValueDictionary { {"userDomainName",userDomainName} })%>">
                    <span>
                        <%=GetResourceString("Title_NavigationsSettings",applicationID)%></span></a>
            </li>
            <li id="MenuApplicationsLi" <%if (menuType == UserDomainSettingsMenuType.ManageApplications)Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\"");%>>
                <a href="<%=SPBUrlHelper.Action("ManageApplications", "UserDomainSettings", new RouteValueDictionary { {"userDomainName",userDomainName} })%>">
                    <span>
                        <%=GetResourceString("Title_ManageApplay",applicationID)%></span></a></li>
            <% if (currentDomainUser.UserType == UserTypes.PersonUser)
               { %>
            <li id="PrivacyLi" <%if (menuType == UserDomainSettingsMenuType.Privacy)Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\"");%>>
                <a id="Privacy" href="<%=SPBUrlHelper.Action("PrivacySettings", "UserDomainSettings", new RouteValueDictionary { {"userDomainName",userDomainName} })%>">
                    <span>
                        <%=GetResourceString("Title_PrivacySettings",applicationID)%></span></a></li>
            <%} %>
            <li id="NoticeLi" <%if (menuType == UserDomainSettingsMenuType.Notice)Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\"");%>>
                <a id="Notice" href="<%=SPBUrlHelper.Action("NoticeSettings", "UserDomainSettings", new RouteValueDictionary { {"userDomainName",userDomainName} })%>">
                    <span>
                        <%=GetResourceString("Title_NoticeSettings",applicationID)%></span></a></li>
            <li id="UserLinkLi" <%if (menuType == UserDomainSettingsMenuType.UserLink)Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\"");%>>
                <a id="UserLink" href="<%=SPBUrlHelper.Action("ManageUserLinks", "UserDomainSettings", new RouteValueDictionary { {"userDomainName",userDomainName} })%>">
                    <span>
                        <%=GetResourceString("Title_ManageUserLinks", applicationID)%></span></a></li>
            <%if (SiteSettingsManager.GetSiteSettings().EnableUserAD)
              {%>
            <li id="AdvertisingLi" <%if (menuType == UserDomainSettingsMenuType.Advertising)Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\"");%>>
                <a id="Advertising" href="<%=SPBUrlHelper.Action("ManageAdvertisings", "UserDomainSettings", new RouteValueDictionary { {"userDomainName",userDomainName} })%>">
                    <span>
                        <%=GetResourceString("Title_ManageAdvertisings",applicationID)%></span></a></li>
            <%}%>            
            <%}%>
        </ul>
    </div>
</div>
