﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<ICollection<UserTag>>" %>
<%if (Model != null && Model.Count > 0)
  { %>
<div class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <span class="tn-helper-right">
            <%     bool hasManagePermission = ViewData.GetBool("hasManagePermission", false); %>
            <% if (hasManagePermission)
               {%><a href="<%=SPBUrlHelper.Action("ManageShareUserTags","UserDomainShare",new RouteValueDictionary{{"userDomainName",Html.GetParameterFromRouteDateOrQueryString("userDomainName")}}) %>">
                   <%=GetResourceString("Action_Manage")%></a>
            <%} %></span>
        <h3 class="tn-helper-reset">
            <%=GetResourceString("Common_UserTag")%></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <% if (Model != null && Model.Count > 0)
           {%>
        <% foreach (UserTag tag in Model)
           {%>
        <a href="<%=SiteUrls.Instance().ListUserShareThreadsByUserTag(Html.GetParameterFromRouteDateOrQueryString("userDomainName"), tag.TagName) %>"
            title="<%=tag.TagName %>">
            <%=StringUtils.Trim(tag.TagName, 10)%></a> <span class="tn-category"><em class="tn-text-note">
                (<%=tag.ItemCount%>)</em></span>&nbsp;&nbsp;&nbsp;
        <% }
           } %>
    </div>
</div>
<div class="tn-blank10">
</div>
<%} %>