﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<ShareComment>>" %>
<spb:Script runat="server" ID="jqueryForm" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="blockUI" Src="~/Utility/jquery/plugin/jquery.blockUI-2.3.3.js"
    SetExpireDays="30" />
<% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");

   int userThreadID = Html.GetParameterFromRouteDateOrQueryString<int>("userShareThreadID");
   string controlName = "ListUserShareCommentsInShareList";
   int applicationID = ApplicationIDs.Instance().Share();
   int? currentAppID = Html.GetParameterFromRouteDateOrQueryString<int>("currentAppID");
   currentAppID = currentAppID.HasValue && currentAppID.Value > 0 ? currentAppID : null;
   bool hasManagePermission = CurrentUser != null && CurrentUser.IsContentAdministrator && CurrentUser.IsAdministrator;
   int? mediaType = Html.GetParameterFromRouteDateOrQueryString<int>("mediaType");
   mediaType = mediaType.HasValue && mediaType.Value == 0 ? null : mediaType;
   RouteValueDictionary dictionary = new RouteValueDictionary { { "userDomainName", userDomainName }, { "userShareThreadID", userThreadID }, { "controlName", controlName }, { "currentAppID", currentAppID }, { "mediaType", mediaType } };
%>
<div id="ListComments_<%=userThreadID %>">
    <div class="tn-comment-wrapper">
        <%if (Model != null && Model.Records.Count > 0)
          {%>
        <ul class="tn-comments tn-helper-reset">
            <%foreach (var shareComment in ViewData.Model.Records)
              { 
            %>
            <li class="tn-comment-item tn-border-gray tn-border-bottom">
                <div class="tn-comment tn-helper-clearfix">
                    <div class="tn-comment-avatar">
                        <div class="tn-avatar">
                            <%=SPBHtmlHelper.Instance().ShowUserAvatar(shareComment.UserID, true, HyperLinkTarget._self, AvatarSizeTypes.Small)%>
                        </div>
                    </div>
                    <%if (hasManagePermission && CurrentUser.UserID == shareComment.UserID)
                      { %>
                    <a href="javascript:;" class="tn-icon tn-icon-cross tn-helper-right" onclick="if(confirm('<%=GetResourceString("Message_ConfirmDeleteComment")%>')){$('#ListComments_<%=userThreadID %>').load('<%=SPBUrlHelper.Action("DeleteShareComment","UserDomainShare",new RouteValueDictionary(dictionary){{"commentID",shareComment.CommentID}, { "pageIndex", Model.PageIndex }}) %>')}">
                    </a>
                    <%} %>
                    <div class="tn-comment-info">
                        <div class="tn-commentator">
                            <%if (shareComment.UserID > 0)
                              { %>
                            <h5>
                                <a class="tn-author" href="<%=SiteUrls.Instance().UserDomainHome(shareComment.UserID) %>">
                                    <%=shareComment.Author%></a></h5>
                            <%}
                              else
                              {
                                  Response.Write(shareComment.Author);
                              } %>
                            <em class="tn-text-note tn-date">
                                <%=Formatter.FormatDate(shareComment.DateCreated, true)%></em>
                            <span class="tn-text-note">
                                <% if (CurrentUser != null && shareComment.UserID != CurrentUser.UserID)
                                   { %>
                                <%--<a href="#">回复</a>--%>
                                <%} %>
                            </span>
                        </div>
                        <p>
                            <%=shareComment.Body%></p>
                    </div>
                </div>
            </li>
            <%} %>
        </ul>
        <%if (Model.TotalRecords > Model.PageSize)
          { %>
        <div class="tn-pagination tn-helper-align-center">
            <%= SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 7, SPBUrlHelper.Action("Control_ListUserShareComments", "UserDomainShare", new RouteValueDictionary(dictionary) { { "pageIndex", "{0}" } }), "pageIndexChange")%>
            <div class="results">
                <%=string.Format(GetResourceString("Description_Pattern_AllCount", applicationID), Model.TotalRecords)%></div>
        </div>
        <%}
          }%>
    </div>
    <% if (SiteSettingsManager.GetSiteSettings().EnableAnonymousPosting || CurrentUser != null)
       {

           if (TempData["StatusMessageType"] != null)
           {
               StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
               Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 2000, false));
               TempData["StatusMessageType"] = null;
           }
    %>
    <form class="tn-helper-reset" name="shareCommentForm_<%=userThreadID %>" id="shareCommentForm_<%=userThreadID %>"
    method="post" action="<%=SPBUrlHelper.Action("CreateShareComment","UserDomainShare",dictionary)%>">
    <div class="tn-form tn-label-top">
        <div class="tn-comment-form-wrap">
            <div class="tn-comment-form">
                <div class="tn-comment-text-wrap tn-border-gray tn-form-row-near">
                    <textarea class="tn-comment-text-area" rows="5" cols="45" name="commentBody" id="commentBody"><%=TempData.GetString("CommentBody",string.Empty) %></textarea>
                    <input type="hidden" id="parentID_<%=userThreadID %>" name="parentID" value="<%=TempData.GetInt("parentID", 0)%>" />
                </div>
                <%SiteSettings settings = SiteSettingsManager.GetSiteSettings();
                  if (settings.VerifyCodeOption == VerifyCodeOption.Enabled || CurrentUser == null && settings.VerifyCodeOption == VerifyCodeOption.Anonymous)
                  {%>
                <div class="tn-form-row tn-form-row-verifycode">
                    <label>
                        <%=GetResourceString("Label_VerifyCode")%><%=GetResourceString("Common_Colon")%></label>
                    <%=SPBHtmlHelper.Instance().ShowVerificationCode("verifyCode", VerificationCodeDifficultyLevel.Low)%>
                </div>
                <%} %>
                <div class="tn-form-row tn-form-row-button">
                    <%=SPBHtmlHelper.Instance().SubmitButton("submitComment_"+userThreadID.ToString(), GetResourceString("Common_CommentBody"), ButtonSizes.Default,null, null)%>
                    <%=SPBHtmlHelper.Instance().Button("Cancel", GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Secondary, new RouteValueDictionary { { "onclick", "closeShareCommentsList();" } }, null)%>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">

    $(document).ready(function() {
        $("#commentBody_<%=userThreadID %>").keyup(function() {
            $("#subjectHint_<%=userThreadID %>").html(this.value.length + '/' + 140);
        }
        );
        $("#shareCommentForm_<%=userThreadID %>").validate({
            rules: {
                commentBody: { required: true, maxBlength: 140 },
                verifyCode: { required: true }
            },
            messages: {
                commentBody: { required: "<%=GetResourceString("Validate_ImpotrCommont", applicationID)%>", maxBlength: "<%=GetResourceString("Validate_WordLenLimit", applicationID)%>" },
                verifyCode: { required: "<%=GetResourceString("Validate_FillInValidate")%>" }
            }
        });

        $("#submitComment_<%=userThreadID %>").click(function() {
        if (!$("#shareCommentForm_<%=userThreadID %>").valid()) {
                return false;
            }
        });

        $('#shareCommentForm_<%=userThreadID %>').ajaxForm({
            target: '#ListComments_<%=userThreadID %>',
            beforeSubmit: function() {
                $('#shareCommentForm_<%=userThreadID %>').block({
                    message: '<%=GetResourceString("Message_Loading")%>'
                });
            },
            success: function() {
                $('#shareCommentForm_<%=userThreadID %>').unblock();
            }
        });

        $('.nyroModal').nyroModal({
            resizeable: true
        });
    });
    
    function closeShareCommentsList()
    {
        $('#commentForLoad_<%=mediaType %>_<%=currentAppID %>_<%=userThreadID %>').hide();
        if($("#switchButton").length > 0)
        {
            $("#switchButton").find("a").text("<%=GetResourceString("Common_Comment") %>");
        }
    }
    function pageIndexChange(url) {
        $('#ListComments_<%=userThreadID %>').parent().load(url);
    }
    </script>

    </form>
    <%}
       else { Response.Write(SPBHtmlHelper.Instance().StatusMessage(StatusMessageType.Hint, GetResourceString("Message_PopedomNotComment"), false)); }
    %>
</div>
