﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<UserShareThread>>" %>
<spb:Script runat="server" ID="jquery_form" Src="~/Utility/jquery/plugin/jquery.spb.menuButton.js"
    SetExpireDays="30" />
<% 
    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    bool hasManagePermission = ViewData.GetBool("hasManagePermission", false);
    string tagName = ViewData.GetString("tagName", string.Empty);

    int? mediaType = (int?)ViewData["mediaType"];
    int? applicationID = null;
    bool isFriended = ViewData.GetBool("isFriended", false);
    if (ViewData["applicationID"] != null)
        applicationID = (int)ViewData["applicationID"];
    Dictionary<int, Application> applications = Applications.GetApplications();
%>
<%    if (TempData["StatusMessageData"] != null)
      {
          StatusMessageData messageData = TempData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
          Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageData, 3000, false));
          TempData["StatusMessageData"] = null;
      }
%>
<div class="tn-list-header">
    <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
        <span class="tn-text-note">
            <%if (Model.TotalRecords > 0)
                  Response.Write(string.Format(GetResourceString("Description_Pattern_ShowSomeInAll", ApplicationIDs.Instance().Share()), Model.TotalRecords, (Model.PageIndex - 1) * Model.PageSize + 1, (Model.TotalRecords < Model.PageSize ? Model.TotalRecords : Model.PageIndex * Model.PageSize)));
              else
                  Response.Write(GetResourceString("Message_NohaveShareOfType", ApplicationIDs.Instance().Share())); %></span>
    </div>
</div>
<ul id="ListUserShareThreads_<%=mediaType %>_<%=applicationID %>" class="tn-list tn-helper-reset">
    <% foreach (UserShareThread thread in Model.Records)
       {
           string userShareThreadUrl = string.Empty;
           if (thread.SiteShareThread.ApplicationID > 0)
               userShareThreadUrl = thread.SiteShareThread.URL;
           else if ((int)thread.SiteShareThread.MediaType > 0)
               userShareThreadUrl = SiteUrls.Instance().ShowUserShareThread(UserID2UserNameDictionary.GetUserName(thread.UserID), thread.UserThreadID);
           string shareIconPath = string.Empty;
           if (thread.SiteShareThread.ApplicationID > 0 && applications.ContainsKey(thread.SiteShareThread.ApplicationID))
               shareIconPath = WebUtils.ResolveUrl(string.Format("~/Themes/Shared/Styles/ApplicationIcons/{0}.png", applications[thread.SiteShareThread.ApplicationID].ApplicationKey));

           string bgImage = "background: url(&quot;" + thread.SiteShareThread.ThumbnailUrl + "&quot;) repeat scroll center center transparent;";
           string noBgImage = "background: url(&quot;images/movie.jpg&quot;) repeat scroll center center transparent;";
    %>
    <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
        <div class="tn-list-item-row">
            <h5 class="tn-helper-reset">
                <%if ((int)thread.SiteShareThread.MediaType > 0)
                  {
                      switch (thread.SiteShareThread.MediaType)
                      {
                          case MediaTypes.Music:
                              Response.Write("&nbsp;" + SPBHtmlHelper.Instance().Icon(IconTypes.Music, thread.SiteShareThread.GetMultilingualShareTypeName(CurrentUserLanguage), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                              break;
                          case MediaTypes.Video:
                              Response.Write("&nbsp;" + SPBHtmlHelper.Instance().Icon(IconTypes.Movie, thread.SiteShareThread.GetMultilingualShareTypeName(CurrentUserLanguage), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                              break;
                          case MediaTypes.Website:
                              Response.Write("&nbsp;" + SPBHtmlHelper.Instance().Icon(IconTypes.World, thread.SiteShareThread.GetMultilingualShareTypeName(CurrentUserLanguage), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                              break;
                          default:
                              Response.Write("&nbsp;" + SPBHtmlHelper.Instance().Icon(IconTypes.World, string.Empty, new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                              break;
                      }
                  }
                  else
                  {%>
                <img src="<%=shareIconPath %>" height="16px" width="16px" />
                <% }%>
                <a href="<%=userShareThreadUrl %>">
                    <%=StringUtils.Trim(thread.SiteShareThread.Subject,45) %></a>
                <% if (!isFriended)
                   {
                       switch (thread.PrivacyStatus)
                       {
                           case PrivacyStatuses.NeedPassword:
                               Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Key, GetResourceString("Enum_PrivacyStatuses_NeedPassword"), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                               break;
                           case PrivacyStatuses.OnlyFriend:
                               Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.User, GetResourceString("Enum_PrivacyStatuses_OnlyFriend"), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                               break;
                           case PrivacyStatuses.Privacy:
                               Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Lock, GetResourceString("Enum_PrivacyStatuses_Privacy"), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                               break;
                           default:
                               break;
                       }
                   } %>
            </h5>
        </div>
        <div class="tn-list-item-row tn-helper-clearfix">
            <div class="tn-list-item-area-left">
                <%if (thread.SiteShareThread.MediaType == MediaTypes.Video)
                  { %>
                <div class="spb-video-cover tn-img-sprite">
                    <div class="spb-video-cover-source" <%if (string.IsNullOrEmpty(thread.SiteShareThread.ThumbnailUrl)) Response.Write(noBgImage); else Response.Write("style=\"" + bgImage + "\""); %>>
                        <a href="<%=userShareThreadUrl %>">
                            <div class="tn-widget-content tn-corner-all">
                                <span class="tn-icon tn-icon-play">
                                    <%=GetResourceString("Action_Play", ApplicationIDs.Instance().Share())%></span>
                            </div>
                        </a>
                    </div>
                </div>
                <%}
                  else if (!string.IsNullOrEmpty(thread.SiteShareThread.ThumbnailUrl) && thread.SiteShareThread.ApplicationID != ApplicationIDs.Instance().User())
                  {%>
                <a href="<%=userShareThreadUrl %>" title="<%=thread.SiteShareThread.Subject %>">
                    <img src="<%=thread.SiteShareThread.ThumbnailUrl %>" alt="" /></a>
                <%}
                  else if (thread.SiteShareThread.ApplicationID == ApplicationIDs.Instance().User())
                  {%>
                <div class="tn-avatar">
                    <%=SPBHtmlHelper.Instance().ShowUserAvatar(thread.UserID, true,HyperLinkTarget._blank, AvatarSizeTypes.Small) %>
                </div>
                <%}%>
            </div>
            <div class="tn-list-item-area-right">
                <div class="tn-list-figure tn-widget">
                    <div class="tn-list-figure-count tn-widget-content tn-corner-top">
                        <%=thread.SiteShareThread.UserCount %></div>
                    <%if (CurrentUser == null)
                      { %>
                    <a href="<%=SiteUrls.Instance().Login(true) %>" class="tn-list-figure-button tn-state-default tn-corner-bottom">
                        <%=GetResourceString("Action_Share", ApplicationIDs.Instance().Share())%></a>
                    <%}
                      else
                      { %>
                    <a href="<%=SiteUrls.Instance().ShareInModal(thread.ThreadID,false) %>" id="shareButton_<%=thread.UserThreadID %>"
                        name="shareButton" class="tn-list-figure-button tn-state-default tn-corner-bottom nyroModal">
                        <%=GetResourceString("Action_Share", ApplicationIDs.Instance().Share())%></a>
                    <%} %>
                </div>
            </div>
            <div class="tn-list-item-area-main">
                <div class="tn-list-item-row tn-list-item-heading">
                    <cite>
                        <a href="<%=thread.SiteShareThread.URL %>">
                            <%=StringUtils.Trim(WebUtils.FullPath(thread.SiteShareThread.URL), 24)%></a></cite>
                </div>
                <div class="tn-list-item-row">
                    <%if (isFriended)
                      {%>
                    <cite>
                        <a href="<%=SiteUrls.Instance().UserChannelHome(thread.UserID,ApplicationIDs.Instance().Share()) %>"
                            class="tn-author">
                            <%=thread.Author%></a></cite> <em class="tn-date tn-text-note">
                                <%=GetResourceString("Label_ShareTo",ApplicationIDs.Instance().Share())%>
                                <%=Formatter.FormatFriendlyDate(thread.DateCreated)%></em>
                    <%} %>
                </div>
                <%if (thread.SiteShareThread.MediaType == MediaTypes.Music)
                  { %>
                <div class="tn-list-item-row">
                    <span class="tn-button tn-button-text-icon tn-button-default">
                        <span class="tn-first-child">
                            <span class="tn-icon tn-icon-play"></span>
                            <a href="<%=userShareThreadUrl %>" class="tn-button-text">
                                <%=GetResourceString("Action_PlayMusic", ApplicationIDs.Instance().Share())%></a>
                        </span>
                    </span>
                </div>
                <%} %>
                <div class="tn-list-item-row tn-list-item-summary">
                    <p class="tn-helper-reset">
                        <%=StringUtils.Trim(thread.SiteShareThread.Body,100) %></p>
                </div>
                <%if (!String.IsNullOrEmpty(thread.Body))
                  { %>
                <div class="tn-list-item-row tn-list-item-summary">
                    <p class="tn-helper-reset">
                        <div class="spb-i-said">
                            &nbsp;<span class="tn-icon tn-icon-quotes-before tn-icon-inline"></span>
                            <%=StringUtils.Trim(thread.Body, 100)%>
                            <span class="tn-icon tn-icon-quotes-after tn-icon-inline"></span>
                        </div>
                    </p>
                </div>
                <%} %>
                <div class="tn-list-item-row">
                </div>
            </div>
        </div>
        <%if (thread.Tags != null && thread.Tags.Count > 0)
          { %>
        <div class="tn-list-item-row">
            <%=GetResourceString("Common_UserTag")%>：
            <%foreach (string tag in thread.Tags)
              {%>
            <a href="<%=SiteUrls.Instance().ListUserShareThreadsByUserTag(userDomainName, tag) %>">
                <%=tag %></a>
            <%} %>
        </div>
        <%} %>
        <div class="tn-list-item-row">
            <%if ((int)thread.SiteShareThread.MediaType > 0)
              { %>
            <span class="tn-action tn-action-text-icon">
                <span class="tn-icon tn-icon-bubble"></span>
                <a class="tn-action-text" name="commentButton" id="commentButton" href="javascript:;"
                    value="<%=thread.UserThreadID %>">
                    <%=GetResourceString("Common_Comment")%>(<%=thread.CommentCount %>)</a></span><span
                        class="tn-action tn-action-text-icon"><span class="tn-icon tn-icon-view"> </span>
                        <a class="tn-action-text" href="<%=userShareThreadUrl %>">
                            <%=GetResourceString("Common_Browse") %>(<%=thread.SiteShareThread.HitTimes%>)</a>
                    </span>
            <%} %>
            <%if (hasManagePermission && !isFriended)
              { %>
            <span class="tn-action">
                <a class="tn-action-text" target="_blank" href="<%=SPBUrlHelper.Action("EditUserShareThread","UserDomainShare",new RouteValueDictionary{{"userDomainName",userDomainName},{"userThreadID",thread.UserThreadID}}) %>">
                    <%=GetResourceString("Action_Edit")%></a></span>
            <span class="tn-action">
                <a class="tn-action-text" href="javascript:;" onclick="if (confirm('<%=GetResourceString("Message_ConfirmDeleteShare",ApplicationIDs.Instance().Share())%>')) {$('#ListUserShareThreads_<%=mediaType %>_<%=applicationID %>').parent().load('<%=SPBUrlHelper.Action("DeleteUserShareThread", "UserDomainShare", new RouteValueDictionary { { "userDomainName", userDomainName }, { "userThreadID", thread.UserThreadID }, { "mediaType", mediaType}, { "applicationID", applicationID },{"tagName",tagName}, {"isFriended",isFriended}, { "pageIndex", Model.PageIndex } })%>');} ">
                    <%=GetResourceString("Action_Delete")%></a></span>
            <%} %>
            <span class="tn-action">
                <a href="<%=SiteUrls.Instance().NewImpeachReport() %>" name="reportbutton" class="tn-action-text nyroModal">
                    <%=GetResourceString("Action_FindOut", ApplicationIDs.Instance().Share())%></a>
            </span>
        </div>
        <div class="tn-simple-comments spb-share-comment" style="display: none" id="commentForLoad_<%=mediaType %>_<%=applicationID %>_<%=thread.UserThreadID %>">
            <div class="tn-widget tn-bubble-box tn-bubble-box-arrow-top">
                <div class="tn-bubble-box-arrow">
                    <b class="tn-arrow-b1 tn-widget-content"></b>
                    <b class="tn-arrow-b2 tn-widget-content"></b>
                    <b class="tn-arrow-b3 tn-widget-content"></b>
                    <b class="tn-arrow-b4 tn-widget-content"></b>
                    <b class="tn-arrow-b5 tn-widget-content"></b>
                </div>
                <div id="comments_<%=mediaType %>_<%=applicationID %>_<%=thread.UserThreadID %>"
                    class="tn-bubble-box-content tn-widget-content tn-corner-all" value="<%=SPBUrlHelper.Action("Control_ListUserShareComments","UserDomainShare",new RouteValueDictionary{{"userDomainName",userDomainName},{"controlName","ListUserShareCommentsInShareList"},{"userShareThreadID",thread.UserThreadID},{"mediaType",mediaType},{"currentAppID",applicationID }}) %>">
                </div>
            </div>
        </div>
    </li>
    <%} %>
</ul>
<%if (Model.TotalRecords > Model.PageSize)
  { %>
<div class="tn-pagination tn-helper-align-center">
    <%=SPBHtmlHelper.Instance().AjaxPagingButton(Model.TotalRecords, Model.PageSize, Model.PageIndex, 11, SPBUrlHelper.Action("Control_ListUserShareThreads", "UserDomainShare", new RouteValueDictionary { { "userDomainName", userDomainName }, { "mediaType", mediaType }, { "applicationID", applicationID }, { "tagName", WebUtils.UrlEncode(tagName) }, { "isFriended", isFriended }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
    <div class="tn-page-results tn-text-note">
    </div>
</div>
<%} %>

<script type="text/javascript">
    var ListShareThreadsID = "ListUserShareThreads_<%=mediaType %>_<%=applicationID %>";
    $(document).ready(function() {
        $("a[name='shareButton'],a[name='reportbutton']").nyroModal({ width: 500 });
        $("a[name='commentButton']", $('#' + ListShareThreadsID)).click(function(e) {
            var $comments = $("#comments_<%=mediaType %>_<%=applicationID %>_" + $(this).attr("value"));
            var $commentForLoad = $("#commentForLoad_<%=mediaType %>_<%=applicationID %>_" + $(this).attr("value"));
            if ($commentForLoad.is(":hidden")) {
                $commentForLoad.show();
                if (!$comments.find("div").length) {
                    $comments.load($comments.attr("value"));
                }
            }
            else {
                $commentForLoad.hide();
            }
        });
    });
    function pageIndexChange(url) {
        $('#' + ListShareThreadsID).parent().load(url);
    }
</script>

