﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<UserShareThread>>" %>
<%int userID = 0;
  if (ViewData["userID"] != null)
      userID = (int)ViewData["userID"];
  int threadID = 0;
  if (ViewData["threadID"] != null)
      threadID = (int)ViewData["threadID"];
  int mediaType = 1;
  if (ViewData["mediaType"] != null)
      mediaType = (int)ViewData["mediaType"];
  int? disPlayCount = Html.GetParameterFromRouteDateOrQueryString<int>("disPlayCount");

  int applicationID = ApplicationIDs.Instance().Share();
%>
<%
    IList<UserShareThread> friendShareThreads = null;
    if (ViewData["friendsShareThreads"] != null)
        friendShareThreads = ViewData.Get<IList<UserShareThread>>("friendsShareThreads");
    if (userID > 0 && friendShareThreads != null && friendShareThreads.Count > 0)
    {
%>
<div class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <h3 class="tn-helper-reset">
            <%if (CurrentUser != null && userID > 0 && userID == CurrentUser.UserID)
              {
                  if (mediaType == 1)
                      Response.Write(GetResourceString("Title_ShareMediaFriend", applicationID));
                  else
                      Response.Write(GetResourceString("Title_ShareMusicFriend", applicationID));
              }
              else
              {
                  if (mediaType == 1)
                      Response.Write(GetResourceString("Title_HimFriendShareMedia", applicationID));
                  else
                      Response.Write(GetResourceString("Title_HimFriendShareMusic", applicationID));
              }%>
        </h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <ul class="tn-avatar-list tn-helper-reset">
            <%if (friendShareThreads != null)
              {
                  int i = 0;
                  foreach (UserShareThread friendShareThread in friendShareThreads)
                  {
                      if (i > (disPlayCount ?? 9))
                          break;
            %>
            <li class="tn-avatar-item">
                <div class="tn-avatar">
                    <%=SPBHtmlHelper.Instance().ShowUserAvatar(friendShareThread.UserID, true, HyperLinkTarget._blank, AvatarSizeTypes.Small)%></div>
                <a class="tn-user-name" href="<%=SiteUrls.Instance().UserDomainHome(friendShareThread.UserID)%>">
                    <%=friendShareThread.Author%></a></li>
            <%i++;
                  }
              } %>
        </ul>
    </div>
</div>
<div class="tn-blank10">
</div>
<%  } %>
<div class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <h3 class="tn-helper-reset">
            <%if (CurrentUser != null && userID > 0 && CurrentUser.UserID == userID)
              {
                  if (mediaType == 1)
                      Response.Write(GetResourceString("Title_ShareMediaMember", applicationID));
                  else
                      Response.Write(GetResourceString("Title_ShareMusicFriend", applicationID));
              }
              else
              {
                  if (mediaType == 1)
                      Response.Write(GetResourceString("Title_ShareMediaMember", applicationID));
                  else
                      Response.Write(GetResourceString("Title_ShareMusicFriend", applicationID));
              } %>
        </h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <ul class="tn-avatar-list tn-helper-reset">
            <%
                int j = 0;
                if (Model.Count > 0)
                {
                    foreach (UserShareThread userShareThread in Model)
                    {
                        if (userShareThread.UserID == userID)
                            break;
                        if (CurrentUser != null && !Friends.IsFriend(userShareThread.UserID, userID))
                        {
            %>
            <li class="tn-avatar-item">
                <div class="tn-avatar">
                    <%=SPBHtmlHelper.Instance().ShowUserAvatar(userShareThread.UserID, true, HyperLinkTarget._blank, AvatarSizeTypes.Small)%></div>
                <a class="tn-user-name" href="<%=SiteUrls.Instance().UserDomainHome(userShareThread.UserID) %>">
                    <%=userShareThread.Author%></a><span class="tn-text-note"></span></li>
            <%
                }
                        else
                        {%>
            <li class="tn-avatar-item">
                <div class="tn-avatar">
                    <%=SPBHtmlHelper.Instance().ShowUserAvatar(userShareThread.UserID, true, HyperLinkTarget._blank, AvatarSizeTypes.Small)%></div>
                <a class="tn-user-name" href="<%=SiteUrls.Instance().UserDomainHome(userShareThread.UserID) %>">
                    <%=userShareThread.Author%></a><span class="tn-text-note"></span></li>
            <% }
                        j++;
                    }
                }
                if (j <= 0)
                {%>
            <p>
                <%=GetResourceString("Description_MemberShareNotFound", applicationID)%></p>
            <%} %>
        </ul>
    </div>
</div>
