﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%int applicationID = ApplicationIDs.Instance().Share(); %>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-share-box">
    <div class="tn-box-content tn-widget-content tn-corner-all">
        <form class="tn-helper-reset" method="post" id="CreateUserShareThreadForm" action="<%=SPBUrlHelper.Action("CreateShareThread", "UserDomainShare", new RouteValueDictionary { { "userDomainName",Html.GetParameterFromRouteDateOrQueryString("userDomainName")  } })%>">
        <div class="tn-form tn-form-single">
            <input id="urlForShare" type="text" name="urlForShare" class="tn-textbox tn-input-medium tn-border-gray">
            <%=SPBHtmlHelper.Instance().SubmitButton("newShareButton", GetResourceString("Common_Share"),ButtonSizes.Default,null,null)%>
        </div>
        </form>
    </div>
</div>
<div class="tn-blank10">
</div>

<script type="text/javascript" rel="forceLoad">
    var urlDefaultValue = "<%=GetResourceString("Description_ImportYourShareLink", applicationID) %>";
    $(document).ready(function() {
        $("#urlForShare").watermark(urlDefaultValue);
        $("#CreateUserShareThreadForm").validate({
            rules: {
                urlForShare: { required: true, url: true, maxlength: 512 }
            },
            messages: {
                urlForShare: { required: "<%=GetResourceString("Validate_MustImport", applicationID)%>", url: "<%=GetResourceString("Validate_DifferFormat", applicationID)%>", maxlength: "<%=GetResourceString("Validate_CharsMost", applicationID)%>" }
            },
            showErrors: $.dialog.showErrors,
            onfocusout: false,
            onclick: false,
            onkeyup:false,
            onsubmit:true
        });

    });     
</script>

