﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
   ShareUserDomainSubMenus? subMenu = null;
   if (ViewData["ShareUserDomainSubMenu"] != null)
       subMenu = (ShareUserDomainSubMenus)ViewData["ShareUserDomainSubMenu"];
   User currentDomainUser = Users.GetUser(userDomainName, false);

   bool isOwner = false;
   if (CurrentUser != null && (CurrentUser.UserID == currentDomainUser.UserID || CurrentUser.IsContentAdministrator))
       isOwner = true;
   int applicationID = ApplicationIDs.Instance().Share();            
%>
<% if (isOwner)
   {%>
<div class="spb-nav2-area">
    <div class="tn-wrapper-inner tn-helper-clearfix">
        <ul class="spb-nav2 tn-helper-reset tn-helper-left">
            <li <% if(subMenu==ShareUserDomainSubMenus.myCreated) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SPBUrlHelper.Action("ListMyUserShareThreads","UserDomainShare",new RouteValueDictionary{{"userDomainName",userDomainName}})%>">
                    <span>
                        <%=GetResourceString("Action_MineShare", applicationID)%></span> </a>
            </li>
            <li <% if(subMenu==ShareUserDomainSubMenus.myFriend) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SPBUrlHelper.Action("ListFriendUserShareThreads", "UserDomainShare", new RouteValueDictionary { { "userDomainName", userDomainName } }) %>">
                    <span>
                        <%=GetResourceString("Action_FriendShare", applicationID)%></span></a></li>
            <li class="spb-nav-item"><a href="<%=SiteUrls.Instance().ChannelShareHome() %>" target="_blank">
                <span>
                    <%=GetResourceString("Action_AllShare", applicationID)%></span></a></li>
        </ul>
        <div class="tn-helper-right">
            <%=SPBHtmlHelper.Instance().LinkButton("shareManage",GetResourceString("Action_ShareManage", applicationID),"javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.TriangleDown, TextIconLayout.MenuButton,null, new RouteValueDictionary { { "menu", "#manage" }, { "class", "tn-menu-button-active" } })%>
            <ul id="manage" class="tn-menu-button-position tn-menu tn-menu-text-icon tn-helper-reset tn-widget-content">
                <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageComments","UserDomainShare",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <%=GetResourceString("Action_CommentManage")%></a></li>
                <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageShareUserTags","UserDomainShare",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <%=GetResourceString("Action_TagManage")%></a></li>
            </ul>
        </div>
    </div>
</div>

<script type="text/javascript" rel="forceLoad">
    var urlDefaultValue = "<%=GetResourceString("Description_ImportYourShareLink", applicationID) %>";

    $(document).ready(function() {
        $("[menu]", $(".spb-nav2-area")).menuButton();
    });
</script>

<%} %>