﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<UserShareThread>>" %>
<%
    string userDomainName;
    userDomainName = Html.GetParameterFromRouteDateOrQueryString("userdomainName");
    int mediaType = ViewData.GetInt("mediaType");
    int disPlayCount = Html.GetParameterFromRouteDateOrQueryString("disPlayCount", 5);
    int? userID = null;
    if (ViewData["userID"] != null)
        userID = (int)ViewData["userID"];
    int applicationID = ApplicationIDs.Instance().Share();
%>
<div class="tn-box tn-widget tn-widget-content tn-corner-all <%if (mediaType == (int)MediaTypes.Video) Response.Write("spb-share-video-other"); else Response.Write(" spb-share-music-other"); %>">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <h3 class="tn-helper-reset">
            <%if (CurrentUser != null && userID != null && userID == CurrentUser.UserID)
              {
                  if (mediaType == (int)MediaTypes.Video)
                      Response.Write(GetResourceString("Title_OtherMediaShare", applicationID));
                  else
                      Response.Write(GetResourceString("Title_OtherMusicShare", applicationID));
              }
              else
              {
                  if (mediaType == (int)MediaTypes.Video)
                      Response.Write(GetResourceString("Title_HisOtherMediaShare", applicationID));
                  else
                      Response.Write(GetResourceString("Title_HisOtherMusicShare", applicationID));
              }%>
        </h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <ul class="spb-share-video-block">
            <%int i = 0;
              if (Model.Records.Count > 1)
              {
                  foreach (UserShareThread userShareThread in Model.Records.Skip(1))
                  {
                      if (i > disPlayCount) break; string userThreadUrl = null;
                      if (userShareThread.SiteShareThread.ApplicationID > 0)
                      { userThreadUrl = userShareThread.SiteShareThread.URL; }
                      else if (userShareThread.SiteShareThread.MediaType > 0)
                      { userThreadUrl = SiteUrls.Instance().ShowUserShareThread(userDomainName, userShareThread.UserThreadID); }
                      string bgImage = "background: url(&quot;" + userShareThread.SiteShareThread.ThumbnailUrl + "&quot;) repeat scroll center center transparent;";
                      string noBgImage = "background: url(&quot;images/movie.jpg&quot;) repeat scroll center center transparent;";%>
            <li>
                <%if (mediaType == (int)MediaTypes.Video)
                  { %>
                <div class="spb-video-cover tn-img-sprite">
                    <div class="spb-video-cover-source" <%if (string.IsNullOrEmpty(userShareThread.SiteShareThread.ThumbnailUrl)) Response.Write("style=\"" + noBgImage + "\""); else Response.Write("style=\"" + bgImage + "\""); %>>
                        <a title="<%=userShareThread.SiteShareThread.Subject %>" href="<%=userThreadUrl %>">
                            <div class="tn-widget-content tn-corner-all">
                                <span class="tn-icon tn-icon-play"></span>
                            </div>
                        </a>
                    </div>
                </div>
                <a title="<%=userShareThread.SiteShareThread.Subject %>" class="tn-text-heading"
                    href="<%=userThreadUrl%>">
                    <%=StringUtils.Trim(userShareThread.SiteShareThread.Subject, 11)%></a><em class="tn-count tn-text-note"><%=GetResourceString("Label_TodayShareNum",ApplicationIDs.Instance().Share()) %>：<%=userShareThread.SiteShareThread.DayUserCount%></em>
                <%}
                  else
                  { %>
                <a title="<%=userShareThread.SiteShareThread.Subject %>" href="<%=userThreadUrl %>"
                    class="tn-text-heading">
                    <%=userShareThread.SiteShareThread.Subject %></a><em class="tn-count tn-text-note"><%=GetResourceString("Label_Share",ApplicationIDs.Instance().Share())%>：<%=userShareThread.SiteShareThread.DayUserCount %></em><span
                        class="tn-button tn-button-text-icon tn-button-secondary"><span class="tn-first-child"><span
                            class="tn-icon tn-icon-play"></span><a href="<%=userThreadUrl%>" title="<%=GetResourceString("Description_PlayMusic", ApplicationIDs.Instance().Share())%>"
                                class="tn-button-text"><%=GetResourceString("Action_PlayMusic", ApplicationIDs.Instance().Share())%></a>
                        </span></span>
                <%} %>
            </li>
            <%i++;
                  }
              }
              else
              { %>
            <li>
                <%if (mediaType == (int)MediaTypes.Video)
                      Response.Write(GetResourceString("Title_OtherMediaShareNotFound", applicationID));
                  else
                      Response.Write(GetResourceString("Title_OtherMusicShareNotFound", applicationID));%>
            </li>
            <%} %>
        </ul>
    </div>
</div>
<div class="tn-blank10">
</div>
