﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<Link>>" %>
<div class="spb-friendly-links">
    <%if (Model != null && Model.Count > 0)
      {
          List<LinkCategory> listLinkCategory = ViewData.Get<List<LinkCategory>>("LinkCategories");
          if (listLinkCategory != null && listLinkCategory.Count > 0)
          {
              foreach (var itemCate in listLinkCategory)
              {
                  IEnumerable<Link> linksInCategory = Model.Where<Link>(n => n.CategoryID == itemCate.CategoryID);
                  if (linksInCategory.Count<Link>() > 0)
                  {%>
    <div class="tn-list-header">
        <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
            <strong>
                <%=itemCate.CategoryName%></strong>
        </div>
    </div>
    <ul class="tn-helper-reset tn-list">
        <% foreach (var itemLink in linksInCategory)
           {
               if (itemLink.CategoryID == itemCate.CategoryID)
               {
                   if (itemLink.LinkType == LinkTypes.Text)
                   {
                       Response.Write(string.Format("<li><a rel=\"nofollow\" target=\"_blank\" title=\"{0}\" href=\"{1}\">{2}</a></li>", itemLink.LinkTitle, itemLink.LinkHref, itemLink.Title));
                   }
                   else
                   {
                       Response.Write(string.Format("<li><a rel=\"nofollow\" target=\"_blank\" title=\"{0}\" href=\"{1}\"><img src=\"{2}\" /></a></li>", itemLink.LinkTitle, itemLink.LinkHref, SiteUrls.Instance().LinkPhoto(itemLink, LinkPosition.User)));
                   }
               }
           }%>
    </ul>
    <%}
                     }
                 }
             }%>
</div>
