﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<VoteThread>>" %>
<spb:Script runat="server" ID="jquery_form" Src="~/Utility/jquery/plugin/jquery.spb.menuButton.js"
    SetExpireDays="30" />
<%string userDomainName = Convert.ToString(ViewData["userDomainName"]);

  User currentDomainOwner = Users.GetUser(userDomainName, false);
  if (TempData["StatusMessageData"] != null)
  {
      StatusMessageData messageData = TempData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
      Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageData, 3000, true));
  }
  TempData["StatusMessageData"]=null;
%>
<%VoteScopes scopes = ViewData.Get<VoteScopes>("scopes", VoteScopes.myCreated);%>
<%if (Model.Records.Count > 0)
  { %>
<ul class="tn-list tn-helper-reset" id="ListMyVotes">
    <%
        foreach (VoteThread thread in Model.Records)
        {%>
    <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
        <div class="tn-list-item-area-left">
        </div>
        <div class="tn-list-item-area-right">
            <div class="tn-list-figure tn-widget">
                <div class="tn-list-figure-count tn-widget-content tn-corner-top">
                    <%=thread.TotalVoteCount %></div>
                <a class="tn-list-figure-button tn-state-default tn-corner-bottom" href="<%=SiteUrls.Instance().ShowVoteThread(thread.ThreadID) %>">
                    <%= GetResourceString("Title_Vote", ApplicationIDs.Instance().Vote())%></a>
            </div>
        </div>
        <div class="tn-list-item-area-main">
            <div class="tn-list-item-row">
                <h5 class="tn-helper-reset">
                    <a target="_blank" href="<%=SiteUrls.Instance().ShowVoteThread(thread.ThreadID) %>"
                        title="<%=StringUtils.Trim(thread.Subject,200)%>">
                        <%=StringUtils.Trim(thread.Subject,22) %></a></h5>
            </div>
            <div class="tn-list-item-row">
                <cite><a href="<%=SiteUrls.Instance().UserDomainHome(thread.UserID) %>" title="<%=thread.Author%>">
                    <%=thread.Author%></a></cite> <em class="tn-date tn-text-note">
                        <%=GetResourceString("Label_VoteStartTime", ApplicationIDs.Instance().Vote())%>
                        <%=Formatter.FormatFriendlyDate(thread.DateCreated) %></em> <em class="tn-date tn-text-note">
                            <%=GetResourceString("Label_IsTime",ApplicationIDs.Instance().Vote())%>
                            <%=Formatter.FormatFriendlyDate(thread.EndDate)%></em>
            </div>
            <div class="tn-list-item-row tn-list-item-summary">
                <%if (thread.VoteOptions.Count >= 0)
                  {
                      foreach (KeyValuePair<int, VoteOption> pair in thread.VoteOptions.Take(2))
                      {%>
                <%if (thread.IsMultiple)
                  { %>
                <p class="tn-helper-reset">
                    <input class="tn-checkbox" type="checkbox" disabled="disabled" />
                    <%=StringUtils.Trim(pair.Value.OptionName,7)%>
                </p>
                <%}
                  else
                  { %>
                <p class="tn-helper-reset">
                    <input class="tn-radiobutton" type="radio" disabled="disabled" />
                    <%=StringUtils.Trim(pair.Value.OptionName,7)%>
                </p>
                <%}
                      }
                  } %>
            </div>
            <div class="tn-list-item-row">
                <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Common_Comment")+"&nbsp;"+thread.CommentCount, SiteUrls.Instance().ShowVoteThread(thread.ThreadID) + "#comments", ButtonSizes.Default,HighlightStyles.Lite,IconTypes.Bubble, TextIconLayout.IconText)%>
                <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Common_Browse") + "&nbsp;" + thread.HitTimes, SiteUrls.Instance().ShowVoteThread(thread.ThreadID), ButtonSizes.Default, HighlightStyles.Lite, IconTypes.View, TextIconLayout.IconText)%>
                <%if (CurrentUser != null && ((CurrentUser.UserID == currentDomainOwner.UserID && thread.UserID == currentDomainOwner.UserID) || CurrentUser.IsAdministrator || CurrentUser.IsContentAdministrator))
                  {%>
                <span class="tn-action"><a class="tn-action-text" target="_blank" href="<%=SPBUrlHelper.Action("EditVoteThread", "UserDomainVote", new RouteValueDictionary{{"userDomainName",userDomainName},{"threadID",thread.ThreadID}})%>">
                    <%=GetResourceString("Action_Edit")%></a></span><span class="tn-action"><a class="tn-action-text"
                        href="javascript:;" onclick="if (confirm('<%=GetResourceString("Validate_AskDeleteVote",ApplicationIDs.Instance().Vote())%>')) {$('#ListMyVotes').parent().load('<%=SPBUrlHelper.Action("DeleteVoteThread", "UserDomainVote",new RouteValueDictionary{ {"userDomainName",userDomainName},{"votescopes",scopes},{"pageIndex",Model.PageIndex},{"threadID",thread.ThreadID}})%>');return false;}">
                        <%=GetResourceString("Action_Delete")%></a></span>
                <%} %>
            </div>
        </div>
    </li>
    <%} %>
</ul>
<div class="tn-pagination tn-helper-align-center">
    <%=SPBHtmlHelper.Instance().AjaxPagingButton(Model.TotalRecords,Model.PageSize, Model.PageIndex, 11,
                                         SPBUrlHelper.Action("Controller_ListVoteThreads", "UserDomainVote", new RouteValueDictionary { { "userDomainName", userDomainName }, { "votescopes", scopes }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
    <div class="tn-page-results tn-text-note">
        <%=string.Format(GetResourceString("Label_Pattern_TotalRecords"),ViewData.Model.TotalRecords) %>
    </div>
</div>
<%} %>

<script type="text/javascript">
    function pageIndexChange(url) {
        $('#ListVotes').parent().load(url);
    }
</script>

