﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<VoteThread>" %>
<%if (Model != null)
  { %>
<%
    
    bool isVote = ViewData.GetBool("isVote", true);
    bool canVote = CurrentUser != null && !isVote;
%>
<div class="spb-vote-block">
    <div class="tn-text-heading">
        <strong>
            <%=StringUtils.Trim(Model.Subject,15) %></strong>
    </div>
    <div class="tn-info-part tn-helper-align-right">
        <a class="tn-user-name tn-helper-left" href="<%=SiteUrls.Instance().UserDomainHome(Model.UserID) %>">
            <%=Model.Author %></a><em class="tn-text-note">
                <%=GetResourceString("Label_PartIn", ApplicationIDs.Instance().Vote())%><%=Model.VoterCount %></em></div>
    <form id="VoteForm" name="VoteForm" action="<%=SPBUrlHelper.Action("Vote","ChannelVote",new RouteValueDictionary{{"threadID",Model.ThreadID}}) %>"
    method="post">
    <div class="spb-vote-form">
        <div class="tn-histogram">
            <%
                foreach (VoteOption option in Model.VoteOptions.Values)
                { %>
            <div class="tn-histogram-item tn-helper-clearfix">
                <span class="tn-histogram-input">
                    <% 
                        if (Model.IsMultiple)
                        { %>
                    <input type="checkbox" id="optionID_<%=option.OptionID%>" class="tn-checkbox" name="optionID"
                        <% if(!canVote) Response.Write("disabled=\"disabled\""); %> value="<%=option.OptionID %>" />
                    <%}
                        else
                        { %>
                    <input name="optionID" type="radio" class="tn-radiobutton" id="optionID_<%=option.OptionID %>"
                        <% if(!canVote) Response.Write("disabled=\"disabled\""); %> value="<%=option.OptionID %>" />
                    <%} %></span>
                <label class="tn-histogram-label" for="optionID_<%=option.OptionID%>">
                    <%=option.OptionName %>
                </label>
            </div>
            <%} %>
        </div>
        <%if (canVote)
          { %>
        <div class="tn-form tn-border-gray tn-border-top">
            <label for="IsAnonymousVote">
                <input name="IsAnonymousVote" type="checkbox" value="true" class="tn-checkbox" id="IsAnonymousVote" />
                <%=GetResourceString("Label_AnonymousVote",ApplicationIDs.Instance().Vote())%></label>
        </div>
        <%} %>
        <div class="tn-blank10"></div>
        <div class="tn-form-row tn-form-row-button">
            <% if (CurrentUser==null)
               { %>
            <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Action_IWillVote", ApplicationIDs.Instance().Vote()), ButtonSizes.Default, HighlightStyles.Primary, new RouteValueDictionary() { { "href", SiteUrls.Instance().ShowVoteThread(Model.ThreadID) } },null)%>
            <%}
               else if (!isVote)
               { %>
            <%=SPBHtmlHelper.Instance().SubmitButton("newVoteButton", GetResourceString("Action_Vote",ApplicationIDs.Instance().Vote()), ButtonSizes.Default,  new RouteValueDictionary { { "onclick", "newVoteButtonClick();" } },null)%>
            <%} %>
            <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Action_LookResult", ApplicationIDs.Instance().Vote()), ButtonSizes.Default, HighlightStyles.Secondary, new RouteValueDictionary() { { "target", "_blank" }, { "href", SiteUrls.Instance().ShowVoteThread(Model.ThreadID, true) } },null)%>
        </div>
    </div>
    </form>
</div>

<script language="javascript">
            $(document).ready(function() {
                $("#VoteForm").validate({
                      rules: {
                          optionID: { required: true, maxBlength: <%=Model.MaxChooseCount %> }
                      },
                      messages: {
                          optionID: { required: "<%=GetResourceString("Validate_PleaseSelectVoteOptions",ApplicationIDs.Instance().Vote())%>", maxBlength: "<%=string.Format(GetResourceString("Validate_TheMostMoreXOption",ApplicationIDs.Instance().Vote()), Model.MaxChooseCount)%>" }
                      }
                  });
            });
            
                var newVoteButtonClick =function() {
                    if ($("#VoteForm").valid()) {
                        $("#newVoteButton").hide();
                        $("#newVoteButton_ForHide").show();
                    }
                   return false;
                }
</script>

<%} %>
