﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
   VoteUserDomainSubMenus? subMenu = null;
   if (ViewData["VoteUserDomainSubMenu"] != null)
       subMenu = (VoteUserDomainSubMenus)ViewData["VoteUserDomainSubMenu"];
   User currentDomainUser = Users.GetUser(userDomainName, false);

   bool isOwner = false;
   if (CurrentUser != null && (CurrentUser.UserID == currentDomainUser.UserID || CurrentUser.IsContentAdministrator))
       isOwner = true;               
%>
<% if (isOwner)
   {%>
<div class="spb-nav2-area">
    <div class="tn-wrapper-inner tn-helper-clearfix">
        <ul class="spb-nav2 tn-helper-reset tn-helper-left">
            <li <% if(subMenu!=null && subMenu== VoteUserDomainSubMenus.myCreated) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SPBUrlHelper.Action("ListMyVoteThreads","UserDomainVote",new RouteValueDictionary{{"userDomainName",userDomainName}})%>"
                    onclick="$('#ListVotes').parent().load('<%=SPBUrlHelper.Action("Controller_ListVoteThreads","UserDomainVote",new RouteValueDictionary{ {"userDomainName",userDomainName},{"votescopes",VoteScopes.myCreated},{"pageIndex",1}}) %>')">
                    <span>
                        <%=GetResourceString("Title_MyVote",ApplicationIDs.Instance().Vote())%></span>
                </a></li>
            <%
                if (currentDomainUser.UserType == UserTypes.PersonUser && (isOwner || CurrentUser.IsContentAdministrator))
                {%>
            <li <% if(subMenu!=null && subMenu== VoteUserDomainSubMenus.myFriend) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SPBUrlHelper.Action("ListMyFriendsVoteThreads","UserDomainVote",new RouteValueDictionary{{"userDomainName",userDomainName}})%>">
                    <span>
                        <%=GetResourceString("Title_MyFriendVote",ApplicationIDs.Instance().Vote())%></span></a></li>
            <%ViewData["VoteUserDomainSubMenu"] = VoteScopes.myFriend; %>
            <%} %>
            <li class="spb-nav-item"><a href="<%=SPBUrlHelper.Action("Home","ChannelVote") %>"
                target="_blank"><span>
                    <%=GetResourceString("Label_AllVotes",ApplicationIDs.Instance().Vote())%></span></a></li>
        </ul>
        <div class="tn-helper-right">
            <%=SPBHtmlHelper.Instance().LinkButton("ManageComments", GetResourceString("Title_MangerReview", ApplicationIDs.Instance().Vote()), SPBUrlHelper.Action("ManageComments", "UserDomainVote", new RouteValueDictionary { { "userDomainName", userDomainName }, { "pageIndex", 1 } }), ButtonSizes.Default, HighlightStyles.Default, null,TextIconLayout.TextOnly)%>
            <%=SPBHtmlHelper.Instance().LinkButton("NewVoteThread", GetResourceString("Action_StratVote", ApplicationIDs.Instance().Vote()), SPBUrlHelper.Action("NewVoteThread", "UserDomainVote", new RouteValueDictionary { { "userDomainName", userDomainName } }), ButtonSizes.Default, HighlightStyles.Primary, IconTypes.Add, TextIconLayout.IconText)%>
        </div>
    </div>
</div>
<%} %>
