﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<BlogThread>" %>

<asp:content contentplaceholderid="setPageID" runat="server"> id="Blog-EditBlogThread" </asp:content>
<asp:content contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["BlogSubMenu"] = null;
     Html.RenderPartial("Controls/Blogs/SubMenu.ascx"); %>
</asp:content>
<asp:content contentplaceholderid="templateContentRegion" runat="server"></asp:content>
<asp:content runat="server" contentplaceholderid="wideContent">
  <spb:Script runat="server" ID="jqueryForm" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
        SetExpireDays="30" />
  <spb:Script runat="server" ID="CollapsibleBox" Src="~/Utility/jquery/plugin/jquery.spb.CollapsibleBox.js"
        SetExpireDays="30" />
  <spb:Script runat="server" ID="qtip" Src="~/Utility/jquery/plugin/jquery.qtip-1.0.0-rc3.js"
        SetExpireDays="30" />
  <spb:Script runat="server" ID="swfupload" Src="~/Utility/UploadFiles/js/swfupload.js"
    SetExpireDays="30" />
  <spb:Script runat="server" ID="swfupload_queue" Src="~/Utility/UploadFiles/js/swfupload.queue.js"
    SetExpireDays="30" />
  <spb:Script runat="server" ID="fileprogress" Src="~/Utility/UploadFiles/js/fileprogress.js"
    SetExpireDays="30" />
  <spb:Script runat="server" ID="handlers" Src="~/Utility/UploadFiles/js/handlers.js"
    SetExpireDays="30" />
  <% List<BlogThreadType> blogThreadTypes = (List<BlogThreadType>)ViewData["blogTypes"];
     string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
     User domainUser = Users.GetUser(userDomainName, false);
     int BlogApplicationID = ApplicationIDs.Instance().Blog();
     UserTypes currentDomainUserType = UserTypes.PersonUser;
     BlogSection section = BlogSections.GetSection(domainUser.UserID, false);
     if (ViewData["CurrentDomainUserType"] != null)
         currentDomainUserType = (UserTypes)ViewData["CurrentDomainUserType"];

     string actionUrl = string.Empty;
     string pageTitle = string.Empty;
     if (Model.ThreadID > 0)
     {
         actionUrl = SPBUrlHelper.Action("UpdateBlogThread", "Blog", new RouteValueDictionary { { "userDomainName", userDomainName }, { "threadID", Model.ThreadID } });
         pageTitle = GetResourceString("Title_EditBlogArticle", BlogApplicationID);
     }
     else
     {
         actionUrl = SPBUrlHelper.Action("CreateBlogThread", "Blog", new RouteValueDictionary { { "userDomainName", userDomainName } });
         pageTitle = GetResourceString("Title_ReleaseBlogArticle", BlogApplicationID);
         Model.IsLocked = !section.EnableComments;
         Model.EnableRatings = section.EnableRating;
         Model.ModerationType = section.ModerationType;
     }
     %>
  <div id="editBlogThread" class="tn-box tn-widget tn-widget-content tn-corner-all tn-publish spb-edit-blog">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
      <h3 class="tn-helper-reset"><%=pageTitle%></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
      <form id="EditBlogThreadForm" action="<%=actionUrl %>" method="post" class="tn-form">
        <div class="tn-form tn-label-right">
          <%
            if (TempData["StatusMessageType"] != null)
            {
                StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);

                if (messageType == StatusMessageType.Success)
                {
                    Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, GetResourceString("Message_ArticleUpdateSuccess", BlogApplicationID), 2000, false));
                }
                else
                    Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent"), true));
                TempData["StatusMessageType"] = null;
            } %>
          <div class="tn-form-row tn-title">
            <input class="tn-textbox tn-input-longest tn-border-gray" id="PostSubject" name="PostSubject"
                                value="<%=Formatter.FormatSingleLinePlainTextForEdit(Model.Subject) %>" />
            <% if (blogThreadTypes.Count > 0)
                 { %>
            <select id="BlogThreadType" name="BlogThreadType">
              <%foreach (BlogThreadType blogThreadType in blogThreadTypes)
                    { %>
              <option value="<%=blogThreadType.TypeID %>" <% if (Model.BlogThreadTypeID == blogThreadType.TypeID) { Response.Write(" selected=\"selected\"");}%>> <%=blogThreadType.TypeName%></option>
              <% } %>
            </select>
            <%} %>
          </div>
          <div class="tn-form-row tn-editor">
            <% string uploadPhotoUrl = SPBUrlHelper.Action("UserContentSelector_UpdateBlogAttachments", "ChannelBlog", new RouteValueDictionary { { "threadID", Model.ThreadID }, { "isImage", true } });
                     string uploadAttachmentUrl = SPBUrlHelper.Action("UserContentSelector_UpdateBlogAttachments", "ChannelBlog", new RouteValueDictionary { { "threadID", Model.ThreadID }, { "isImage", false } }); %>
            <%=SPBHtmlHelper.Instance().HtmlEditor(HtmlEditorMode.Enhanced, "postBody", Model.GetBodyForEdit(), new RouteValueDictionary { { "id", "postBody" }, { "style", "width:100%;height:418px" } }, uploadPhotoUrl, uploadAttachmentUrl,false)%>
            <div class="tn-text-note"><%=string.Format(GetResourceString("Description_ArticleWordCountMax", BlogApplicationID),BlogSectionConfiguration.Instance().MinLengthForBody,BlogSectionConfiguration.Instance().MaxLengthForBody)%></div>
          </div>
          <div class="tn-form-row tn-classify">
            <label class="tn-form-label"><%= GetResourceString("Common_UserCategory")%><%=GetResourceString("Common_Colon") %></label>
            <% Html.RenderAction<BlogController>(n => n.Control_BlogThreadCategoryDropdownList(userDomainName, Model.UserCategoryID, "blogUserCategoryDDL", "tn-dropdownlist")); %>
          </div>
          <%if (BlogSectionConfiguration.Instance().EableUserEntrySiteCategory)
              { %>
          <div class="tn-form-row tn-category">
            <label class="tn-form-label"><%=GetResourceString("Common_SiteCategory")%><%=GetResourceString("Common_Colon")%></label>
            <%Html.RenderAction<ChannelController>(n => n.Control_SiteCategoryDropDownList(ApplicationIDs.Instance().Blog(), BlogSectionConfiguration.Instance().SiteCategoryLevel - 1, "blogSiteCategoryDDL", Model.SiteCategoryID, "tn-dropdownlist")); %>
          </div>
          <%} %>
          <div class="tn-form-row tn-write-tags tn-form-expanded tn-helper-clearfix">
            <label class="tn-form-label"><%=GetResourceString("Common_UserTag")%><%=GetResourceString("Common_Colon") %></label>
            <%        
                  ViewData["TagInputName"] = "userTags";
                  ViewData["userTagItemKey"] = UserTagItemKeys.Instance().BlogThread();
                  ViewData["SelectedUserTags"] = Model.Tags;
                %>
            <%Html.RenderPartial("Controls/UserTagSelector.ascx", ViewData);%>
          </div>
          <%if (Applications.IsEnabled(ApplicationIDs.Instance().News()) && Applications.IsInstalled(PresentAreaIDs.Instance().UserDomain(), domainUser.UserID, ApplicationIDs.Instance().News()))
              { %>
          <div class="tn-form-row tn-comment-switch">
            <label class="tn-form-label">同时投稿到资讯：</label>
            <label for="isTranspondToNews"></label>
            <div class="tn-input-multiple"> <%=SPBHtmlHelper.Instance().YesNoRadioButtonList("isTranspondToNews",false, new RouteValueDictionary { { "Class", "tn-radio-button" } })%> </div>
          </div>
          <%} %>
          <div class="tn-collapsible tn-collapsible-closed">
            <div class="tn-border-bottom tn-border-gray tn-collapsible-header">
              <h4 class="tn-helper-reset"><a href="javascript:;;"><%=GetResourceString("Title_AdvancedSettings")%></a></h4>
            </div>
            <div class="tn-blank10"></div>
            <div class="tn-collapsible-content" style="display:block;">
              <div class="tn-form-row tn-privacy">
                <label class="tn-form-label"><%=GetResourceString("Label_PrivacySetting")%><%=GetResourceString("Common_Colon") %></label>
                <%=SPBHtmlHelper.Instance().PrivacyStatusesDropDownList("setBlogThreadsPirvacyStatus", "tn-dropdownlist", Model.PrivacyStatus, Model.Password, currentDomainUserType)%> </div>
              <div class="tn-form-row tn-write-keyword">
                <label class="tn-form-label"><%=GetResourceString("Label_KeyWord")%><%=GetResourceString("Common_Colon") %></label>
                <input type="text" name="metaKeyWords" id="metaKeyWords" class="tn-textbox tn-input-longest tn-border-gray" value="<%=Model.Keywords %>" />
              </div>
              <div class="tn-form-row tn-write-summary tn-textarea-wrap">
                <label class="tn-form-label"><%=GetResourceString("Action_Summary")%><%=GetResourceString("Common_Colon") %></label>
                <textarea class="tn-textarea tn-input-longest tn-border-gray"  rows="8" cols="110"  name="postExcerpt" id="postExcerpt"><%=Model.Excerpt%></textarea>
                <span style="display:none"></span>
              </div>
              <div class="tn-form-row tn-evaluation-switch">
                <label class="tn-form-label"><%=GetResourceString("Label_AllowComment", BlogApplicationID)%><%=GetResourceString("Common_Colon") %></label>
                <div class="tn-input-multiple">
                  <input type="radio" value="true" name="ynRepaly" id="ynRepaly-true" <%if (!Model.IsLocked) Response.Write("checked=\"checked\""); %>  onclick="$('#allowComment').css('display','')" class="tn-radio-button" />
                  <label for="ynRepaly-true"  onclick="$('#allowComment').css('display','')" ><%=GetResourceString("Common_Yes")%></label>
                  <input type="radio" value="false" name="ynRepaly" id="ynRepaly-false" <%if (Model.IsLocked) Response.Write("checked=\"checked\""); %> class="tn-radio-button"  onclick="$('#allowComment').css('display','none')"/>
                  <label for="ynRepaly-false"  onclick="$('#allowComment').css('display','none')"><%=GetResourceString("Common_No")%></label>
                </div>
                <span id="allowComment"  <%if (Model.IsLocked)Response.Write("style=\"display:none\""); %>>
                <label class="tn-form-label"><%=GetResourceString("Label_AuditingComment", BlogApplicationID)%><%=GetResourceString("Common_Colon")%></label>
                <%=SPBHtmlHelper.Instance().CommentModerationDropDownList("CommentModerationDropDownList", "tn-dropdownlist", Model.ModerationType)%> </span> </div>
              <div class="tn-form-row tn-comment-switch">
                <label class="tn-form-label"><%=GetResourceString("Label_AllowAppraise", BlogApplicationID)%><%=GetResourceString("Common_Colon") %></label>
                <div class="tn-input-multiple"> <%=SPBHtmlHelper.Instance().YesNoRadioButtonList("ynEnableRatings", Model.EnableRatings, new RouteValueDictionary { { "Class", "tn-radio-button" } })%> </div>
              </div>
            </div>
          </div>
          <div class="tn-form-row tn-form-row-button">
            <label class="tn-form-label"></label>
            <input type="hidden" value="<%=Model.UserFeaturedImageAttachmentID %>" id="featurePicAttachmentID" name="featurePicAttachmentID" />
            <%=SPBHtmlHelper.Instance().SubmitButton("saveButtonInFrom", GetResourceString("Button_OK"), ButtonSizes.Large,null, null)%>
            <% if (Request.UrlReferrer != null)
                    {
                 %>
            <%=SPBHtmlHelper.Instance().CancelButton(Request.UrlReferrer.AbsoluteUri)%>
            <%} %>
          </div>
        </div>
      </form>
    </div>
    <script type="text/javascript">
        $(document).ready(function() {
        		$(".tn-collapsible").collapsibleBox();
       		 $("#metaKeyWords").qtip({content:'<%=GetResourceString("Label_SetArticlePageMetaTag", BlogApplicationID)%>'});
                $("#postExcerpt").qtip({content:'<%=GetResourceString("Description_InputArticleSummary", BlogApplicationID)%>'});
         $("#PostSubject").watermark("<%=GetResourceString("Validate_InputBlogName",BlogApplicationID)%>").select();
         
              $("#saveButtonInFrom").click(function() {
                if (!$("#EditBlogThreadForm").valid()) {
                    return false;
                }
            });
         
            $("#EditBlogThreadForm").validate({
                rules: {
                    PostSubject: { required: true, rangelength: [<%=BlogSectionConfiguration.Instance().MinLengthForTitle %>,<%=BlogSectionConfiguration.Instance().MaxLengthForTitle %>] },
                    postBody: { htmlEditorRequired: true,maxBlength:<%=BlogSectionConfiguration.Instance().MaxLengthForBody %> },
                    postExcerpt: { maxBlength: <%=BlogSectionConfiguration.Instance().MaxLengthForExcerpt %> },
                    metaKeyWords:{ maxBlength: 200 },
                    setBlogThreadsPirvacyStatus_Password:{required:true}
                    <%if (BlogSectionConfiguration.Instance().EableUserEntrySiteCategory)
              { %>,
                    blogSiteCategoryDDL:{required:<%=BlogSectionConfiguration.Instance().SiteCategoryRequired.ToString().ToLower() %>}
                    <%} %>
                },
                messages: {
                    PostSubject: { required: "<%=GetResourceString("Validate_InputTitle")%>", rangelength: "<%=GetResourceString("Validate_WordCountLimit", BlogApplicationID) %><%=GetResourceString("Common_Colon") %><%=BlogSectionConfiguration.Instance().MinLengthForTitle %>-<%=BlogSectionConfiguration.Instance().MaxLengthForTitle %>" },
                    postBody: { htmlEditorRequired: "<%=GetResourceString("Validate_InputArticleBody", BlogApplicationID) %>", maxBlength: "最大长度为<%=BlogSectionConfiguration.Instance().MaxLengthForBody %>字" },
                    postExcerpt: { maxBlength: "<%=string.Format(GetResourceString("Validate_MaxLength", BlogApplicationID),BlogSectionConfiguration.Instance().MaxLengthForExcerpt) %>" },
                    metaKeyWords: { maxBlength: "<%=GetResourceString("Validate_MaxLengthNotExceed", BlogApplicationID) %>" },
                    setBlogThreadsPirvacyStatus_Password:{required:"<%=GetResourceString("Validate_InputPassword")%>"}
                    <%if (BlogSectionConfiguration.Instance().EableUserEntrySiteCategory)
              { %>,
                   blogSiteCategoryDDL:{required:"<%=GetResourceString("Description_Required")%>"}
                   <%} %>
                }
            });
        });
</script>
  </div>
</asp:content>
