﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<PagingDataSet<BlogThread>>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="Blog-Home"
</asp:content>
<asp:content id="Content1" runat="server" contentplaceholderid="subMenusContent">
 <% ViewData["BlogUserDomainSubMenu"] = BlogUserDomainSubMenus.myBlog;
    Html.RenderPartial("Controls/Blogs/SubMenu.ascx");  %>
</asp:content>
<asp:content runat="server" contentplaceholderid="templateContentRegion">
   <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName"); %>
   <div class="tn-wrapper tn-template-r-230 tn-helper-clearfix">
   <%=SPBHtmlHelper.Instance().ShowAdvertisingInUserDomain("001100000001", userDomainName, new RouteValueDictionary { { "class", "spb-ad-banner" } })%>
                        <div class="tn-main">
                            <div class="tn-block">
                                <% bool isSummary = Request.QueryString.GetBool("isSummary", true);

                                   Html.RenderAction<BlogController>(n => n.Control_ListBlogThreads(userDomainName, isSummary, null, string.Empty, null, null, null, Request.QueryString.GetInt("pageIndex", 1))); %>
                            </div>
                        </div>
                        <div class="tn-block">
                                <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-search-box">
                                    <div class="tn-box-content tn-widget-content tn-corner-all">
                                        <div class="tn-search-box tn-helper-clearfix">
                                            <form id="searchForm" name="searchForm" action="<%=SearchConfiguration.Instance().SearchTypeSettingss[BlogSearchTypeSettings.CODE].GetSearchAtionFullUrl(SPBUrlHelper.Action("Search", "Blog",new RouteValueDictionary{ { "userDomainName",Html.GetParameterFromRouteDateOrQueryString("UserDomainName") }}))%>"
                                            method="post">
                                            <input class="tn-search-input tn-border-gray tn-border-tbl" type="text" maxlength="50"
                                                name="Keyword" />
                                            <span class="tn-search-button tn-search-ico-button tn-border-gray tn-bg-gray">
                                                <button onclick="$('#searchForm').submit();">
                                                    <span class="tn-icon tn-icon-find"></span>
                                                </button>
                                            </span>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <div class="tn-blank10">
                                </div>
                                <div id="blogFeed" class="tn-box tn-widget tn-widget-content tn-corner-all">
                                    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
                                        <h3 class="tn-helper-reset">
                                            <%=ResourceManager.GetString("Title_RssSubscription",Globals.GetCurrentUserLanguage(),ApplicationIDs.Instance().Blog()) %>
                                        </h3>
                                    </div>
                                    <div class="tn-box-content tn-widget-content tn-corner-bottom">
                                        <ul class="tn-side-menu">
                                            <li>
                                                <%=SPBHtmlHelper.Instance().Icon(IconTypes.Feed) %><a class="tn-menu-text" target="_blank"
                                                    href="<%=SiteUrls.Instance().BlogRss(Html.GetParameterFromRouteDateOrQueryString("UserDomainName")) %>">
                                                    <%=ResourceManager.GetString("Action_SubscriptionBlogArticle",Globals.GetCurrentUserLanguage(),ApplicationIDs.Instance().Blog())%></a>
                                            </li>
                                            <li>
                                                <%=SPBHtmlHelper.Instance().Icon(IconTypes.Feed) %><a class="tn-menu-text" target="_blank"
                                                    href="<%=SiteUrls.Instance().BlogCommentRss(Html.GetParameterFromRouteDateOrQueryString("UserDomainName")) %>">
                                                    <%=ResourceManager.GetString("Action_SubscriptionBlogComment",Globals.GetCurrentUserLanguage(),ApplicationIDs.Instance().Blog())%></a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="tn-blank10">
                                </div>
                                <%
                                    int nowYear = Html.GetParameterFromRouteDateOrQueryString("year", 0);
                                    int nowMonth = Html.GetParameterFromRouteDateOrQueryString("month", 0);
                                    int nowday = Html.GetParameterFromRouteDateOrQueryString("day", 0);
                                    Html.RenderAction<BlogController>(n => n.Control_ShowCalendar(userDomainName, nowYear, nowMonth, nowday)); %>
                                <div class="tn-blank10">
                                </div>
                                <div id="userCategories">
                                    <%Html.RenderAction<BlogController>(n => n.ListBlogUserCategories(userDomainName, null)); %>
                                </div>
                                <div class="tn-blank10">
                                </div>
                                <div id="userTags">
                                    <%Html.RenderAction<BlogController>(n => n.Control_ListBlogUserTags(userDomainName)); %>
                                </div>
                                <div class="tn-blank10">
                                </div>
                                <div id="archiveList">
                                    <%Html.RenderAction<BlogController>(n => n.Control_ArchiveList(userDomainName)); %>
                                </div>
                                <div class="tn-blank10">
                                </div>
                                <div id="newComments">
                                    <%Html.RenderAction<BlogController>(n => n.Control_NewBlogComments(userDomainName));%>
                                </div>
                                <div class="tn-blank10">
                                </div>
                        </div>
                        <%=SPBHtmlHelper.Instance().ShowAdvertisingInUserDomain("001100000002", userDomainName, new RouteValueDictionary { { "class", "spb-ad-banner-bottom" } })%>
                </div>       
   </asp:content>
<asp:content runat="server" contentplaceholderid="wideContentRegion"></asp:content>
