﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage" %>

<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server"> id="Blog-ManageBlogSettings" </asp:content>
<asp:content id="subMenusContent" runat="server" contentplaceholderid="subMenusContent">
  <% ViewData["BlogSubMenu"] = null;
     Html.RenderPartial("Controls/Blogs/SubMenu.ascx"); %>
</asp:content>
<asp:content id="templateContentRegion" runat="server" contentplaceholderid="templateContentRegion"> </asp:content>
<asp:content runat="server" contentplaceholderid="manageMenusContent">
  <%  string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int BlogApplicationID = ApplicationIDs.Instance().Blog(); %>
  <div id="manageMeun" class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
      <h3 class="tn-helper-reset"> <%=GetResourceString("Title_BlogManage", BlogApplicationID)%></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
      <ul class="tn-side-menu">
        <li><a class="tn-menu-text"
                        href="<%=SPBUrlHelper.Action("ManageBlogThreads", "Blog", new RouteValueDictionary { { "userDomainName", userDomainName },{"pageIndex",1} })%>"> <%=GetResourceString("Action_ArticleManage", BlogApplicationID)%></a></li>
        <li><a class="tn-menu-text"
                        href="<%=SPBUrlHelper.Action("ManageBlogComments", "Blog", new RouteValueDictionary { { "userDomainName", userDomainName } })%>"> <%=GetResourceString("Action_CommentManage")%></a></li>
        <li><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageBlogUserTags", "Blog", new RouteValueDictionary { { "userDomainName", userDomainName } })%>"> <%=GetResourceString("Action_TagManage")%></a></li>
        <li><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageBlogUserCategories", "Blog", new RouteValueDictionary { { "userDomainName", userDomainName } })%>"> <%=GetResourceString("Common_ManageCategory")%></a></li>
        <li  class="tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageBlogSettings","Blog",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"> <%=GetResourceString("Action_BlogSet", BlogApplicationID)%></a></li>
      </ul>
    </div>
  </div>
</asp:content>
<asp:content runat="server" contentplaceholderid="manageContent">
  <% BlogSection currentBlogSection = (BlogSection)ViewData["currentBlogSection"];
     int BlogApplicationID = ApplicationIDs.Instance().Blog(); %>
  <% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName"); %>
  <div id="blogSettings" class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
      <form class="tn-helper-reset" id="ManageBlogSettingsForm" action="<%=SPBUrlHelper.Action("UpdateBlogSettings","Blog",new RouteValueDictionary{{"userDomainName",Html.GetParameterFromRouteDateOrQueryString("userDomainName")}}) %>"
    method="post">
        <div class="tn-form tn-label-right">
          <div class="tn-blank10"></div>
          <%   
                    if (TempData["StatusMessageType"] != null)
                    {
                        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                        string currentUserDomainName = userDomainName;
                        if (messageType == StatusMessageType.Success)
                        {
                            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, GetResourceString("Message_SetSaved"), 3000, false));
                        }
                        else
                        {
                            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, GetResourceString("Message_UpdateFailed"), 3000, true));
                        }
                        TempData["StatusMessageType"] = null;                     
                    }    
                    %>
          <div class="tn-form-row">
            <label class="tn-form-label"> <%=GetResourceString("Label_BlogName", BlogApplicationID)%><%=GetResourceString("Common_Colon") %></label>
            <input name="BlogName" class="tn-textbox tn-input-medium tn-border-gray" id="BlogName" value="<%=currentBlogSection.SectionName %>" />
          </div>
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_AllowComment", BlogApplicationID)%><%=GetResourceString("Common_Colon") %></label>
            <div class="tn-input-multiple">
              <input type="radio" value="true" name="EnableCommentes" id="ynRepaly-true" <%if (currentBlogSection.EnableComments) Response.Write("checked=\"checked\""); %>  onclick="$('#allowComment').css('display','')" class="tn-radio-button" />
              <label for="ynRepaly-true"  onclick="$('#allowComment').css('display','')" ><%=GetResourceString("Common_Yes")%></label>
              <input type="radio" value="false" name="EnableCommentes" id="ynRepaly-false" <%if (!currentBlogSection.EnableComments) Response.Write("checked=\"checked\""); %> class="tn-radio-button"  onclick="$('#allowComment').css('display','none')"/>
              <label for="ynRepaly-false"  onclick="$('#allowComment').css('display','none')"><%=GetResourceString("Common_No")%></label>
            </div>
          </div>
          <div id="allowComment"  <%if (!currentBlogSection.EnableComments)Response.Write("style=\"display:none\""); %>>
            <div class="tn-form-row">
              <label class="tn-form-label"> <%=GetResourceString("Label_AllowAnonymityComment", BlogApplicationID)%><%=GetResourceString("Common_Colon")%></label>
              <div class="tn-input-multiple"> <%=SPBHtmlHelper.Instance().YesNoRadioButtonList("EnableAnonymousPosting", currentBlogSection.EnableAnonymousPosting, new RouteValueDictionary { { "Class", "tn-radiobutton" } })%> </div>
            </div>
            <div class="tn-form-row">
              <label class="tn-form-label"> <%=GetResourceString("Label_CommentNeedAuditing", BlogApplicationID)%><%=GetResourceString("Common_Colon")%></label>
              <%=SPBHtmlHelper.Instance().CommentModerationDropDownList("ModerationDDL", "tn-dropdownlist", currentBlogSection.ModerationType)%> <em class="tn-text-note"><%=GetResourceString("Description_IfOpenDisplay", BlogApplicationID)%> </em> </div>
          </div>
          <div class="tn-form-row">
            <label class="tn-form-label"> <%=GetResourceString("Label_OpenAppraise", BlogApplicationID)%><%=GetResourceString("Common_Colon") %></label>
            <div class="tn-input-multiple"> <%=SPBHtmlHelper.Instance().YesNoRadioButtonList("EnableRating",currentBlogSection.EnableRating,new RouteValueDictionary{{"Class","radiobutton"}}) %> <em class="tn-text-note"><%=GetResourceString("Description_OpenMakeStarRating", BlogApplicationID)%> </em> </div>
          </div>
          <div class="tn-form-row tn-form-row-button">
            <label class="tn-form-label"></label>
            <%=SPBHtmlHelper.Instance().SubmitButton("saveSubmit", GetResourceString("Button_Save"), ButtonSizes.Default, new RouteValueDictionary { { "class", "tn-button-text" } },null)%>
            <% if (Request.UrlReferrer != null)
                       {%>
            <%=SPBHtmlHelper.Instance().CancelButton(ButtonSizes.Default, Request.UrlReferrer.AbsoluteUri) %>
            <%} %>
          </div>
        </div>
      </form>
    </div>
  </div>
  <script type="text/javascript">

    $(document).ready(function() {
        $("#ManageBlogSettingsForm").validate({
            rules: {

                BlogName: { required: true, maxBlength: 20 }
            },
            messages: {

                BlogName: { required: "<%=GetResourceString("Validate_InputBlogName",BlogApplicationID)%>", maxBlength: "<%=string.Format(GetResourceString("Validate_MaxLength",BlogApplicationID),20) %>" }
            }
        });

        $("#saveSubmit").click(function() {
            if (!$("#ManageBlogSettingsForm").valid()) {
                return false;
            }
        });
    }); 
</script>
</asp:content>
