﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<BlogThread>" %>

<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server"> id="Blog-ShowBlogThread" </asp:content>
<asp:content id="subMenusContent" runat="server" contentplaceholderid="subMenusContent">
  <% ViewData["BlogSubMenu"] = null;
     Html.RenderPartial("Controls/Blogs/SubMenu.ascx"); %>
</asp:content>
<asp:content id="Content1" runat="server" contentplaceholderid="mainContent">
  <spb:Script runat="server" ID="jquery_ui_stars" Src="~/Utility/jquery/plugin/jquery.ui.stars-3.0.1.js" SetExpireDays="30" />
  <spb:Script runat="server" ID="JqueryFormJs" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js" SetExpireDays="30" />
  <spb:Script runat="server" ID="blockUI" Src="~/Utility/jquery/plugin/jquery.blockUI-2.3.3.js" SetExpireDays="30" />
  <spb:Script runat="server" ID="shCore" Src="~/Utility/syntaxhighlighter/scripts/shCore-2.0.296.js" SetExpireDays="30" />
  <spb:Script runat="server" ID="shLegacy" Src="~/Utility/syntaxhighlighter/scripts/shLegacy-2.0.296.js" SetExpireDays="30" />
  <spb:Script runat="server" ID="shBrushAllLanguage" Src="~/Utility/syntaxhighlighter/scripts/shBrushAllLanguage-2.0.296.js" SetExpireDays="30" />
  <spb:Script runat="server" ID="CollapsibleBox" Src="~/Utility/jquery/plugin/jquery.spb.CollapsibleBox.js" SetExpireDays="30" />
  <spb:Style runat="server" ID="shCore_css" Href="~/Utility/syntaxhighlighter/styles/shCore.css" />
  <spb:Style runat="server" ID="shThemeDefault_css" Href="~/Utility/syntaxhighlighter/styles/shThemeDefault.css" />
  <% 
      bool isManager = ViewData.GetBool("isManager", false);
      bool isSupManager = ViewData.GetBool("isSupManager", false);

      bool passwordRight = ViewData.GetBool("passwordRight", false);
      bool ismyFriend = ViewData.GetBool("ismyFriend", false);
      string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
      bool showBlogThread = true;
      bool errorAuditingStatus = ViewData.GetBool("errorAuditingStatus", false);
      int BlogApplicationID = ApplicationIDs.Instance().Blog();
      bool hasManagePermission = ViewData.GetBool("hasManagePermission", false);
      string blogThreadBody = Model.GetBody(hasManagePermission);
      if (errorAuditingStatus)
      {
          string errorMessage = ViewData.GetString("errorMessage", string.Empty);%>
  <div class="tn-widget">
    <div class="tn-cue-highlight tn-corner-all tn-message-box">
      <% Response.Write(errorMessage); %>
      <%
          if (CurrentUser != null && (CurrentUser.IsAdministrator || CurrentUser.IsContentAdministrator))
          {%>
      <%  
              int threadid = Model.ThreadID; 
        %>
      <span class="tn-helper-right"> <a href="<%=SPBUrlHelper.Action("Home", "Blog", new RouteValueDictionary { { "userDomainName", userDomainName } })%>"><%=GetResourceString("Title_ReturnBlogList",BlogApplicationID) %></a> </span> <span class="tn-helper-left"> <%=SPBHtmlHelper.Instance().Icon(IconTypes.Exclamation) %> </span>
      <div class="tn-helper-flowfix"> <%=GetResourceString("Description_AdministrationManageArticle", BlogApplicationID)%> <a  title="<%=GetResourceString("Description_CurrentArticlePassAuditing", BlogApplicationID) %>" id="SetIsPassButton" href="<%=SPBUrlHelper.Action("updateBlogAuditingStatuses","Blog",new RouteValueDictionary{{"threadID",threadid},{"userDomainName",userDomainName}})%>"><%=GetResourceString("Button_PassAuditing", BlogApplicationID)%></a> </div>
      <%}%>
    </div>
  </div>
  <%
      }
      if (!isManager)
      {
          switch (Model.PrivacyStatus)
          {
              case PrivacyStatuses.NeedPassword:
                  if (!passwordRight)
                  {
                      showBlogThread = false;
    %>
          <div class="tn-widget">
            <div class="tn-cue-highlight tn-corner-all tn-message-box"> <span class="tn-helper-right"> <a href="<%=SPBUrlHelper.Action("Home", "Blog", new RouteValueDictionary { { "userDomainName", userDomainName } })%>"><%=GetResourceString("Title_ReturnBlogList",BlogApplicationID) %></a> </span> <span class="tn-helper-left"> <%=SPBHtmlHelper.Instance().Icon(IconTypes.Exclamation) %> </span>
              <div class="tn-helper-flowfix"> <%=GetResourceString("Description_ArticleAlreadyPassword", BlogApplicationID)%>
                <a href="<%=SPBUrlHelper.Action("Control_PrivacyPassword", "Blog", new RouteValueDictionary { { "userDomainName", userDomainName }, { "threadID", Model.ThreadID }}) %>" id="havepwd"><%=GetResourceString("Common_HavePassword") %></a>
              </div>
            </div>
          </div>
                <script type="text/javascript">
                    $(document).ready(function () {
                        $('#havepwd').dialog({ title: "需要密码" });
                    });
                </script>
  <%
                  }
                  break;
              case PrivacyStatuses.OnlyFriend:
                  if (!ismyFriend)
                  {
                      showBlogThread = false;
    %>
  <div class="tn-widget">
    <div class="tn-cue-highlight tn-corner-all tn-message-box"> <span class="tn-helper-right"> <a href="<%=SPBUrlHelper.Action("Home", "Blog", new RouteValueDictionary { { "userDomainName", userDomainName } })%>"><%=GetResourceString("Title_ReturnBlogList",BlogApplicationID) %></a> </span> <span class="tn-helper-left"> <%=SPBHtmlHelper.Instance().Icon(IconTypes.Limit) %> </span>
      <div class="tn-helper-flowfix"> <%=GetResourceString("Description_OnlyFriendSee", BlogApplicationID)%>
        <% if (CurrentUser == null)
           {%>
        <%=GetResourceString("Action_LoginFirst",ApplicationIDs.Instance().User())%>
        <%}
           else
           { %>
        <a id="addFriendModal"  href="<%=SiteUrls.Instance().NewFriendInvitation(CurrentUser.UserName, Model.OwnerUserID) %>"><%=GetResourceString("Action_IntercourseFriend")%></a>
        <%} %>
      </div>
    </div>
  </div>
  <% 
                  }
                  break;
              case PrivacyStatuses.Privacy:
                  showBlogThread = false;
    %>
  <div class="tn-widget">
    <div class="tn-cue-highlight tn-corner-all tn-message-box"> <span class="tn-helper-right"> <a href="<%=SPBUrlHelper.Action("Home", "Blog", new RouteValueDictionary { { "userDomainName", userDomainName } })%>"><%=GetResourceString("Title_ReturnBlogList",BlogApplicationID) %></a> </span> <span class="tn-helper-left"> <%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock) %> </span>
      <div class="tn-helper-flowfix"> <%=GetResourceString("Description_ArticleAlreadySetprivacy", BlogApplicationID)%> </div>
    </div>
  </div>
  <%
break;
              case PrivacyStatuses.Public:
break;
              default:
break;
          }
      }
      if (isManager || !errorAuditingStatus)
      {
          if (showBlogThread)
          {%>
  <div id="showBlogThread" class="tn-box tn-widget tn-widget-content tn-corner-all tn-detail spb-blog-post">
    <div class="tn-box-content tn-widget-content tn-corner-all">
      <div class="tn-text-heading">
        <% if (TempData["StatusMessageType"] != null)
           {
               StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
               if (messageType == StatusMessageType.Success)
               {
                   Response.Write(SPBHtmlHelper.Instance().StatusMessage(StatusMessageType.Success, GetResourceString("Message_UpdateArticleSuccess", BlogApplicationID), 3000, false));
               }
               else
               {
                   Response.Write(SPBHtmlHelper.Instance().StatusMessage(StatusMessageType.Error, GetResourceString("Message_UpdateArticleFailed", BlogApplicationID), 3000, true));
               }
               TempData["StatusMessageType"] = null;
           } %>
        <h2 class="tn-title"> <%=Model.Subject%>
        <%switch (Model.PrivacyStatus)
          {
              case PrivacyStatuses.NeedPassword:
                  Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Key, "需要密码访问", new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                  break;
              case PrivacyStatuses.OnlyFriend:
                  Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Limit, "仅好友可见", new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                  break;
              case PrivacyStatuses.Privacy:
                  Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Limit, "私有", new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                  break;
              default:
                  break;

          } %>
          <% if (Model.IsEssential)
             {%>
          <%=SPBHtmlHelper.Instance().Icon(IconTypes.Elite, GetResourceString("Common_Essential"), new RouteValueDictionary { { "class", "tn-icon-inline" } })%>
          <%}
             if (Model.SpecialOrder > 0)
             {%>
          <%=SPBHtmlHelper.Instance().Icon(IconTypes.Top, GetResourceString("Common_SetTop"), new RouteValueDictionary { { "class", "tn-icon-inline" } })%>
          <%}
             if (ViewData.GetBool("isRecommended", false))
             {%>
          <%=SPBHtmlHelper.Instance().Icon(IconTypes.Flag, GetResourceString("Common_ManagerRecommend"), new RouteValueDictionary { { "class", "tn-icon-inline" } })%>
          <%} %>
        </h2>
      </div>
      <% if (isManager)
         {%>
      <div class="tn-actions tn-helper-align-right"> <span class="tn-action"> <a href="<%=SPBUrlHelper.Action("EditBlogThread","Blog",new RouteValueDictionary{{"userDomainName",userDomainName},{"threadID",Model.ThreadID}}) %>"><%=GetResourceString("Action_Edit")%></a> </span> <span class="tn-action"> <a onclick=" if (confirm('<%=GetResourceString("Message_ConfirmDeleteArticle", BlogApplicationID) %>')) { window.location.href='<%=SPBUrlHelper.Action("DeleteBlogThread","Blog",new RouteValueDictionary{{"ThreadID",Model.ThreadID},{"userDomainName",userDomainName},{"isManage",false},{"isShowBlogThread",true}}) %>' }" href="javascript:;"> <%=GetResourceString("Action_Delete")%></a> </span>
        <%if (isSupManager)
          { %>
        <span class="tn-action"> <a id="recommendBlogThreadModel" class="nyroModal" href="<%=SiteUrls.Instance().RecommendItem(ApplicationIDs.Instance().Blog(),Model.OwnerUserID, Model.ThreadID,Model.Subject)%>"> <%=GetResourceString("Common_ManagerRecommend")%></a> </span> <span class="tn-action">
        <input type="text" id="essentialHideInputStore" value="<%=Convert.ToInt32((Model.IsEssential))%>"  style="display: none" />
        <input type="text" id="topHideInputStore" value="<%=Model.SpecialOrder %>" style="display: none" />
        <a  id="setEssential" href="javascript:;" onclick="essentialManage();">
        <% if (Model.IsEssential) Response.Write(GetResourceString("Common_CancelEssential")); else Response.Write(GetResourceString("Common_SetEssential")); %>
        </a> </span> <span class="tn-action"> <a  id="setTop" href="javascript:;" onclick="topManage();">
        <% if (Model.SpecialOrder > 0) Response.Write(GetResourceString("Common_CancelPutter")); else Response.Write(GetResourceString("Common_SetTop")); %>
        </a> </span>
        <%} %>
      </div>
      <%} %>
      <div class="tn-info-part tn-text-note tn-border-gray tn-border-top tn-detail-info">
        <dl>
          <dt><%=GetResourceString("Label_Author") %><%=GetResourceString("Common_Colon") %></dt>
          <dd><a href="<%=SiteUrls.Instance().UserChannelHome(Model.OwnerUserID,BlogApplicationID)%>"><%=Model.Author %></a></dd>
        </dl>
        <dl>
          <dt><%=GetResourceString("Label_ReleaseTo",BlogApplicationID)%><%=GetResourceString("Common_Colon") %></dt>
          <dd><%=Formatter.FormatFriendlyDate( Model.PostDate,true) %></dd>
        </dl>
        <dl>
          <% if (Model.BlogSection.EnableComments)
             {%>
          <dt><%=GetResourceString("Common_Comment")%><%=GetResourceString("Common_Colon")%></dt>
          <dd><%=Model.CommentCount%></dd>
          <%}
             else
             { %>
          <dt><%=GetResourceString("Label_CloseComment", BlogApplicationID)%></dt>
          <%} %>
        </dl>
        <dl>
          <dt><%=GetResourceString("Common_Browse")%><%=GetResourceString("Common_Colon") %></dt>
          <dd><%=Model.HitTimes%></dd>
        </dl>
        <dl>
          <dt>RSS：</dt>
          <dd><%=Model.RssViewTimes%></dd>
        </dl>
      </div>
      <%if (!string.IsNullOrEmpty(Model.Excerpt))
        {%>
      <div class="tn-summaries tn-bg-gray tn-border-gray"> <%=Model.Excerpt%> </div>
      <%} %>
      <div class="tn-detail-text"> <%=blogThreadBody%> </div>
      <%
List<Attachment> attachments = ViewData.Get<List<Attachment>>("attachements", null);
if (attachments != null && attachments.Count(n => !n.IsImage) > 0)
{%>
      <div class="tn-annex-fix">
        <div class="tn-text-heading tn-border-bottom tn-border-gray">
          <h4><%=GetResourceString("Label_Attachment") %></h4>
          <%=SPBHtmlHelper.Instance().Icon(IconTypes.PaperClip) %> </div>
        <ul class="tn-helper-reset tn-list tn-annex-list">
          <%foreach (var attachment in attachments)
            {
                if (!attachment.IsImage)
                {
      				%>
          <li class="tn-annex-item"> <span class="tn-annex-icon"> <%=SPBHtmlHelper.Instance().ShowBlogAttachmentThumbnail(attachment, ContentTypeThumbnailSize.Small) %></span> <a href="<%=SiteUrls.Instance().DownloadBlogAttachment(attachment.AttachmentID) %>"
                    target="_blank"> <%=attachment.FriendlyFileName %></a> <span class="tn-count tn-text-note"><%=attachment.Friendlylength %></span> </li>
          <%}
            } %>
        </ul>
      </div>
      <%}
if (Model.PrevThreadID > 0 || Model.NextThreadID > 0)
{%>
      <div class="tn-info-part tn-border-gray tn-border-top tn-context">
        <% if (Model.PrevThreadID > 0)
           {%>
        <dl>
          <dt><%=GetResourceString("Description_LastBook", BlogApplicationID)%><%=GetResourceString("Common_Colon")%></dt>
          <dd> <a href="<%=SPBUrlHelper.Action("ShowBlogThread","Blog",new RouteValueDictionary{{"userDomainName",userDomainName},{"threadID",Model.PrevThreadID}}) %>"> <%=Model.PrevThreadSubject%></a></dd>
        </dl>
        <%} if (Model.NextThreadID > 0)
           {%>
        <dl>
          <dt><%=GetResourceString("Description_NextBook", BlogApplicationID)%><%=GetResourceString("Common_Colon")%></dt>
          <dd><a href="<%=SPBUrlHelper.Action("ShowBlogThread", "Blog", new RouteValueDictionary { { "userDomainName", userDomainName }, { "threadID", Model.NextThreadID } })%>"> <%=Model.NextThreadSubject%></a></dd>
        </dl>
        
        <%} %>
      </div>
      <%} if (Model.UserCategory != null)
{%>
      <div class="tn-info-part tn-sort-vest">
        <dl>
          <dt><%= GetResourceString("Common_Category") %><%=GetResourceString("Common_Colon") %></dt>
          <dd><a href="<%=SPBUrlHelper.Action("ListBlogThreadsByUserCategory","Blog",new RouteValueDictionary{{"userDomainName",userDomainName},{"categoryID",Model.UserCategory.CategoryID}}) %>"> <%=Model.UserCategory.CategoryName%></a></dd>
        </dl>
      </div>
      <%} %>
      <%
IList<string> userTags = Model.Tags;
if (userTags != null && userTags.Count > 0)
{%>
      <div class="tn-info-part tn-tags">
        <dl>
          <dt><%=GetResourceString("Common_UserTag")%><%=GetResourceString("Common_Colon") %></dt>
          <%
string tags = string.Empty;
foreach (string tag in userTags)
{
    tags += string.Format("<dd><a href='{0}' title='{1}'>&nbsp;{2}&nbsp;</a></dd>", SiteUrls.Instance().ListBlogThreadsByUserTag(userDomainName, tag), tag, tag);
}
Response.Write(tags);
               %>
        </dl>
      </div>
      <%} %>
      <div class="tn-feedback tn-helper-clearfix tn-border-gray tn-border-top ">
        <div class="tn-helper-right">
          <% if (!Model.IsLocked && Model.BlogSection.EnableComments && !(CurrentUser == null && (!SiteSettingsManager.GetSiteSettings().EnableAnonymousPosting || !Model.BlogSection.EnableAnonymousPosting)))
             {%>
          <%=SPBHtmlHelper.Instance().LinkButton("commentButton", GetResourceString("Common_Comment"), "#Comment", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Bubble, TextIconLayout.IconText)%>
          <%} %>
          <% if (CurrentUser == null || CurrentUser != null && CurrentUser.UserType == UserTypes.PersonUser)
             {%>
          <% if (Model.PrivacyStatus == PrivacyStatuses.Public)
             {
                 string blogThreadFeatureImageUrl = string.Empty;
                 if (Model.UserFeaturedImageAttachmentID > 0)
                     blogThreadFeatureImageUrl = SiteUrls.Instance().BlogPhotoUrl(Model.UserFeaturedImageAttachmentID, BlogPhotoTypes.Title);
                        %>
          <% if (Model.PrivacyStatus != PrivacyStatuses.Privacy)
             {
                 if (CurrentUser != null && CurrentUser.UserID > 0)
                 {%>
          <%=SPBHtmlHelper.Instance().LinkButton("shareLink", GetResourceString("Common_Share"), SiteUrls.Instance().ShareInModal(true, Request.RawUrl, Model.Subject, HtmlUtils.TrimHtml(Model.GetBody(false), 140), blogThreadFeatureImageUrl, ApplicationIDs.Instance().Blog(), Model.OwnerUserID, Model.Author), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Share, TextIconLayout.IconText)%>
          <%}
                 else
                 {%>
          <%=SPBHtmlHelper.Instance().LinkButton("shareLink1", GetResourceString("Common_Share"), SiteUrls.Instance().Login(true), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Share, TextIconLayout.IconText)%>
          <% }
             } %>
          <%} %>
          <%} %>
          <%=SPBHtmlHelper.Instance().LinkButton("reportThisBlogThread", GetResourceString("Button_Report"), SiteUrls.Instance().NewImpeachReport(), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Alert, TextIconLayout.IconText)%> </div>
      </div>
      <div class="tn-rating">
        <div class="tn-rating-cont tn-helper-clearfix">
          <% if (CurrentUser == null || (!Model.EnableRatings))
             { %>
          <%=SPBHtmlHelper.Instance().ShowRating(Model.RatingSum, Model.TotalRatings,true,true)%>
          <%}
             else
             { %>
          <%=SPBHtmlHelper.Instance().RatingButton(Model.ThreadID, "blogThreadRatingButton", Model.RatingSum, Model.TotalRatings, SPBUrlHelper.Action("Rate", "ChannelBlog"), "ratingCallback()")%>
          <%} %>
        </div>
      </div>
      <div id="ListRatingUsers">
      <%  //评分详情
             IList<Rating> ratings = ViewData.Get<IList<Rating>>("ratings");
             if (ratings.Count > 0)
             {
                 Html.RenderAction<ChannelBlogController>(n => n.Control_ListRatingUsers(Model.ThreadID, 30));
             } %>
          </div>
      <%Html.RenderAction<BlogController>(n => n.Control_CorrelativeBlogThreads(userDomainName, Model.ThreadID)); %>
      <div class="tn-blank10"></div>
      <div id="footPrintsList">
        <%Html.RenderAction<BlogController>(n => n.ListFootPrints(userDomainName, Model.ThreadID, 9)); %>
      </div>
      <%=SPBHtmlHelper.Instance().ShowAdvertisingInUserDomain("001101110001", userDomainName, new RouteValueDictionary { { "class", "spb-ad-main-bottom" } })%>
        <% 
              if (Model.IsLocked)
                  Response.Write(GetResourceString("Message_ThisLocked_NotAllowedComment", BlogApplicationID));
              else
              {
                  int pageIndex = Html.GetParameterFromRouteDateOrQueryString<int?>("pageIndex") ?? 1;
               %>
                <div class="tn-comment-wrap">
                      <div id="BlogThreadCommentsDiv">
                    <% Html.RenderAction<BlogController>(n => n.Control_BlogThreadComments(userDomainName, Model.ThreadID, pageIndex)); %>    
                     </div>
                    <% Html.RenderAction<BlogController>(n => n.Control_NewBlogComment(userDomainName, Model.ThreadID, pageIndex, false)); %>
                 </div>
           <%} %>
    </div>
  </div>
  <%}
      } if (CurrentUser != null && CurrentUser.IsContentAdministrator)
      { %>
  <script type="text/javascript">
           function essentialManage() {
            if (($('#essentialHideInputStore').val()) > 0) {

                $.get('<%=SPBUrlHelper.Action("CancelEssential","Blog",new RouteValueDictionary{{"threadID",Model.ThreadID},{"userDomainName",userDomainName}}) %>', { threadID: '<%= Model.ThreadID %>' }, function(data) {
                    $("#setEssential").text("<%=GetResourceString("Common_SetEssential")%>");
                    $("#essentialHideInputStore").val("0");
                });
            }
            else {
                $.get('<%=SPBUrlHelper.Action("SetEssential","Blog",new RouteValueDictionary{{"threadID",Model.ThreadID},{"userDomainName",userDomainName}}) %>', { threadID: '<%= Model.ThreadID %>' }, function(data) {
                    $("#setEssential").text("<%=GetResourceString("Common_CancelEssential")%>");
                    $("#essentialHideInputStore").val("1");
                });
            }
        }

        function topManage() {
            if (($('#topHideInputStore').val()) > 0) {
                $.get('<%=SPBUrlHelper.Action("CancelTop","Blog",new RouteValueDictionary{{"threadID",Model.ThreadID},{"userDomainName",userDomainName}}) %>', { threadID: '<%= Model.ThreadID %>' }, function(data) {
                    $("#setTop").text('<%=GetResourceString("Common_SetTop")  %>');
                    $('#topHideInputStore').val("0");
                });
            }
            else {
                $.get('<%=SPBUrlHelper.Action("SetTop","Blog",new RouteValueDictionary{{"threadID",Model.ThreadID},{"userDomainName",userDomainName}}) %>', { threadID: '<%= Model.ThreadID %>' }, function(data) {
                    $("#setTop").text("<%=GetResourceString("Common_CancelPutter")%>");
                    $('#topHideInputStore').val('<%=ViewData.GetInt("topSpecialOrder", 100) %>');
                });
            }
        }
               
               </script>
  <%} %>
  <script type="text/javascript">  
        $(document).ready(function() {
         $(".tn-collapsible").collapsibleBox();
            $(".tn-menu-button-wrap").menuButton();
            $('#addFriendModal,#recommendBlogThreadModel,#reportThisBlogThread').nyroModal({
                resizeable: true
            });            
            $('#shareLink').nyroModal({
                    resizeable: true,
                    width:500
            });
        //高亮显示
        SyntaxHighlighter.defaults['toolbar'] = false;
        SyntaxHighlighter.all();
       });

        function ratingCallback() {
            $("#ListRatingUsers").load("<%=SPBUrlHelper.Action("Control_ListRatingUsers","ChannelBlog",new RouteValueDictionary{{"itemID",Model.ThreadID},{"topNumber",30}}) %>");
        }
    </script>

</asp:content>
<asp:content id="wideContent" runat="server" contentplaceholderid="wideContent"> </asp:content>
