﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<FileThread>" %>
<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["FileSubMenu"] = null;
     Html.RenderPartial("Controls/Files/SubMenu.ascx"); %>
</asp:content>
<asp:content id="mainContentRegion" contentplaceholderid="mainContentRegion" runat="server"></asp:content>
<asp:content id="sidebarContentRegion" contentplaceholderid="sidebarContentRegion"
    runat="server"></asp:content>

<asp:content id="wideContent" runat="server" contentplaceholderid="wideContent">
  <spb:Script runat="server" ID="swfupload" Src="~/Utility/UploadFiles/js/swfupload.js"
        SetExpireDays="30" />
  <spb:Script runat="server" ID="swfupload_queue" Src="~/Utility/UploadFiles/js/swfupload.queue.js"
        SetExpireDays="30" />
  <spb:Script runat="server" ID="fileprogress" Src="~/Utility/UploadFiles/js/fileprogress.js"
        SetExpireDays="30" />
  <spb:Script runat="server" ID="handlers" Src="~/Utility/UploadFiles/js/handlers.js"
        SetExpireDays="30" />
  <% FileThread file = ViewData.Model;
     int applicationid = ApplicationIDs.Instance().File();
     string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
     int fileApplication = ApplicationIDs.Instance().File();
     string flashUrl = Globals.GetFullUrlInFileHandlerSite(FileAttachmentManager.Instance().StorageProviderName, WebUtils.ResolveUrl("~/Utility/UploadFiles/swfupload.swf"));
     FileAttachmentSettings fileAttachmentSettings = FileSectionConfiguration.Instance().AttachmentSettings;
     StringBuilder uploadFileTypes = new StringBuilder();
     string[] types = fileAttachmentSettings.Extensions.Split(',');
     foreach (string type in types)
     {
         if (!string.IsNullOrEmpty(type))
             uploadFileTypes.AppendFormat("*.{0};", type);
     }
     %>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-edit-file">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom"> <span class="tn-helper-right"> <a href="<%=SiteUrls.Instance().UserChannelHome(userDomainName,fileApplication)%>"> <%=GetResourceString("Action_ReturnMyFile", fileApplication)%></a> </span>
      <h3 class="tn-helper-reset">
        <% if (file.ThreadID > 0) Response.Write(GetResourceString("Title_PerfectFile", fileApplication)); else Response.Write(GetResourceString("Title_CreateFile", fileApplication)); %>
      </h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
      <form id="editFileForm" action="<%=SPBUrlHelper.Action("OrdinaryUpdate","File",new RouteValueDictionary{{"userDomainName",Html.GetParameterFromRouteDateOrQueryString("UserDomainName")},{"threadID",file.ThreadID}}) %>" method="post" enctype="multipart/form-data">
        <div class="tn-form tn-label-right">
          <%  
                     if (TempData["StatusMessageType"] != null)
                     {
                         StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                         if (messageType == StatusMessageType.Error)
                         {
                             Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
                             Response.Write("<br/>");
                         }
                         TempData["StatusMessageType"] = null;
                     }
                %>
          <div class="tn-form-row">
            <label class="tn-form-label"> 选择文件：</label>
            <input class="fileUpload" type="file" name="uploadFile" id="uploadFile" />
            <em>(
            <% if (file.ThreadID > 0) Response.Write("重新上传文件"); else Response.Write("上传文件"); %>
            )</em>
            <div class="tn-text-note"> <%=ViewData.GetString("restrictIllustration",string.Empty)%></div>
          </div>
          <div class="tn-form-row  tn-title">
            <input type="text" class="tn-textbox tn-input-longest tn-border-gray" name="subject" id="subject" value="<%=Formatter.FormatSingleLinePlainTextForEdit(file.Subject) %>" maxlength="256" />
          </div>
          <div class="tn-form-row tn-editor">
            <% string uploadPhotoUrl = SPBUrlHelper.Action("UserContentSelector_UpdateFileAttachments", "ChannelFile", new RouteValueDictionary { { "threadID", file.ThreadID } }); %>
            <%=SPBHtmlHelper.Instance().HtmlEditor(HtmlEditorMode.Enhanced, "description", file.GetBodyForEdit(), new RouteValueDictionary { { "style", "width:100%;height:300px;" } }, uploadPhotoUrl, string.Empty)%>
            <div class="tn-text-note"> <%=string.Format(GetResourceString("Description_Pattern_WordCountLimit",fileApplication),FileSectionConfiguration.Instance().MinLengthForBody,FileSectionConfiguration.Instance().MaxLengthForBody)%> </div>
          </div>
          <%if (FileSectionConfiguration.Instance().EableUserEntrySiteCategory)
                 { %>
          <div class="tn-form-row">
            <label class="tn-form-label"><%= GetResourceString("Common_SiteCategory")%><%=GetResourceString("Common_Colon") %> </label>
            <% Html.RenderAction<ChannelController>(n => n.Control_SiteCategoryDropDownList(fileApplication, PhotoConfiguration.Instance().SiteCategoryLevel - 1, "fileSiteCategoryDDL", file.SiteCategoryID, "tn-dropdownlist")); %>
          </div>
          <%} %>
          <div class="tn-form-row">
            <label class="tn-form-label"> <%=GetResourceString("Label_PrivacySetting")%><%=GetResourceString("Common_Colon") %> </label>
            <%=SPBHtmlHelper.Instance().PrivacyStatusesDropDownList("setFilePirvacyStatus", "dropDownList", file.PrivacyStatus, file.Password)%> </div>
          <div class="tn-form-row tn-write-tags tn-form-expanded tn-helper-clearfix">
            <label class="tn-form-label"><%=GetResourceString("Label_SetTag",fileApplication)%><%=GetResourceString("Common_Colon") %></label>
            <%
                        ViewData["TagInputName"] = "userTags";
                        ViewData["userTagItemKey"] = UserTagItemKeys.Instance().File();
                        if (file.ThreadID > 0)
                        {
                            List<string> selectedUserTags = file.UserTags;
                            ViewData["SelectedUserTags"] = selectedUserTags;
                        }
                        Html.RenderPartial("Controls/UserTagSelector.ascx", ViewData);%>
          </div>
          
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_SetFolder",fileApplication)%><%=GetResourceString("Common_Colon") %> </label>
            <% Html.RenderAction<FileController>(n => n.Control_FileCategoryDropdownList(userDomainName, file.UserCategoryID, "fileUserCategoryDDL", "dropDownList")); %>
          </div>
          
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_DownloadIntegral",fileApplication)%><%=GetResourceString("Common_Colon") %> </label>
            <input type="text" class="tn-textbox tn-input-short tn-border-gray" id="price" value="<%=file.Price %>" name="price" />
            <label>
              <input type="checkbox" id="onlyAllowRegisteredUserDownload" class="tn-checkbox" name="onlyAllowRegisteredUserDownload"  value="true"
                                    <%if(file.OnlyAllowRegisteredUserDownload) Response.Write("checked=\"checked\""); %>/>
              <%=GetResourceString("Description_AllowRegeditUserDownload",fileApplication)%> </label>
          </div>
          <div class="tn-form-row tn-form-row-button">
            <label class="tn-form-label"> </label>
            <input type="hidden" value="<%=file.UserFeaturedImageAttachmentID %>" id="featurePicAttachmentID" name="featurePicAttachmentID" />
            <%=SPBHtmlHelper.Instance().SubmitButton("saveFileEditButton", file.ThreadID > 0 ? GetResourceString("Button_Save") : GetResourceString("Button_Save"), ButtonSizes.Large, null,null)%>
            <% if (Request.UrlReferrer != null)
                   {%>
            <%=SPBHtmlHelper.Instance().CancelButton(Request.UrlReferrer.AbsoluteUri)%>
            <%} %>
          </div>
        </div>
      </form>
    </div>
  </div>
 
  <script type="text/javascript"> 




         
            $(document).ready(function() {
           
                $("#editFileForm").validate({
                    rules: {
                    <%if(Model.ThreadID<=0)
    { %>
     uploadFile:{required:true},
     <%} %>
     subject:{ required: true, rangelength: [<%=FileSectionConfiguration.Instance().MinLengthForTitle %>, <%=FileSectionConfiguration.Instance().MaxLengthForTitle %>] },
                        description: { htmlEditorRange: [<%=FileSectionConfiguration.Instance().MinLengthForBody %>,<%=FileSectionConfiguration.Instance().MaxLengthForBody %>] },
                        price:{digits:true},
                        setFilePirvacyStatus_Password:{required:true}   
                          <%if (FileSectionConfiguration.Instance().EableUserEntrySiteCategory)
                   { %>,
                    fileSiteCategoryDDL:{required:<%=FileSectionConfiguration.Instance().SiteCategoryRequired.ToString().ToLower() %>}
                    <%} %>
                        
                    },
                    messages: {
                    <%if(Model.ThreadID<=0)
    { %>
     uploadFile:{required:"必填"},
     <%} %>
                    subject: { required: "<%=GetResourceString("Validate_InputTitle")%>", rangelength: "<%=string.Format(GetResourceString("Validate_Pattern_WordCountLimit", fileApplication), FileSectionConfiguration.Instance().MinLengthForTitle, FileSectionConfiguration.Instance().MaxLengthForTitle)%>" },
                        description: { htmlEditorRange: "<%=string.Format(GetResourceString("Validate_Pattern_DetailWordLimit", fileApplication), FileSectionConfiguration.Instance().MinLengthForBody, FileSectionConfiguration.Instance().MaxLengthForBody)%>" },
                        price:{digits:"<%=GetResourceString("Validate_EnterInt",fileApplication) %>"},
                        setFilePirvacyStatus_Password:{required:"<%=GetResourceString("Validate_InputPassword") %>"}
                         <%if (FileSectionConfiguration.Instance().EableUserEntrySiteCategory)
              { %>,
                   fileSiteCategoryDDL:{required:"<%=GetResourceString("Description_Required")%>"}
                   <%} %>
                    }
                });
                $("#saveFileEditButton").click(function(){
                    if (!$("#editFileForm").valid())             
                    return false;
                });
            });
    </script>
</asp:content>
