﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<FileThread>" %>
<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["FileSubMenu"] = null;
     Html.RenderPartial("Controls/Files/SubMenu.ascx"); %>
</asp:content>
<asp:content id="mainContentRegion" contentplaceholderid="mainContentRegion" runat="server"></asp:content>
<asp:content id="sidebarContentRegion" contentplaceholderid="sidebarContentRegion"
    runat="server"></asp:content>

<asp:content id="wideContent" runat="server" contentplaceholderid="wideContent">
  <spb:Script runat="server" ID="swfupload" Src="~/Utility/UploadFiles/js/swfupload.js"
        SetExpireDays="30" />
  <spb:Script runat="server" ID="swfupload_queue" Src="~/Utility/UploadFiles/js/swfupload.queue.js"
        SetExpireDays="30" />
  <spb:Script runat="server" ID="fileprogress" Src="~/Utility/UploadFiles/js/fileprogress.js"
        SetExpireDays="30" />
  <spb:Script runat="server" ID="handlers" Src="~/Utility/UploadFiles/js/handlers.js"
        SetExpireDays="30" />
  <% FileThread file = ViewData.Model;
     int applicationid = ApplicationIDs.Instance().File();
     string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
     int fileApplication = ApplicationIDs.Instance().File();
     string flashUrl = Globals.GetFullUrlInFileHandlerSite(FileAttachmentManager.Instance().StorageProviderName, WebUtils.ResolveUrl("~/Utility/UploadFiles/swfupload.swf"));
     FileAttachmentSettings fileAttachmentSettings = FileSectionConfiguration.Instance().AttachmentSettings;
     StringBuilder uploadFileTypes = new StringBuilder();
     string[] types = fileAttachmentSettings.Extensions.Split(',');
     foreach (string type in types)
     {
         if (!string.IsNullOrEmpty(type))
             uploadFileTypes.AppendFormat("*.{0};", type);
     }
     %>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-create-file">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom"> <span class="tn-helper-right"> <a href="<%=SiteUrls.Instance().UserChannelHome(userDomainName,fileApplication)%>"> <%=GetResourceString("Action_ReturnMyFile", fileApplication)%></a> </span>
      <h3 class="tn-helper-reset">
        <% if (file.ThreadID > 0) Response.Write(GetResourceString("Title_PerfectFile", fileApplication)); else Response.Write(GetResourceString("Title_CreateFile", fileApplication)); %>
      </h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
      <% if (file.ThreadID <= 0)
       { %>
      <div class="spb-upload-files" id="uploadFileDiv">
        <div class="spb-upload-wrapper">
          <div class="spb-upload-fieldset" id="fsUploadProgress"> </div>
          <div class="spb-upload-status" id="divStatus"></div>
          <div class="spb-upload-actions"> <span id="spanButtonPlaceHolder"></span> </div>
        </div>
        <div class="spb-upload-tips tn-border-gray tn-border-bottom"><strong><%=GetResourceString("Description_FileUploadNotice", applicationid)%><%=GetResourceString("Common_Colon")%></strong><br/>
          <span class="tn-text-note"><%=GetResourceString("Description_AllowUploadType",applicationid)%><%=GetResourceString("Common_Colon")%></span>
          <% foreach (string extensions in fileAttachmentSettings.Extensions.Split(','))
                   {
                       Response.Write(SPBHtmlHelper.Instance().ContentTypeThumbnail(extensions) + extensions + ", ");
                   } %>
          <br/>
          <span class="tn-text-note"> <%=GetResourceString("Description_AllowUploadSize",applicationid)%><%=GetResourceString("Common_Colon")%></span><%=Formatter.FormatFriendlyFileSize(fileAttachmentSettings.MaxAttachmentSize*1024) %> <br/>
          <br/>
          <span class="tn-text-note"> 如果遇到问题请选择：</span><a href="<%=SPBUrlHelper.Action("EditFile","File",new RouteValueDictionary{{"userDomainName",Html.GetParameterFromRouteDateOrQueryString("UserDomainName")}}) %>">普通上传</a> </div>
      </div>
      <%} %>
      <div id="editFileDiv" <% if(file.ThreadID<=0) Response.Write("style=\"display:none\""); %> >
        <form id="editFileForm" action="<%=SPBUrlHelper.Action("UpdateFile","File",new RouteValueDictionary{{"userDomainName",Html.GetParameterFromRouteDateOrQueryString("UserDomainName")},{"threadID",file.ThreadID}}) %>" method="post">
          <div class="tn-form tn-label-right">
            <%  
                     if (TempData["StatusMessageType"] != null)
                     {
                         StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                         if (messageType == StatusMessageType.Error)
                         {
                             Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
                             Response.Write("<br/>");
                         }
                         TempData["StatusMessageType"] = null;
                     }   
                %>
            <div class="tn-form-row  tn-title">
              <input type="text" class="tn-textbox tn-input-longest tn-border-gray" name="subject" id="subject" value="<%=Formatter.FormatSingleLinePlainTextForEdit(file.Subject) %>" maxlength="256" />
            </div>
            <div class="tn-form-row tn-editor">
              <% string uploadPhotoUrl = SPBUrlHelper.Action("UserContentSelector_UpdateFileAttachments", "ChannelFile", new RouteValueDictionary { { "threadID", file.ThreadID } }); %>
              <%=SPBHtmlHelper.Instance().HtmlEditor(HtmlEditorMode.Enhanced, "description", file.GetBodyForEdit(), new RouteValueDictionary { { "style", "width:100%;height:300px;" } }, uploadPhotoUrl, string.Empty)%>
              <div class="tn-text-note"> <%=string.Format(GetResourceString("Description_Pattern_WordCountLimit",fileApplication),FileSectionConfiguration.Instance().MinLengthForBody,FileSectionConfiguration.Instance().MaxLengthForBody)%> </div>
            </div>
            <%if (FileSectionConfiguration.Instance().EableUserEntrySiteCategory)
                 { %>
            <div class="tn-form-row">
              <label class="tn-form-label"><%= GetResourceString("Common_SiteCategory")%><%=GetResourceString("Common_Colon") %> </label>
              <% Html.RenderAction<ChannelController>(n => n.Control_SiteCategoryDropDownList(fileApplication, PhotoConfiguration.Instance().SiteCategoryLevel - 1, "fileSiteCategoryDDL", file.SiteCategoryID, "tn-dropdownlist")); %>
            </div>
            <%} %>
            <div class="tn-form-row">
              <label class="tn-form-label"> <%=GetResourceString("Label_PrivacySetting")%><%=GetResourceString("Common_Colon") %> </label>
              <%=SPBHtmlHelper.Instance().PrivacyStatusesDropDownList("setFilePirvacyStatus", "dropDownList", file.PrivacyStatus, file.Password)%> </div>
            <div class="tn-form-row tn-write-tags tn-form-expanded tn-helper-clearfix">
              <label class="tn-form-label"> <%=GetResourceString("Label_SetTag",fileApplication)%><%=GetResourceString("Common_Colon") %> </label>
              <%
                        ViewData["TagInputName"] = "userTags";
                        ViewData["userTagItemKey"] = UserTagItemKeys.Instance().File();
                        if (file.ThreadID > 0)
                        {
                            List<string> selectedUserTags = file.UserTags;
                            ViewData["SelectedUserTags"] = selectedUserTags;
                        }
                        Html.RenderPartial("Controls/UserTagSelector.ascx", ViewData);%>
            </div>
            
            <div class="tn-form-row">
              <label class="tn-form-label"><%=GetResourceString("Label_SetFolder",fileApplication)%><%=GetResourceString("Common_Colon") %> </label>
              <% Html.RenderAction<FileController>(n => n.Control_FileCategoryDropdownList(userDomainName, file.UserCategoryID, "fileUserCategoryDDL", "dropDownList")); %>
            </div>
            
            <div class="tn-form-row">
              <label class="tn-form-label"><%=GetResourceString("Label_DownloadIntegral",fileApplication)%><%=GetResourceString("Common_Colon") %> </label>
              <input type="text" class="tn-textbox tn-input-short tn-border-gray" id="price" value="<%=file.Price %>" name="price" />
              <label>
                <input type="checkbox" id="onlyAllowRegisteredUserDownload" class="tn-checkbox" name="onlyAllowRegisteredUserDownload"  value="true"
                                    <%if(file.OnlyAllowRegisteredUserDownload) Response.Write("checked=\"checked\""); %>/>
                <%=GetResourceString("Description_AllowRegeditUserDownload",fileApplication)%> </label>
            </div>
            <div class="tn-form-row tn-form-row-button">
              <label class="tn-form-label"> </label>
              <input type="hidden" value="<%=file.UserFeaturedImageAttachmentID %>" id="featurePicAttachmentID" name="featurePicAttachmentID" />
              <%=SPBHtmlHelper.Instance().SubmitButton("saveFileEditButton", file.ThreadID > 0 ? GetResourceString("Button_Save") : GetResourceString("Button_Save"), ButtonSizes.Large, null,null)%>
              <% if (Request.UrlReferrer != null)
                   {%>
              <%=SPBHtmlHelper.Instance().CancelButton(Request.UrlReferrer.AbsoluteUri)%>
              <%} %>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
  <% if (file.ThreadID <= 0)
         {         
          %>
  <script type="text/javascript">
        var swfu;
        //需要设置的参数：
        //upload_url：处理上传文件的Url，
        //file_types：能够上传的文件类型，例如："*.jpg;*.gif" 用英文分号隔开，
        //file_queue_limit：允许排队的文件总数，0为不限制 ，
        //file_size_limit：单个文件大小的限制 参数接收一个单位，有效的单位有B、KB、MB、GB，默认单位是KB。例如: 2147483648 B, 2097152, 2097152KB, 2048 MB, 2 GB
        //attributes：需要传给后端进行处理的控件ID，例如："categoryID;tagName"
        $(document).ready(function () {
            var settings = {
                flash_url: '<%=flashUrl %>',
                upload_url: '<%=SiteUrls.Instance().FileUpload() %>',
                post_params: {
                    "currentUserID": "<%=EncryptManager.EncryptTokenForInviteFriend(Globals.GetCurrentUser().UserID.ToString()) %>"
                },
                file_size_limit: '<%=fileAttachmentSettings.MaxAttachmentSize %>',
                file_types: '<%=uploadFileTypes.ToString() %>',
                file_types_description: "All Files",
                file_queue_limit: '1',
                custom_settings: {
                    progressTarget: "fsUploadProgress"
                },
                debug: false,
                // Button settings
                button_image_url: '<%=WebUtils.ResolveUrl("~/Themes/Shared/Styles/Images/upload-button.png") %>', // Relative to the Flash file
                button_width: "140",
                button_height: "40",
                button_placeholder_id: "spanButtonPlaceHolder",
                button_text: '<span class="theFont"><%=GetResourceString("Label_SelectFile",fileApplication)%></span>',
                button_text_style: ".theFont { font-size: 14px; font-weight: bold; text-align: center; color:#333333; }",
                button_text_left_padding: 0,
                button_text_top_padding: 10,
                // The event handler functions are defined in handlers.js
                file_queued_handler: fileQueued,
                file_queue_error_handler: function (file, errorCode, message) {
                    switch (errorCode) {
                        case SWFUpload.QUEUE_ERROR.FILE_EXCEEDS_SIZE_LIMIT:
                            alert("超出单文件最大容量.");
                            break;
                        case SWFUpload.QUEUE_ERROR.ZERO_BYTE_FILE:
                            alert("不能上传0Byte文件.");
                            break;
                        case SWFUpload.QUEUE_ERROR.INVALID_FILETYPE:
                            alert("不允许的文件类型");
                            break;
                        default:
                            if (file !== null) {
                                alert("未知错误");
                            }
                            break;
                    }

                    $("#uploadFileDiv").find(".spb-upload-tips").show();
                    $("#editFileDiv").hide();

                    return false;
                },
                file_dialog_complete_handler: function (numFilesSelected, numFilesQueued) {
                    if (numFilesSelected != 1 && numFilesSelected != 0) {
                        alert("1次只能上传一个文件");
                        return;
                    }
                    swfu.addPostParam('associateID', '<%=CurrentUser.UserID %>');
                    swfu.startUpload();
                    $("#saveFileEditButton").attr("disabled", true);
                    if (numFilesQueued == 1)
                        swfu.setButtonDisabled(true);
                },
                upload_start_handler: function (file) {
                    $("#subject").val(file.name.substring(0, file.name.lastIndexOf(".")));
                    $("#uploadFileDiv").find(".spb-upload-tips").hide();
                    $("#editFileDiv").show();
                },
                upload_progress_handler: uploadProgress,
                upload_success_handler: function (file, serverData) {
                    var serverData = eval('(' + serverData + ')');
                    var progress = new FileProgress(file, this.customSettings.progressTarget);
                    if (!serverData.ok && serverData.message) {
                        progress.setError();
                        progress.toggleCancel(false);
                        progress.setStatus(serverData.message);
                        this.customSettings.queue_upload_count--;
                        alert(serverData.message);
                    }
                    else {
                        progress.setComplete();
                        progress.setStatus("完成.");
                        $("#saveFileEditButton").attr("disabled", false);
                    }
                },
                upload_complete_handler: null,
                queue_complete_handler: null
            };
            swfu = new SWFUpload(settings);
        });
         
    </script>
  <%} %>
  <script type="text/javascript">
            $(document).ready(function() {
                $("#editFileForm").validate({
                    rules: {
                        subject: { required: true, rangelength: [<%=FileSectionConfiguration.Instance().MinLengthForTitle %>, <%=FileSectionConfiguration.Instance().MaxLengthForTitle %>] },
                        description: { htmlEditorRange: [<%=FileSectionConfiguration.Instance().MinLengthForBody %>,<%=FileSectionConfiguration.Instance().MaxLengthForBody %>] },
                        price:{digits:true},
                        setFilePirvacyStatus_Password:{required:true}   
                          <%if (FileSectionConfiguration.Instance().EableUserEntrySiteCategory)
                   { %>,
                    fileSiteCategoryDDL:{required:<%=FileSectionConfiguration.Instance().SiteCategoryRequired.ToString().ToLower() %>}
                    <%} %>
                        
                    },
                    messages: {
                        subject: { required: "<%=GetResourceString("Validate_InputTitle")%>", rangelength: "<%=string.Format(GetResourceString("Validate_Pattern_WordCountLimit", fileApplication), FileSectionConfiguration.Instance().MinLengthForTitle, FileSectionConfiguration.Instance().MaxLengthForTitle)%>" },
                        description: { htmlEditorRange: "<%=string.Format(GetResourceString("Validate_Pattern_DetailWordLimit", fileApplication), FileSectionConfiguration.Instance().MinLengthForBody, FileSectionConfiguration.Instance().MaxLengthForBody)%>" },
                        price:{digits:"<%=GetResourceString("Validate_EnterInt",fileApplication) %>"},
                        setFilePirvacyStatus_Password:{required:"<%=GetResourceString("Validate_InputPassword") %>"}
                         <%if (FileSectionConfiguration.Instance().EableUserEntrySiteCategory)
              { %>,
                   fileSiteCategoryDDL:{required:"<%=GetResourceString("Description_Required")%>"}
                   <%} %>
                    }
                });
                $("#saveFileEditButton").click(function(){
                    if (!$("#editFileForm").valid())             
                    return false;
                });
            });
    </script>
</asp:content>
