﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<Dictionary<FriendConnectPath, List<User>>>" %>

<asp:content id="Content4" contentplaceholderid="setPageID" runat="server"> id="News-ListConnectPaths" </asp:content>
<asp:content id="Content2" contentplaceholderid="subMenusContent" runat="server">
  <%
      ViewData["isManager"] = true;
      ViewData["FriendUserDomainSubMenus"] = FriendUserDomainSubMenus.ConnectPaths;

      Html.RenderPartial("Controls/Friends/SubMenu.ascx"); %>
</asp:content>
<asp:content id="Content1" contentplaceholderid="WideContent" runat="server">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int friendApplicationID = ApplicationIDs.Instance().Friend();
    %>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-relation">
    <div class="tn-box-content tn-widget-content tn-corner-all">
      <%if (!string.IsNullOrEmpty(ViewData.GetString("displayName", string.Empty)))
      {%>
      <div class="tn-text-heading tn-border-gray tn-border-bottom"> <strong><%=string.Format(GetResourceString("Title_Pattern_ShowAllOfConnectPathsForOne", friendApplicationID), ViewData.GetString("displayName", string.Empty))%></strong> </div>
      <%} %>
      <div class="spb-relation-wrapper">
        <%foreach (var dic in ViewData.Model)
                {%>
        <ul class="tn-helper-clearfix">
          <%foreach (var user in dic.Value)
                      {%>
          <li class="tn-person">
            <div class="tn-avatar"><a href="<%=SiteUrls.Instance().UserDomainHome(user) %>"><%=SPBHtmlHelper.Instance().ShowUserAvatar(user, AvatarSizeTypes.Small) %><span class="tn-round-corner"></span></a></div>
            <a href="<%=SiteUrls.Instance().UserDomainHome(user) %>" class="tn-user-name"><%=SPBHtmlHelper.Instance().UserDisplayName(user) %></a></li>
          <%if (dic.Key.ToUserID != user.UserID)
                      {%>
          <li class="tn-and"><span class="tn-icon tn-icon-chain"></span></li>
          <%}%>
          <%}%>
          <li class="tn-count"><%=GetResourceString("Label_DistanceIndex",friendApplicationID) %><%=GetResourceString("Common_Colon") %><%=dic.Key.Distance %></li>
        </ul>
        <%}%>
      </div>
      <% if (ViewData.Model.Values.Count == 0) { Response.Write(GetResourceString("Description_NoTheseNetwork", friendApplicationID)); } %>
    </div>
  </div>
  <% int pageIndex = Html.GetParameterFromRouteDateOrQueryString("pageIndex", 1);
        if (pageIndex < 1)
        {
            pageIndex = 1;
        }
        int pageSize = ViewData.GetInt("pageSize", 100);

        int totalRecord = ViewData.GetInt("totalRecord", 0);%>
  <%if (totalRecord > pageSize)
                {%>
  <div class="tn-pagination tn-helper-align-center"> <%= SPBHtmlHelper.Instance().PagingButton(totalRecord, pageSize, pageIndex, 11, SPBUrlHelper.Action("ListConnectPaths", "Friend", new RouteValueDictionary { { "userDomainName", userDomainName }, { "pageIndex", "{0}" } }))%>
    <div class="tn-page-results tn-text-note"> <%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), totalRecord)%></div>
  </div>
  <%}%>
</asp:content>
