﻿<%@ Page Title="" Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage" %>
<asp:content ID="Content4" contentplaceholderid="setPageID" runat="server">
    id="News-ListMightKnowUsers"
</asp:content>
<asp:content id="Content1" contentplaceholderid="subMenusContent" runat="server">
  <%
      ViewData["isManager"] = true;
      ViewData["FriendUserDomainSubMenus"] = FriendUserDomainSubMenus.MightKnows;
      Html.RenderPartial("Controls/Friends/SubMenu.ascx"); %>
</asp:content>
<asp:content id="Content2" contentplaceholderid="wideContent" runat="server">
  <spb:Script runat="server" ID="jquery_form" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js" SetExpireDays="30" />
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int currentDomainUserID = ViewData.GetInt("currentDomainUserID", 0);
    IList<PersonUser> resultsCompany = (IList<PersonUser>)ViewData["resultsCompany"];
    IList<PersonUser> resultsSecondFriends = (IList<PersonUser>)ViewData["resultsSecondFriends"];
    IList<PersonUser> resultsCompanyTrade = (IList<PersonUser>)ViewData["resultsCompanyTrade"];
    IList<PersonUser> resultsSchool = (IList<PersonUser>)ViewData["resultsSchool"];
    IList<PersonUser> resultsCity = (IList<PersonUser>)ViewData["resultsCity"];
    IList<PersonUser> resultsHome = (IList<PersonUser>)ViewData["resultsHome"];
    int friendApplicationID = ApplicationIDs.Instance().Friend();
   %>   
  <div id="ListMightKnowUsers" class="tn-box tn-widget tn-widget-content tn-corner-all spb-might-know">     
      <div class="tn-box-content tn-widget-content tn-corner-all">      
       <%  if (resultsCompany != null)
           {
               if (resultsCompany.Count > 0)
               {%>                 
                     <div class="tn-text-heading tn-border-gray tn-border-bottom"><span class="tn-helper-right tn-text-note"><%=string.Format( GetResourceString("Description_Pattern_WeFindResultsCompany",friendApplicationID),resultsCompany.Count) %></span> 
                       <strong><%=GetResourceString("Description_ResultsCompany",friendApplicationID) %></strong>
                     </div>                 
                     <ul class="tn-avatar-list tn-helper-reset">
                              <%foreach (PersonUser colleague in resultsCompany)
                                { %>
                              <li class="tn-avatar-item">                  
                                <div class="tn-avatar"> <%=SPBHtmlHelper.Instance().ShowUserAvatar(colleague.UserName, true, HyperLinkTarget._blank, AvatarSizeTypes.Small, true)%></div>
                                <a class="tn-user-name" href="<%=SiteUrls.Instance().UserDomainHome(colleague.UserName)%>"><strong> <%=SPBHtmlHelper.Instance().UserDisplayName(colleague) %></strong></a>
                                <span><a class="addFriendModal" href="<%=SiteUrls.Instance().NewFriendInvitation(userDomainName,colleague.UserID) %>"><%= GetResourceString("Action_AddFriend")%></a></span>                  
                              </li>                     
                              <% 
                                  }
                                  %>
                        </ul>                     
               <% }
           }
       %>
      
      <% if (resultsSecondFriends != null)
         {
             if (resultsSecondFriends.Count > 0)
             {%>           
                <div class="tn-text-heading tn-border-gray tn-border-bottom"><span class="tn-helper-right tn-text-note"><%=string.Format(GetResourceString("Description_Pattern_WeFindResultsSecondFriends", friendApplicationID), resultsSecondFriends.Count)%></span> 
                 <strong><%=GetResourceString("Description_ResultsSecondFriends",friendApplicationID) %></strong>
             </div>                  
                <ul class="tn-avatar-list tn-helper-reset">
                  <%foreach (PersonUser friendsFriend in resultsSecondFriends)
                    { %>                 
                    <li class="tn-avatar-item">                  
                         <div class="tn-avatar"> <%=SPBHtmlHelper.Instance().ShowUserAvatar(friendsFriend.UserName, true, HyperLinkTarget._blank, AvatarSizeTypes.Small, true)%></div>
                         <a class="tn-user-name" href="<%=SiteUrls.Instance().UserDomainHome(friendsFriend.UserName)%>"><strong> <%=SPBHtmlHelper.Instance().UserDisplayName(friendsFriend) %></strong></a>
                         <span><a class="addFriendModal" href="<%=SiteUrls.Instance().NewFriendInvitation(userDomainName,friendsFriend.UserID)%>"><%= GetResourceString("Action_AddFriend")%></a></span>                  
                    </li>                      
                  <% 
                      }
                      %>
                </ul>   
      <%
          }
         } %>

        <%  if (resultsCompanyTrade != null)
            {
                if (resultsCompanyTrade.Count > 0)
                {%>                  
                  <div class="tn-text-heading tn-border-gray tn-border-bottom"><span class="tn-helper-right tn-text-note"><%=string.Format(GetResourceString("Description_Pattern_WeFindResultsCompanyTrade", friendApplicationID), resultsCompanyTrade.Count)%></span> 
                   <strong><%=GetResourceString("Description_ResultsCompanyTrade",friendApplicationID) %></strong>
                 </div>                 
                  <ul class="tn-avatar-list tn-helper-reset">
                      <%foreach (PersonUser CompanyTrade in resultsCompanyTrade)
                        { %>                 
                      <li class="tn-avatar-item">                  
                         <div class="tn-avatar"><%=SPBHtmlHelper.Instance().ShowUserAvatar(CompanyTrade.UserName, true, HyperLinkTarget._blank, AvatarSizeTypes.Small, true)%></div>
                         <a class="tn-user-name" href="<%=SiteUrls.Instance().UserDomainHome(CompanyTrade.UserName)%>"><strong> <%=SPBHtmlHelper.Instance().UserDisplayName(CompanyTrade) %></strong></a>
                         <span><a class="addFriendModal" href="<%=SiteUrls.Instance().NewFriendInvitation(userDomainName,CompanyTrade.UserID) %>"><%= GetResourceString("Action_AddFriend")%></a></span>                  
                    </li>              
                      <% 
                          }
                          %>
                    </ul>      
                <%}
            } %>

            <%  if (resultsSchool != null)
                {
                    if (resultsSchool.Count > 0)
                    {
                    %>                   
                      <div class="tn-text-heading tn-border-gray tn-border-bottom"><span class="tn-helper-right tn-text-note"><%=string.Format(GetResourceString("Description_Pattern_WeFindResultsSchool", friendApplicationID), resultsSchool.Count)%></span> 
                       <strong><%=GetResourceString("Description_ResultsSchool",friendApplicationID) %></strong>
                     </div>                        
                      <ul  class="tn-avatar-list tn-helper-reset">
                              <%foreach (PersonUser SchooFrindes in resultsSchool)
                                { %>                      
                                  <li class="tn-avatar-item">                  
                                     <div class="tn-avatar"><%=SPBHtmlHelper.Instance().ShowUserAvatar(SchooFrindes.UserName, true, HyperLinkTarget._blank, AvatarSizeTypes.Small, true)%></div>
                                     <a class="tn-user-name" href="<%=SiteUrls.Instance().UserDomainHome(SchooFrindes.UserName)%>"><strong> <%=SPBHtmlHelper.Instance().UserDisplayName(SchooFrindes) %></strong></a>
                                     <span><a class="addFriendModal" href="<%=SiteUrls.Instance().NewFriendInvitation(userDomainName,SchooFrindes.UserID) %>"><%= GetResourceString("Action_AddFriend")%></a></span>                  
                                  </li>                                  
                              <%}%>
                            </ul>                  
                    <%}
                } %>
 
            <%  if (resultsCity != null)
                {
                    if (resultsCity.Count > 0)
                    {
                %>            
                       <div class="tn-text-heading tn-border-gray tn-border-bottom"><span class="tn-helper-right tn-text-note"><%=string.Format(GetResourceString("Description_Pattern_WeFindResultsCity", friendApplicationID), resultsCity.Count)%></span> 
                       <strong><%=GetResourceString("Description_ResultsCity",friendApplicationID) %></strong>
                     </div>                
                       <ul class="tn-avatar-list tn-helper-reset">
                          <%foreach (PersonUser CityFriends in resultsCity)
                            { %>                   
                            <li class="tn-avatar-item">                  
                                     <div class="tn-avatar"><%=SPBHtmlHelper.Instance().ShowUserAvatar(CityFriends.UserName, true, HyperLinkTarget._blank, AvatarSizeTypes.Small, true)%></div>
                                     <a class="tn-user-name" href="<%=SiteUrls.Instance().UserDomainHome(CityFriends.UserName)%>"><strong> <%=SPBHtmlHelper.Instance().UserDisplayName(CityFriends) %></strong></a>
                                     <span><a class="addFriendModal" href="<%=SiteUrls.Instance().NewFriendInvitation(userDomainName,CityFriends.UserID) %>"><%= GetResourceString("Action_AddFriend")%></a></span>                  
                            </li>                 
                           
                          <% } %>
                        </ul>         
                <%
                    }
                } %>
            <%  if (resultsHome != null)
                {
                    if (resultsHome.Count > 0)
                    {
                %>        
                      <div class="tn-text-heading tn-border-gray tn-border-bottom"><span class="tn-helper-right tn-text-note"><%=string.Format(GetResourceString("Description_Pattern_WeFindYourFellow", friendApplicationID), resultsHome.Count)%></span> 
                     <strong><%=GetResourceString("Description_YourFellow",friendApplicationID) %></strong>
                   </div>                   
                      <ul class="tn-avatar-list tn-helper-reset">
                          <%foreach (PersonUser HomeFriends in resultsHome)
                            { %>                         
                           <li class="tn-avatar-item">                  
                                     <div class="tn-avatar"><%=SPBHtmlHelper.Instance().ShowUserAvatar(HomeFriends.UserName, true, HyperLinkTarget._blank, AvatarSizeTypes.Small, true)%></div>
                                     <a class="tn-user-name" href="<%=SiteUrls.Instance().UserDomainHome(HomeFriends.UserName)%>"><strong> <%=SPBHtmlHelper.Instance().UserDisplayName(HomeFriends) %></strong></a>
                                     <span><a class="addFriendModal" href="<%=SiteUrls.Instance().NewFriendInvitation(userDomainName,HomeFriends.UserID) %>"><%= GetResourceString("Action_AddFriend")%></a></span>                  
                            </li>
                         
                          <% }%>
                        </ul>                  
                <%}
                } %>
      </div>    
  </div>
  
  <script type="text/javascript">
    $(document).ready(function() {
        $('.addFriendModal').nyroModal({
            resizeable: true,
            width: 300,
            height: 300
        });
    });
</script>
  
</asp:content>
