﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<spb:Header ID="Header1" runat="server">
    <spb:Script runat="server" ID="jquery" Src="~/Utility/jquery/jquery.min-1.4.2.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="cookie" Src="~/Utility/jquery/plugin/jquery.cookie.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="core" Src="~/Utility/jquery/ui.core.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="widget" Src="~/Utility/jquery/ui.widget.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="nyroModal" Src="~/Utility/jquery/plugin/jquery.nyroModal-1.6.2.min.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="tabs" Src="~/Utility/jquery/ui.tabs.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="superfish" Src="~/Utility/jquery/plugin/jquery.superfish-1.4.8.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="menuButton" Src="~/Utility/jquery/plugin/jquery.spb.menuButton.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="watermarkinput" Src="~/Utility/jquery/plugin/jquery.watermarkinput.js" />
    <spb:Script runat="server" ID="validate" Src="~/Utility/jquery/plugin/jquery.validate-1.7.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="global" Src="~/Utility/tunynet_web_ui/global.js" />
    <spb:Script runat="server" ID="jqueryForm" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="blockUI" Src="~/Utility/jquery/plugin/jquery.blockUI-2.3.3.js"
        SetExpireDays="30" />
    
</spb:Header>
<body id="spb-home" class="tn-page-bg">
    <% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
        
       User currentDomainUser = Users.GetUser(userDomainName, false);
       string pageCode = "2001";
       bool isDesignMode = false;

       string selectedTheme = ThemeManager.GetSelectedThemeName(ViewContext);

       Dictionary<string, int> usedWidgetIDs = WidgetInstances.GetUsedWidgetIDs(currentDomainUser.UserID, pageCode, selectedTheme);
       if (usedWidgetIDs.Count == 0)
       {
           WidgetInstances.InitializeUserWidgetInstance(currentDomainUser.UserID, selectedTheme, pageCode);
       }
    %>
    <div id="tn-doc" class="tn-doc-bg">
        <div id="tn-header" class="tn-header-bg">
            <div class="tn-wrapper">
                <%  ViewData["ApplicationID"] = UserDomainSpecialAppIDs.Instance().Home();
                    Html.RenderPartial("Controls/Header.ascx", ViewData); %>
            </div>
        </div>
        <%
            string currentLayoutMode = Themes.GetOwnerLayout(currentDomainUser.UserID, selectedTheme, pageCode, false);
            string currentLayoutModes = string.Empty;
            foreach (char s in currentLayoutMode)
            {
                currentLayoutModes += ("-" + s);
            }
        %>
        <div class="tn-content-bg tn-doc2" id="tn-content">
            <div class="tn-wrapper">
                <%=SPBHtmlHelper.Instance().ShowAdvertisingInUserDomain("001100000003", userDomainName, new RouteValueDictionary { { "class", "spb-ad-banner" } })%>
                <div class=" spb-layout<%=currentLayoutModes%> tn-helper-clearfix">
                    <div class="spb-column-left">
                        <%
                            IList<WidgetZone> widgetZoneOfColomn1 = Themes.GetWidgetZones(selectedTheme, pageCode, 1, false);
                            foreach (var widgetZone in widgetZoneOfColomn1)
                            {
                        %>
                        <div class="spb-widget-zone">
                            <%
                                IList<WidgetInstance> widgetInstancesOfZone = WidgetInstances.GetOwnerWidgetInstances(currentDomainUser.UserID, widgetZone.ZoneID, false);
                                foreach (var widgetInstance in widgetInstancesOfZone)
                                {
                                    SPBHtmlHelper.Instance().RenderWidgetInstanceInUserDomain(Html, isDesignMode, widgetInstance, currentDomainUser);
                                }
                            %>
                        </div>
                        <%
                            }
                        %>
                    </div>
                    <div class="spb-column-center">
                        <%
                            if (currentLayoutMode.Length == 3)
                            {
                                IList<WidgetZone> widgetZoneOfColomn2 = Themes.GetWidgetZones(selectedTheme, pageCode, 2, false);
                                foreach (var widgetZone in widgetZoneOfColomn2)
                                {
                        %>
                        <div class="spb-widget-zone">
                            <%
                                IList<WidgetInstance> widgetInstancesOfZone = WidgetInstances.GetOwnerWidgetInstances(currentDomainUser.UserID, widgetZone.ZoneID, false);
                                foreach (var widgetInstance in widgetInstancesOfZone)
                                {
                                    SPBHtmlHelper.Instance().RenderWidgetInstanceInUserDomain(Html, isDesignMode, widgetInstance, currentDomainUser);
                                }
                            %>
                        </div>
                        <%
                            }
                            }
                        %>
                    </div>
                    <div class="spb-column-right">
                        <%
                            IList<WidgetZone> widgetZoneOfColomn3;
                            if (currentLayoutMode.Length == 3)
                                widgetZoneOfColomn3 = Themes.GetWidgetZones(selectedTheme, pageCode, 3, false);
                            else
                                widgetZoneOfColomn3 = Themes.GetWidgetZones(selectedTheme, pageCode, 2, false);

                            foreach (var widgetZone in widgetZoneOfColomn3)
                            {
                        %>
                        <div class="spb-widget-zone">
                            <%
                                IList<WidgetInstance> widgetInstancesOfZone = WidgetInstances.GetOwnerWidgetInstances(currentDomainUser.UserID, widgetZone.ZoneID, false);
                                foreach (var widgetInstance in widgetInstancesOfZone)
                                {
                                    SPBHtmlHelper.Instance().RenderWidgetInstanceInUserDomain(Html, isDesignMode, widgetInstance, currentDomainUser);
                                }
                            %>
                        </div>
                        <%
                            }
                        %>
                    </div>
                </div>
                <%=SPBHtmlHelper.Instance().ShowAdvertisingInUserDomain("001100000004", userDomainName, new RouteValueDictionary { { "class", "spb-ad-banner-bottom" } })%>
            </div>
        </div>
        <div id="tn-footer" class="tn-footer-bg">
            <div class="tn-wrapper">
                <% Html.RenderPartial("Controls/Footer.ascx"); %>
            </div>
        </div>
    </div>
</body>
</html>
