﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<PagingDataSet<UserVisit>>" %>

<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["MessageCenterMenuType"] = MessageCenterMenuType.Visit;  %>
  <% Html.RenderPartial("Controls/MessageCenters/MessageCenterMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="ListVisitor"
</asp:content>
<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName"); %>
  <%  %>
      
          <div id="listVisitor" class="tn-box tn-widget tn-widget-content tn-corner-all">
            <div class="tn-box-content tn-widget-content tn-corner-all" id="ListMessageInBoxDiv">
            <ul class="tn-list tn-helper-reset">
             <% 
                 Dictionary<int, User> visitor = ViewData["Visitor"] as Dictionary<int, User>;
                 foreach (UserVisit visit in ViewData.Model.Records)
                 {
                     User user = null;
                     visitor.TryGetValue(visit.VisitID, out user);
                     if (user == null)
                         continue;
                        %>
                <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
                  <div class="tn-list-item-area-left">
                    <div class="tn-avatar">
                       <%=SPBHtmlHelper.Instance().ShowUserAvatar(user.UserID, true, HyperLinkTarget._self, AvatarSizeTypes.Small, null)%>
                     </div>
                  </div>
                  <div class="tn-list-item-area-main">
                    <div class="tn-list-item-row tn-list-item-heading">
                      <h5 class="tn-helper-reset">
                      <a href="<%=SiteUrls.Instance().UserChannelHome(user.UserID, UserDomainSpecialAppIDs.Instance().Home()) %>"
                                    title="<%=user.DisplayName %>"> <%=SPBHtmlHelper.Instance().UserDisplayName(user) %></a>
                      </h5>
                    </div>
                    <div class="tn-list-item-row tn-text-note">
                    <% if (user.UserType == UserTypes.PersonUser) Response.Write(string.Format(GetResourceString("Description_Pattern_VisitorInfo", ApplicationIDs.Instance().User()), user.Rank, user.FriendCount, Formatter.FormatArea(((PersonUser)user).NowAreaCode, true)));
                       else Response.Write(Formatter.FormatArea(((CompanyUser)user).AreaCode, true));
                                 %>
                    &nbsp;&nbsp;&nbsp;&nbsp;
                    <%=GetResourceString("Label_LastVisitTime",ApplicationIDs.Instance().User()) %><%=GetResourceString("Common_Colon") %><%=Formatter.FormatDateToIntervalTime(visit.LastVisitTime)%>&nbsp;&nbsp;&nbsp;&nbsp;
                    <%=GetResourceString("Label_VisitTimes", ApplicationIDs.Instance().User())%><%=GetResourceString("Common_Colon") %><%=visit.VisitTimes %>
                    
                     </div>
                  </div>
                </li>
                
                <%} %>
 
              <div class="tn-pagination tn-helper-align-center"> <%=SPBHtmlHelper.Instance().PagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 11,SPBUrlHelper.Action("ListVisitor","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"pageIndex","{0}"}}))%> </div>
            </div>
          </div>
     
</asp:content>
<asp:content runat="server" contentplaceholderid="manageMenusContent">
 <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName"); %>
  <%  %>
    <div id="visitMenu" class="tn-box tn-widget tn-widget-content tn-corner-all">
            <%--<div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
              <h3 class="tn-helper-reset"><%=GetResourceString("Action_Manage")%></h3>
            </div>--%>
            <div class="tn-box-content tn-widget-content tn-corner-bottom">
              <ul class="tn-side-menu">
              
              <li class="tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ListVisitor","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"> <span><%=GetResourceString("Title_ListVisitor", ApplicationIDs.Instance().User())%></span></a> </li>
            <% if (ViewData.GetBool("IsUserDomainOwnerOrAdministrator", false))
               { %>
              <li><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ListVisited","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"> <span><%=GetResourceString("Title_ListVisited",ApplicationIDs.Instance().User()) %></span></a> </li>
              <%} %>
            </ul>
          </div>
          </div>
</asp:content>