﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage" %>

<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <%  ViewData["MessageCenterMenuType"] = MessageCenterMenuType.Message;               %>
    
  <% Html.RenderPartial("Controls/MessageCenters/MessageCenterMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server"> id="NewMessage" </asp:content>
<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent">
<spb:Script runat="server" ID="mouse" Src="~/Utility/jquery/ui.mouse.min-1.8.12.js"
    SetExpireDays="30" />
<spb:Script ID="Script1" runat="server" Src="~/Utility/jquery/ui.draggable.min-1.8.12.js"
    SetExpireDays="30" />
<spb:Script ID="Script2" runat="server" Src="~/Utility/jquery/ui.sortable.min-1.8.12.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="metadata" Src="~/Utility/jquery/plugin/jquery.metadata-2.1.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="tagIt" Src="~/Utility/jquery/plugin/jquery.autoSuggest-1.4.js"
    SetExpireDays="30" />
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName"); %>
  <div id="newMessage" class="tn-box tn-widget tn-widget-content tn-corner-all spb-new-message">
    <div class="tn-box-content tn-widget-content tn-corner-all">
      <%  bool isAllowed = ViewData.GetBool("IsAllowed", false);
          bool isMultiple = ViewData.GetBool("IsMultiple", false);
          User toUser = ViewData.Get<User>("ToUser", null); %>
      <% if (TempData["StatusMessageType"] != null)
         {
             StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
             if (messageType == StatusMessageType.Success)
                 Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
             else
                 Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
             Response.Write("<br/>");
             TempData["StatusMessageType"] = null;
         }
         System.Web.Script.Serialization.JavaScriptSerializer serializer = new System.Web.Script.Serialization.JavaScriptSerializer();
         string selectedUsersValue = "{}";
         if (toUser != null)
         {
             selectedUsersValue = serializer.Serialize(new List<object>{new
          {
              userID = toUser.UserID,
              displayName = toUser.DisplayName,
              commonName = toUser.CommonName,
              nickName = toUser.NickName,
              noteName = ""
          
          }});
         }
         string getUsersJosnUrl = SPBUrlHelper.Action("SearchUsers", "Channel");%>
      <form id="newMessageForm" name="newMessageForm" action="<%=SPBUrlHelper.Action("CreateMessage","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"
                method="post">
        <div class="tn-form tn-label-right spb-message-form">
          <div class="tn-form-row tn-write-tags tn-form-expanded tn-helper-clearfix">
            <label class="tn-form-label"><%=GetResourceString("Label_Receiver",ApplicationIDs.Instance().User()) %><%=GetResourceString("Common_Colon") %></label>
            <%string userID = string.Empty;
              if (isAllowed && !isMultiple && toUser != null)
                  userID = toUser.UserID.ToString();%>
            <%if (ViewData.GetBool("sendToServe", false))
              { %>
            <input type="text" readonly="readonly" name="" value="客服" class="tn-textbox tn-input-long tn-border-gray" disabled="disabled" />
            <input type="hidden" name="receiverIDs" value="<%=(int)PrivateMessageEspecialUserID.Serve %>" />
            <%}
              else
              { %>
              <div class="tn-expand-control">
                  <input type="text" id="receiverIDs" name="receiverIDs" value="" class="tn-textbox tn-input-long tn-border-gray" />
                  <%--<% Html.RenderAction<ChannelController>(n => n.Control_FriendSelector("receiverIDs", userID, 10)); %>--%>
              </div>
              <div class="tn-text-note"><%=GetResourceString("Message_NewMessageMaxReceiverNum", ApplicationIDs.Instance().User())%></div>
            <%} %>
          </div>
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_Subject",ApplicationIDs.Instance().User())%><%=GetResourceString("Common_Colon") %></label>
            <input type="text" id="subject" name="subject" class="tn-textbox tn-input-longest tn-border-gray" value="<%=TempData.GetString("subject", string.Empty)%>" maxlength="128" />
          </div>
          <div class="tn-form-row tn-emotion-box tn-textarea-wrap">
            <label class="tn-form-label"> <%=GetResourceString("Label_Body")%><%=GetResourceString("Common_Colon") %> </label>
            <div class="tn-emotion-textarea">
              <%  Html.RenderAction<ChannelController>(n => n.Control_SmileySelector("smiley", "body"));%>
              <textarea name="body" id="body" cols="80" rows="8" class="tn-textarea tn-input-longest tn-border-gray"><%=TempData.GetString("body", string.Empty)%></textarea>
              <span style="display:none"></span>
            </div>
            <div class="tn-text-note tn-helper-clear"><%=GetResourceString("Message_NewMessageMaxBobyHint",ApplicationIDs.Instance().User())%> </div>
          </div>
          <div class="tn-form-row tn-form-row-button">
            <label class="tn-form-label">&nbsp;</label>
            <%=SPBHtmlHelper.Instance().SubmitButton("sendButton", GetResourceString("Button_Send"))%>
            <% if (Request.UrlReferrer != null)
               {%>
            <%=SPBHtmlHelper.Instance().CancelButton(Request.UrlReferrer.AbsoluteUri) %>
            <%}

                           %>
          </div>
        </div>
      </form>
    </div>
  </div>
  <script type="text/javascript">
        $(document).ready(function() {
            $("#newMessageForm").validate({
                rules: {
                    subject: { required: true, rangelength: [1, 30] },
                    body: { required: true,maxBlength:3000 }
                },
                messages: {
                    subject: { required: "<%=GetResourceString("Validate_NewMessageSubjectEmpty",ApplicationIDs.Instance().User()) %>", rangelength: "<%=string.Format(GetResourceString("Validate_Pattern_NewMessageSubjectMaxLength",ApplicationIDs.Instance().User()),30) %>" },
                    body: { required: "内容不可为空！",maxBlength:"最多可输入3000个字" }
                }
            });

            $("#receiverIDs").autoSuggest("<%=getUsersJosnUrl %>", 
            {
            asHtmlID:"receiverIDs",
            minChars: 1,
            keyDelay: 600,
            selectionLimit:100,
            selectedItemProp: "displayName",
            selectedValuesProp: "userID",
            searchObjProps: "displayName,commonName,nickName,noteName",
            enableManualAdd: true,
            preFill:<%=selectedUsersValue %>,
            formatList: function(data, elem) {
                var new_elem = elem.html("<a href=\"javascript:;\"><img src=\"" + data.userAvatarUrl + "\" width=\"22px\">" + data.displayName + "</a>");
                    return new_elem;
                }
            });

            $('#getReceivers').nyroModal({
                resizeable: true,
                endShowContent: function(elts, settings) {
                    $('#submitButton', elts.contentWrapper).click(function(e) {
                        e.preventDefault();
                        var receiverDispalyNames = new Array();
                        var receiverIDs = new Array();
                        $('input[checked][name="userSelectorCheckBox"]', elts.contentWrapper).each(function(i) {
                            var result = eval('(' + $(this).val() + ')');
                            receiverIDs[i] = result.userid;
                            receiverDispalyNames[i] = result.displayname;
                        });
                        $("#receiverDispalyNames").attr("value", receiverDispalyNames.toString());
                        $("#receiverIDs").attr("value", receiverIDs.toString());
                        $.nyroModalRemove();
                    });
                }
            });
        });
    </script>
</asp:content>
<asp:content runat="server" contentplaceholderid="manageMenusContent">
  <% 
      int toUserID = Html.GetParameterFromRouteDateOrQueryString<int>("toUserID");
      Html.RenderAction<MessageCenterController>(n => n.Control_PrivateMessageMenu(Html.GetParameterFromRouteDateOrQueryString("UserDomainName"), toUserID == (int)PrivateMessageEspecialUserID.Serve?PrivateMessageMenuType.MessageToService: PrivateMessageMenuType.CreateMessage));
         
      
       %>
      
</asp:content>
