﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<List<MsnFriend>>" %>

<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["MessageCenterMenuType"] = MessageCenterMenuType.Invitation;  %>
  <% Html.RenderPartial("Controls/MessageCenters/MessageCenterMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="InvitationMSNFriendsResult"
</asp:content>
<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent">
  <% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("UserDomainName"); %>
          <div id="invitationResult" class="tn-box tn-widget tn-widget-content tn-corner-all">
            <div id="ListInvitationInBoxDiv" class="tn-box-content tn-widget-content tn-corner-all">
              <% if (TempData["StatusMessageType"] != null)
                 {
                     StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                     if (messageType == StatusMessageType.Success)
                         Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
                     else
                         Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
                     TempData["StatusMessageType"] = null;
                 }
                 string siteName = ViewData.GetString("SiteName", string.Empty);
                    %>
              <form id="invitationMSNFriendForm" name="invitationMSNFriendForm" method="post" action="<%=SPBUrlHelper.Action("InvitationMSNFriendsAction","MessageCenter",new RouteValueDictionary(){{"userDomainName",userDomainName}}) %>">
                <table  class="tn-table-grid">
                  <tr class="tn-table-grid-header">
                    <th class="tn-border-gray tn-border-bottom tn-text-note"> <input type="checkbox" id="checkAllCheckBox" class="tn-checkbox" onclick="checkAll(this,'userSelectorCheckBox')" />
                      <label for="checkAllCheckBox"><%=GetResourceString("Label_SelectAllOrNo")%></label>
                    </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_MsnFriendName",ApplicationIDs.Instance().User()) %> </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_MsnFriendEmail", ApplicationIDs.Instance().User())%> </th>
                    <%--<th class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Lable_IsRegisterUser")%> </th>--%>
                  </tr>
                  <% int i = 0;
                     foreach (MsnFriend friend in Model)
                     {%>
                  <tr class="tn-table-grid-row">
                    <td class="tn-border-gray tn-border-bottom tn-width-check">
                          <input type="checkbox" class="tn-checkbox" id="userSelectorCheckBox-<%=i %>" name="userSelectorCheckBox"
                    value="<%=friend.Email %>" />
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><label for="userSelectorCheckBox-<%=i %>"> <%=friend.Name.Trim() %></label>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><label> <%=friend.Email %></label>
                    </td>
                    <%--<td class="tn-border-gray tn-border-bottom tn-nowrap"><label>
                    <%if (false)
                      { %>
                    <a href="#">进入空间</a>
                    <%}
                      else
                      {%>
                    未注册
                    <%} %>
                    </label>
                    </td>--%>
                  </tr>
                  <%} %>
                </table>
                <div class="form">
                  <div class="formRow">
                    <div class="formLabel">
                      <label> <%=GetResourceString("Label_InvitMsnFriendSendMsg",ApplicationIDs.Instance().User()) %><%=GetResourceString("Common_Colon") %></label>
                    </div>
                    <div class="formField tn-textarea-wrap">
                      <textarea id="invitationBody" class="textareaBox" rows="5" cols="60" name="invitationBody"></textarea>
                      <span style="display:none"></span>
                    </div>
                  </div>
                  <div class="formRow">
                    <div class="formButton">
                      <input type="submit"  id="submitButton" value="<%=GetResourceString("Button_OK")%>" />
                      <a class="cancel" href="<%=SiteUrls.Instance().NewFriendInvitationByEmail(userDomainName) %>"><%=GetResourceString("Button_Cancel")%></a> </div>
                  </div>
                </div>
              </form>
            </div>
          </div>

  <script type="text/javascript">
        $(document).ready(function() {
            $("#submitButton").click(function() {
                if (!$("input[type='checkbox']:checked").length) {
                    alert("<%=GetResourceString("Validate_SelectedInvitFriendEmpty",ApplicationIDs.Instance().User()) %>");
                    return false;
                }
                else {
                    $("#submitButton").val('<%=GetResourceString("Message_Loading")%>');
                    
                }
            });
        });
    </script>
  
</asp:content>
<asp:content runat="server" contentplaceholderid="manageMenusContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName"); %>

            <% Html.RenderAction<MessageCenterController>(n => n.Control_InvitationMenu(userDomainName, InvitationMenuType.CreateInvitation)); %>
  
  </asp:content>
