﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<PagingDataSet<ConvertibleGiftExchangeApply>>" %>
<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["MessageCenterMenuType"] = MessageCenterMenuType.Point;  %>
  <% Html.RenderPartial("Controls/MessageCenters/MessageCenterMenu.ascx", ViewData); %>
</asp:content>

<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server"> id="ListGiftExchangeApplies" </asp:content>
<asp:content runat="server" contentplaceholderid="manageMenusContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int userApplicationID = ApplicationIDs.Instance().User();%>
  <div id="pointMune" class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
      <ul class="tn-side-menu">
        <li id="BasicPointLi"  ><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ListPointRecords","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"pointCategory",UserPointCategory.Basic}}) %>"
                            id="BasicPoint"><span><%=GetResourceString("Enum_UserPointCategory_BasicPoint")%></span></a> </li>
        <li id="ReportPointLi" ><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ListPointRecords", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, { "pointCategory", UserPointCategory.Report } })%>"
                            id="ReportPoint"><span><%=GetResourceString("Enum_UserPointCategory_ReportPoint")%></span></a> </li>
<%--        <li id="CreditPointLi" ><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ListPointRecords", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, { "pointCategory", UserPointCategory.Credit } })%>"
                            id="CreditPoint"><span><%=GetResourceString("Enum_UserPointCategory_CreditPoint")%></span></a> </li>--%>
        <li id="TradePointLi" ><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ListPointRecords", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, { "pointCategory", UserPointCategory.Trade } })%>"
                            id="TradePoint"><span><%=GetResourceString("Enum_UserPointCategory_TradePoint")%></span></a> </li>
        <li id="AllPointLi"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("TotalUserPoints","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"
                            id="AllPoint"><span><%=GetResourceString("Label_AllPointSum", userApplicationID)%></span></a> </li>
        <li id="GiftExchangeRocordsLi"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ListGiftExchangeRocords","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>" id="GiftExchangeRocords"><span><%=GetResourceString("Label_MyGiftExchangeForRecord", userApplicationID)%></span></a></li>
        <li id="GiftExchangeAppliesLi" class="tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageGiftExchangeApplies","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>" id="GiftExchangeApplies"><span><%=GetResourceString("Label_ManageGiftsExchange", userApplicationID)%></span></a></li>
      </ul>
    </div>
  </div>
</asp:content>
<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int userApplicationID = ApplicationIDs.Instance().User();
 %>
  <div id="exchangeApplies" class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-content tn-widget-content tn-corner-all">
      <table class="tn-table-grid">
        <tr class="tn-table-grid-header">
          <th  class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Label_GiftName",userApplicationID)%></th>
          <th class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Label_BuyingNumber", userApplicationID)%> </th>
          <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_NeedPoints",userApplicationID) %> </th>
          <th class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Label_ApplyStatues", userApplicationID)%> </th>
          <th class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("operate",userApplicationID) %></th>
        </tr>
        <%foreach (ConvertibleGiftExchangeApply apply in ViewData.Model.Records)
                  {
                      if (apply.ApplyStatus != ConvertibleGiftExchangeApplyStatuses.Refuse && apply.ApplyStatus != ConvertibleGiftExchangeApplyStatuses.Canceled && apply != null)
                      {
                      %>
        <tr class="tn-table-grid-row">
          <td class="tn-border-gray tn-border-bottom tn-width-auto"><a href="<%=SPBUrlHelper.Action("ShowGift", "ChannelConvertibleGift",new RouteValueDictionary {{"giftID",apply.GiftID}})%>"><%=ConvertibleGifts.GetGift(apply.GiftID, false).Subject%></a></td>
          <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap"><%=apply.TotalCount%></td>
          <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap"><%=apply.Price%></td>
          <td class="tn-border-gray tn-border-bottom tn-width-status tn-nowrap"><%switch (apply.ApplyStatus)
                                                                                         {
                                                                                             case ConvertibleGiftExchangeApplyStatuses.Accept:
                                                                                                 Response.Write(GetResourceString("Label_ShipmentsHas", userApplicationID));
                                                                                                 break;
                                                                                             case ConvertibleGiftExchangeApplyStatuses.Unsettled:
                                                                                                 Response.Write(GetResourceString("Label_WaitToDeal", userApplicationID));
                                                                                                 break;
                                                                                             case ConvertibleGiftExchangeApplyStatuses.Refuse:
                                                                                                 Response.Write(GetResourceString("Label_HasRefused", userApplicationID));
                                                                                                 break;
                                                                                             default:
                                                                                                 break;
                                                                                         } %></td>
          <td class="tn-border-gray tn-border-bottom tn-width-action2 tn-nowrap"><%if (apply.ApplyStatus == ConvertibleGiftExchangeApplyStatuses.Unsettled)
                         {%>
            <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Button_ApplyCancel", userApplicationID), SPBUrlHelper.Action("CancelGiftExchangeApply", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, { "applyID", apply.ApplyID } }), ButtonSizes.Default, HighlightStyles.Default)%> 
            <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Button_AppliUpdate", userApplicationID), SPBUrlHelper.Action("Control_EditGiftApply", "ChannelConvertibleGift", new RouteValueDictionary { { "applyID", apply.ApplyID } }), ButtonSizes.Default, HighlightStyles.Primary, null, TextIconLayout.TextOnly, new RouteValueDictionary { { "class", "nyroModal" } }, null)%>
            <%} %></td>
        </tr>
        <%}
                  }%>
      </table>
      <div class="tn-pagination tn-helper-align-center">
        <%
                 Response.Write(SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 11, null));
        %>
      </div>
    </div>
  </div>
  <script type="text/javascript">

          $(document).ready(function() {
              $('a.nyroModal').nyroModal({
                  resizeable: true,
                  width: 300,
                  height: 400
              });
          });

</script>
</asp:content>
