﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<PagingDataSet<ConvertibleGiftExchangeRecord>>" %>
<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["MessageCenterMenuType"] = MessageCenterMenuType.Point;  %>
  <% Html.RenderPartial("Controls/MessageCenters/MessageCenterMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="ListGiftExchangeRocords"
</asp:content>
<asp:content runat="server" contentplaceholderid="manageMenusContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int userApplicationID = ApplicationIDs.Instance().User(); %>
  <div id="pointMune" class="tn-box tn-widget tn-widget-content tn-corner-all">
            <%--<div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
              <h3 class="tn-helper-reset"><%=GetResourceString("Action_Manage")%></h3>
            </div>--%>
            <div class="tn-box-content tn-widget-content tn-corner-bottom">
              <ul class="tn-side-menu">
              <li id="BasicPointLi"  ><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ListPointRecords","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"pointCategory",UserPointCategory.Basic}}) %>"
                            id="BasicPoint"><span><%=GetResourceString("Enum_UserPointCategory_BasicPoint")%></span></a> </li>
              <li id="ReportPointLi" ><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ListPointRecords", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, { "pointCategory", UserPointCategory.Report } })%>"
                            id="ReportPoint"><span><%=GetResourceString("Enum_UserPointCategory_ReportPoint")%></span></a> </li>
             <%-- <li id="CreditPointLi" ><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ListPointRecords", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, { "pointCategory", UserPointCategory.Credit } })%>"
                            id="CreditPoint"><span><%=GetResourceString("Enum_UserPointCategory_CreditPoint")%></span></a> </li>--%>
              <li id="TradePointLi" ><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ListPointRecords", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, { "pointCategory", UserPointCategory.Trade } })%>"
                            id="TradePoint"><span><%=GetResourceString("Enum_UserPointCategory_TradePoint")%></span></a> </li>
              <li id="AllPointLi"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("TotalUserPoints","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"
                            id="AllPoint"><span><%=GetResourceString("Label_AllPointSum", userApplicationID)%></span></a> </li>
              <li id="GiftExchangeRocordsLi" class="tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all" ><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ListGiftExchangeRocords","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>" id="GiftExchangeRocords"><span><%=GetResourceString("Label_MyGiftExchangeForRecord", userApplicationID)%></span></a></li>
              <li id="GiftExchangeAppliesLi" ><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageGiftExchangeApplies","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>" id="GiftExchangeApplies"><span><%=GetResourceString("Label_ManageGiftsExchange",userApplicationID)%></span></a></li>
              </ul>
            </div>
          </div>
  </asp:content>

<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int userApplicationID = ApplicationIDs.Instance().User();
 %>

          <div id="exchageRocaords" class="tn-box tn-widget tn-widget-content tn-corner-all">
            <div class="tn-box-content tn-widget-content tn-corner-all">
               <table class="tn-table-grid">
                <tr class="tn-table-grid-header">
                  <th class="tn-border-gray tn-border-bottom  tn-text-note"><%=GetResourceString("Label_Description")%></th>
                  <th class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Label_Date")%> </th>

                </tr>
                <%foreach (ConvertibleGiftExchangeRecord record in ViewData.Model.Records)
                  {
                      if (record.GiftID > 0 && record != null)
                      {%>
               <tr class="tn-table-grid-row">

                 <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=string.Format(GetResourceString("Label_SpendPointForBuy",userApplicationID),record.Price)%><a href="<%=SPBUrlHelper.Action("ShowGift", "ChannelConvertibleGift",new RouteValueDictionary {{"giftID",record.GiftID}})%>"><%=ConvertibleGifts.GetGift(record.GiftID, false).Subject%></a><%=record.TotalCount%><%=GetResourceString("Label_ge",userApplicationID)%></td>
                 <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=Formatter.FormatDate(record.DateCreated,true)%></td>
                </tr>
                <%}
                  }%>
            </table>
            <div class="tn-pagination tn-helper-align-center"> <%=SPBHtmlHelper.Instance().PagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 11, SPBUrlHelper.Action("ListGiftExchangeRocords", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, { "pageIndex", "{0}" } }))%>
                <div class=" tn-page-results tn-text-note"><%=string.Format(GetResourceString("Label_Pattern_TotalRecords", userApplicationID), ViewData.Model.TotalRecords)%></div>
              </div>
            </div>
            </div>
       
</asp:content>
