﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<PagingDataSet<UserPointRecord>>" %>

<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["MessageCenterMenuType"] = MessageCenterMenuType.Point;  %>
  <% Html.RenderPartial("Controls/MessageCenters/MessageCenterMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="ListPointRecords"
</asp:content>
<asp:content runat="server" contentplaceholderid="manageMenusContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int userApplicationID = ApplicationIDs.Instance().User(); %>
  <div id="pointMune" class="tn-box tn-widget tn-widget-content tn-corner-all">
            <%--<div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
              <h3 class="tn-helper-reset"><%=GetResourceString("Action_Manage")%></h3>
            </div>--%>
            <div class="tn-box-content tn-widget-content tn-corner-bottom">
              <ul class="tn-side-menu">
              <% UserPointCategory pointCategory = ViewData["PointCategory"] != null ? (UserPointCategory)ViewData["PointCategory"] : UserPointCategory.Basic; %>
              <li id="BasicPointLi" <%if(UserPointCategory.Basic==pointCategory){Response.Write("class='tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all'");} %>> <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ListPointRecords","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"pointCategory",UserPointCategory.Basic}}) %>" id="BasicPoint"><%=GetResourceString("Enum_UserPointCategory_BasicPoint")%></a> </li>
              <li id="ReportPointLi" <%if(UserPointCategory.Report==pointCategory){Response.Write("class='tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all'");}  %>> <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ListPointRecords", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, { "pointCategory", UserPointCategory.Report } })%>" id="ReportPoint"><%=GetResourceString("Enum_UserPointCategory_ReportPoint")%></a> </li>
<%--  隐藏信誉积分            <li id="CreditPointLi" <%if(UserPointCategory.Credit==pointCategory){Response.Write("class='tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all'");}  %>> <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ListPointRecords", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, { "pointCategory", UserPointCategory.Credit } })%>" id="CreditPoint"><%=GetResourceString("Enum_UserPointCategory_CreditPoint")%></a> </li>
--%>              <li id="TradePointLi" <%if(UserPointCategory.Trade==pointCategory){Response.Write("class='tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all'");}  %>> <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ListPointRecords", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, { "pointCategory", UserPointCategory.Trade } })%>" id="TradePoint"><%=GetResourceString("Enum_UserPointCategory_TradePoint")%></a> </li>
              <li id="AllPointLi"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("TotalUserPoints","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>" id="AllPoint"><%=GetResourceString("Label_AllPointSum", userApplicationID)%></a></li>
              
              <li id="GiftExchangeRocordsLi"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ListGiftExchangeRocords","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>" id="GiftExchangeRocords"><%=GetResourceString("Label_MyGiftExchangeForRecord", userApplicationID)%></a></li>
              <li id="GiftExchangeAppliesLi"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageGiftExchangeApplies","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>" id="GiftExchangeApplies"><%=GetResourceString("Label_ManageGiftsExchange",userApplicationID)%></a></li>
            </ul>
            </div>
          </div>
  </asp:content>
<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int userApplicationID = ApplicationIDs.Instance().User();
UserPointCategory pointCategory = ViewData["PointCategory"] != null ? (UserPointCategory)ViewData["PointCategory"] : UserPointCategory.Basic; %>
          <div id="pointRecords" class="tn-box tn-widget tn-widget-content tn-corner-all">
            <div class="tn-box-content tn-widget-content tn-corner-all">
                        <% if (pointCategory == UserPointCategory.Trade)
                           {%>
           <div class="tn-blank10"></div>
              <div class="tn-list-header">
            <div class="tn-filter-controls tn-helper-clearfix tn-border-gray tn-border-bottom">
         <div class="tn-helper-align-right tn-helper-right"> 
            <%=GetResourceString("Action_View")%><%=GetResourceString("Common_Colon") %>
            <span <%if(ViewData["PointDirection"]==null){Response.Write("class='tn-action tn-text-note tn-selected'");} else {Response.Write("class='tn-action'");}  %>>
            <a href="<%=SPBUrlHelper.Action("ListPointRecords","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"pointCategory",UserPointCategory.Trade}}) %>"  id="AllTradePoint"><%=GetResourceString("Label_AllTradePoint", userApplicationID)%></a>
            </span>
            <span  <%if(ViewData["PointDirection"]!=null&&(UserPointDirection)ViewData["PointDirection"]==UserPointDirection.Input){Response.Write("class='tn-action tn-text-note tn-selected'");} else {Response.Write("class='tn-action'");}  %> >
            <a href="<%=SPBUrlHelper.Action("ListPointRecords","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"pointCategory",UserPointCategory.Trade},{"pointDirection",UserPointDirection.Input}}) %>"id="InputTradePoint"><%=GetResourceString("Label_InputTradePoint", userApplicationID)%></a>
            </span>
            <span <%if(ViewData["PointDirection"]!=null&&(UserPointDirection)ViewData["PointDirection"]==UserPointDirection.Output){Response.Write("class='tn-action tn-text-note tn-selected'");} else {Response.Write("class='tn-action'");}  %>>
            <a href="<%=SPBUrlHelper.Action("ListPointRecords", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, { "pointCategory", UserPointCategory.Trade }, { "pointDirection", UserPointDirection.Output } })%>"  id="OutputTradePoint"><%=GetResourceString("Label_OutputTradePoint", userApplicationID)%></a>
            </span>
            </div> <div class="tn-blank10"></div>   
                    </div>
            </div>
            <%} %>
               <table class="tn-table-grid">
               <tbody>
                <tr class="tn-table-grid-header">
                  <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_Date") %> </th>
                  <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_PointCategory",userApplicationID) %> </th>
                  <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_PointAmount", userApplicationID)%> </th>
                  <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_Description")%> </th>
                </tr>
                <% foreach (UserPointRecord record in ViewData.Model.Records)
                   {%>
               <tr class="tn-table-grid-row">
                  <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap"><%=Formatter.FormatDate(record.CreateDate,false) %> </td>
                  <td  class="tn-border-gray tn-border-bottom tn-nowrap"><%=record.PointItemName %> </td>
                  <td  class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap"><%=record.Points %>
                  </td>
                  <td class="tn-border-gray tn-border-bottom tn-nowrap" title="<%=record.Description %>"> <%=StringUtils.Trim(record.Description,20) %> </td>
                </tr>
                <%} %>
                </tbody>
            </table>
            <div class="tn-pagination tn-helper-align-center"> <%=SPBHtmlHelper.Instance().PagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 11,SPBUrlHelper.Action("ListPointRecords","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"pointCategory",pointCategory},{"pointDirection",ViewData["PointDirection"]},{"pageIndex","{0}"}}))%>
                <div class="tn-page-results tn-text-note"><%=string.Format(GetResourceString("Label_Pattern_TotalRecords", userApplicationID), ViewData.Model.TotalRecords)%></div>
              </div>
            </div>
            </div>

</asp:content>
