﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage" %>
<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["MessageCenterMenuType"] = MessageCenterMenuType.Invitation;  %>
  <% Html.RenderPartial("Controls/MessageCenters/MessageCenterMenu.ascx", ViewData); %>
</asp:content>

<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server"> id="NewFriendInvitationByEmail" </asp:content>
<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent">
  <spb:Script runat="server" ID="CollapsibleBox" Src="~/Utility/jquery/plugin/jquery.spb.CollapsibleBox.js"
        SetExpireDays="30" />
  <% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("UserDomainName");
     
    %>
  <div id="newFriendInvitationByEmail" class="tn-box tn-widget tn-widget-content tn-corner-all spb-send-invite">
    <div class="tn-box-content tn-widget-content tn-corner-all">
      <% if (TempData["StatusMessageType"] != null)
                 {
                     StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                     if (messageType == StatusMessageType.Success)
                         Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
                     else
                         Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
                     TempData["StatusMessageType"] = null;
                 }
                 string siteName = ViewData.GetString("SiteName", string.Empty);%>
      <div class="tn-collapsible tn-collapsible-opened">
        <div class="tn-border-bottom tn-border-gray tn-collapsible-header">
          <h4 class="tn-helper-reset"><a href="#"><%=GetResourceString("Title_MsnInvitation",ApplicationIDs.Instance().User()) %></a></h4>
        </div>
        <div class="tn-collapsible-content" style="display:block;">
          <form id="msnLoginForm" name="msnLoginForm" method="post" action="<%=SPBUrlHelper.Action("InvitationMSNFriends", "MessageCenter", new RouteValueDictionary() { { "userDomainName", userDomainName } })%>">
            <%=SPBHtmlHelper.Instance().StatusMessage(StatusMessageType.Hint,GetResourceString("Description_MsnInvitInfoHint",ApplicationIDs.Instance().User())) %>
            <div class="tn-blank10"></div>
            <div class="tn-form tn-label-right">
              <div class="tn-form-row">
                <label class="tn-form-label"> <%=GetResourceString("Label_MsnInvitAccount",ApplicationIDs.Instance().User()) %><%=GetResourceString("Common_Colon") %></label>
                <input type="text" id="msnUserName" name="msnUserName" value="<%=TempData.GetString("msnUserName",string.Empty) %>"
                                        class="tn-textbox tn-input-long tn-border-gray" />
              </div>
              <div class="tn-form-row">
                <label class="tn-form-label"> <%=GetResourceString("Label_MsnInvitAccountPwd", ApplicationIDs.Instance().User())%><%=GetResourceString("Common_Colon") %></label>
                <input type="password"  id="msnPassword" name="msnPassword" value="<%=TempData.GetString("msnPassword",string.Empty) %>"
                                        class="tn-textbox tn-input-long tn-border-gray" />
              </div>
              <div class="tn-form-row">
                <div class="tn-text-note"> <%=string.Format(GetResourceString("Description_Pattern_MsnInvitSiteDeclaration",ApplicationIDs.Instance().User()),siteName) %> </div>
              </div>
              <div class="tn-form-row tn-form-row-button">
                <label class="tn-form-label"></label>
                <%=SPBHtmlHelper.Instance().SubmitButton("msnSumbitButton", GetResourceString("Action_InvitationFriend"),ButtonSizes.Default,null,null) %> </div>
            </div>
          </form>
        </div>
      </div>
      <div class="tn-collapsible tn-collapsible-opened">
        <div class="tn-border-bottom tn-border-gray tn-collapsible-header">
          <h4 class="tn-helper-reset"><a href="javascript:;"><%=GetResourceString("Title_InvitatByHyperLink",ApplicationIDs.Instance().User()) %></a></h4>
        </div>
        <div class="tn-collapsible-content" style="display:block;"> <%=SPBHtmlHelper.Instance().StatusMessage(StatusMessageType.Hint, string.Format(GetResourceString("Message_Pattern_MsnInvitForCopyUrlDescription", ApplicationIDs.Instance().User()), siteName))%>
          <div class="tn-blank10"></div>
          <input name="textfield" type="text" class="tn-textbox tn-input-long tn-border-gray" id="textfield" value="<%=WebUtils.FullPath( SiteUrls.Instance().InviteFriendAction(CurrentUser.UserID))%>" />
          <a href="javascript:;" onclick="javascript:setCopy('<%=WebUtils.FullPath( SiteUrls.Instance().InviteFriendAction(CurrentUser.UserID))%>');return false;"
                    title="<%=GetResourceString("Description_CopyInvitUrlDescription",ApplicationIDs.Instance().User()) %>" ><%=GetResourceString("Action_CopyInvitUrl",ApplicationIDs.Instance().User()) %></a></div>
      </div>
      <div class="tn-collapsible tn-collapsible-opened">
        <div class="tn-border-bottom tn-border-gray tn-collapsible-header">
          <h4 class="tn-helper-reset"><a href="#"><%=GetResourceString("Title_EmailNewInvitation",ApplicationIDs.Instance().User()) %></a> </h4>
        </div>
        
        <div class="tn-collapsible-content" style="display:block;">
          <form id="newFriendInvitationByEmailForm" name="newFriendInvitationByEmailForm" action="<%=SPBUrlHelper.Action("CreateFriendInvitationByEmail","MessageCenter",new RouteValueDictionary(){{"userDomainName",userDomainName},{"toEmail",Request.QueryString.GetString("ToEmail",string.Empty)}}) %>"
                            method="post">
            <div class="tn-form tn-label-top">
              <div class="tn-form-row">
                <label class="tn-form-label"> <%=GetResourceString("Label_Receiver",ApplicationIDs.Instance().User()) %><%=GetResourceString("Common_Colon") %></label>
                <textarea class="tn-textarea tn-input-longest tn-border-gray" id="receivers" name="receivers"><%=Request.QueryString.GetString("Tomail",string.Empty)%></textarea>
                <div class="tn-text-note"><%=GetResourceString("Description_NewFriendInvitByEmailHint",ApplicationIDs.Instance().User()) %></div>
              </div>
              <div class="tn-form-row tn-textarea-wrap">
                <label class="tn-form-label"><%=GetResourceString("Label_InvitMsnFriendSendMsg", ApplicationIDs.Instance().User())%><%=GetResourceString("Common_Colon") %></label>
                <textarea name="invitationBody" class="tn-textarea tn-input-longest tn-border-gray" id="invitationBody"><%=TempData.GetString("invitationBody", string.Empty)%></textarea>
                <span style="display:none"></span>
              </div>
              <div class="tn-form-row tn-form-row-button">
                <label class="tn-form-label"></label>
                <%=SPBHtmlHelper.Instance().SubmitButton("sendInvitation",GetResourceString("Button_Send"),ButtonSizes.Default,null,null) %>
                <% if (Request.UrlReferrer != null)
                             {%>
                <%=SPBHtmlHelper.Instance().CancelButton(ButtonSizes.Default, Request.UrlReferrer.AbsoluteUri)%>
                <%} %>
              </div>
              <div class="tn-form-row">
                <label class="tn-form-label"><%=GetResourceString("Label_InvitEmailBodyPreview",ApplicationIDs.Instance().User()) %><%=GetResourceString("Common_Colon") %></label>
                <%=ViewData.GetString("subject",string.Empty) %> <%=ViewData.GetString("body",string.Empty) %> </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
  <script type="text/javascript">
        $(document).ready(function() {
           		$(".tn-collapsible").collapsibleBox();

            $("#msnLoginForm").validate({
                rules: {
                    msnUserName: { required: true, email: true },
                    msnPassword: { required: true }
                },
                messages: {
                    msnUserName: { required: "<%=GetResourceString("Message_MsnInvitErrorForAccountEmpty", ApplicationIDs.Instance().User())%>", email: "<%=GetResourceString("Validate_MsnAccountlFormatError", ApplicationIDs.Instance().User())%>" },
                    msnPassword: { required: "<%=GetResourceString("Message_MsnInvitErrorForPasswordEmpty", ApplicationIDs.Instance().User())%>" }
                }
            });
            $("#msnSumbitButton").click(function() {
                if (!$("#msnLoginForm").valid()) {
                    return false;
                }
                else {
                    $("#msnSumbitButton").val('<%=GetResourceString("Message_Loading")%>');
                 
                }
            });

            $("#newFriendInvitationByEmailForm").validate({
                rules: {
                    receivers: { required: true },
                    subject: { required: true, rangelength: [1, 30] },
                    body: { htmlEditorRequired: true, htmlEditorRange: [1, 3000] }
                },
                messages: {
                    receivers: { required: "<%=GetResourceString("Message_SendErrorForReceiverEmpty", ApplicationIDs.Instance().User())%>"},
                    subject: { required: "<%=GetResourceString("Message_SendErrorForSubjectEmpty", ApplicationIDs.Instance().User())%>", rangelength: "<%=string.Format(GetResourceString("Message_SendErrorForReceiverEmpty", ApplicationIDs.Instance().User()),30)%>" },
                    body: { htmlEditorRequired: "<%=GetResourceString("Message_SendErrorForBodyEmpty", ApplicationIDs.Instance().User())%>", htmlEditorRange: "<%=string.Format(GetResourceString("Message_SendErrorForReceiverEmpty", ApplicationIDs.Instance().User()),3000)%>" }
                }
            });
            $("#sendInvitation").click(function() {
                if (!$("#newFriendInvitationByEmailForm").valid()) {
                    return false;
                }
                else {
                    $("#sendInvitation").val('<%=GetResourceString("Message_Loading")%>');
                }
            });

            $("#requestTemplateDropdownlist").children(":first").attr("selected", "selected");

            $("#requestTemplateDropdownlist").change(function() {
                var selectedvalue = $("#requestTemplateDropdownlist").children("[selected]").attr("value");

                $.get('<%=SPBUrlHelper.Action("GetInvitationTemplate","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>', { templateName: selectedvalue },
                    function(data) {
                        var result = eval('(' + data + ')');
                        $("#subject").attr("value", result.subject);
                        //tinyMCE.activeEditor.setContent(result.body);
                        $("#body").text(result.body);
                    }
                 );
            });
            $("#requestTemplateDropdownlist").change();
        }); 
    </script>
</asp:content>
<asp:content runat="server" contentplaceholderid="manageMenusContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName"); %>
  <% Html.RenderAction<MessageCenterController>(n => n.Control_InvitationMenu(userDomainName, InvitationMenuType.CreateInvitation)); %>
</asp:content>
